/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.gui;

import com.google.common.collect.Lists;
import java.util.List;
import nc.gui.NCGui;
import nc.gui.element.GuiFluidRenderer;
import nc.gui.element.NCButton;
import nc.multiblock.container.ContainerSaltFissionVessel;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.salt.tile.TileSaltFissionVessel;
import nc.network.PacketHandler;
import nc.network.gui.EmptyFilterTankPacket;
import nc.network.gui.EmptyTankPacket;
import nc.tile.internal.fluid.Tank;
import nc.util.Lang;
import nc.util.NCUtil;
import nc.util.UnitHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSaltFissionVessel
extends NCGui {
    protected final TileSaltFissionVessel vessel;
    protected final ResourceLocation gui_textures;

    public GuiSaltFissionVessel(EntityPlayer player, TileSaltFissionVessel vessel) {
        super(new ContainerSaltFissionVessel(player, vessel));
        this.vessel = vessel;
        this.gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/salt_fission_vessel.png");
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        this.drawTooltip(this.vessel.clusterHeatCapacity >= 0L ? this.heatInfo() : this.noClusterInfo(), mouseX, mouseY, 8, 6, 16, 74);
        this.drawFilteredFluidTooltip(this.vessel.getTanks().get(0), this.vessel.getFilterTanks().get(0), mouseX, mouseY, 56, 35, 16, 16);
        this.drawFilteredFluidTooltip(this.vessel.getTanks().get(1), this.vessel.getFilterTanks().get(1), mouseX, mouseY, 112, 31, 24, 24);
    }

    public List<String> heatInfo() {
        String heat = UnitHelper.prefix(this.vessel.clusterHeatStored, this.vessel.clusterHeatCapacity, 5, "H");
        return Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + Lang.localise("gui.nc.container.salt_fission_vessel.heat_stored") + TextFormatting.WHITE + " " + heat});
    }

    public List<String> noClusterInfo() {
        return Lists.newArrayList((Object[])new String[]{TextFormatting.RED + Lang.localise("gui.nc.container.no_cluster")});
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int fontColor = this.vessel.getMultiblock() != null && ((FissionReactor)this.vessel.getMultiblock()).isReactorOn ? -1 : 0xEEAA00;
        String s = Lang.localise("gui.nc.container.salt_fission_vessel.vessel");
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, fontColor);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        Tank filterTank = this.vessel.getFilterTanks().get(0);
        if (!filterTank.isEmpty()) {
            GuiFluidRenderer.renderGuiTank(filterTank.getFluid(), 1000, 1000, this.field_147003_i + 56, this.field_147009_r + 35, this.field_73735_i, 16.0, 16.0, 127);
        }
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        if (this.vessel.clusterHeatCapacity >= 0L) {
            int e = (int)Math.round(74.0 * (double)this.vessel.clusterHeatStored / (double)this.vessel.clusterHeatCapacity);
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 6 + 74 - e, 176, 164 - e, 16, e);
        } else {
            this.func_73733_a(this.field_147003_i + 8, this.field_147009_r + 6, this.field_147003_i + 8 + 16, this.field_147009_r + 6 + 74, -8947849, -11316397);
        }
        this.func_73729_b(this.field_147003_i + 74, this.field_147009_r + 35, 176, 3, this.getCookProgressScaled(37), 16);
        GuiFluidRenderer.renderGuiTank(this.vessel.getTanks().get(0), this.field_147003_i + 56, this.field_147009_r + 35, this.field_73735_i, 16.0, 16.0);
        GuiFluidRenderer.renderGuiTank(this.vessel.getTanks().get(1), this.field_147003_i + 112, this.field_147009_r + 31, this.field_73735_i, 24.0, 24.0);
    }

    protected int getCookProgressScaled(int pixels) {
        if (this.vessel.baseProcessTime / this.vessel.getSpeedMultiplier() < 4.0) {
            return this.vessel.isProcessing ? pixels : 0;
        }
        double i = this.vessel.time;
        double j = this.vessel.baseProcessTime;
        return j != 0.0 ? (int)Math.round(i * (double)pixels / j) : 0;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
    }

    public void initButtons() {
        this.field_146292_n.add(new NCButton.EmptyTank(0, this.field_147003_i + 56, this.field_147009_r + 35, 16, 16));
        this.field_146292_n.add(new NCButton.EmptyTank(1, this.field_147003_i + 112, this.field_147009_r + 31, 24, 24));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (this.vessel.func_145831_w().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                if (guiButton.field_146127_k != i || !NCUtil.isModifierKeyDown()) continue;
                PacketHandler.instance.sendToServer((IMessage)(this.vessel.getTanks().get(i).isEmpty() ? new EmptyFilterTankPacket(this.vessel, i) : new EmptyTankPacket(this.vessel, i)));
                return;
            }
        }
    }
}

