/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.gui;

import java.util.ArrayList;
import java.util.List;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.solid.SolidFuelFissionLogic;
import nc.multiblock.fission.tile.IFissionController;
import nc.multiblock.gui.GuiLogicMultiblock;
import nc.multiblock.gui.element.MultiblockButton;
import nc.network.PacketHandler;
import nc.network.multiblock.ClearAllMaterialPacket;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.NCUtil;
import nc.util.StringHelper;
import nc.util.UnitHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSolidFissionController
extends GuiLogicMultiblock<FissionReactor, SolidFuelFissionLogic, IFissionController> {
    protected final ResourceLocation gui_texture = new ResourceLocation("nuclearcraft:textures/gui/container/solid_fission_controller.png");
    int outputRateWidth = 0;

    public GuiSolidFissionController(EntityPlayer player, IFissionController controller) {
        super(player, controller);
        this.field_146999_f = 176;
        this.field_147000_g = 114;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return this.gui_texture;
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        if (NCUtil.isModifierKeyDown()) {
            this.drawTooltip(this.clearAllInfo(), mouseX, mouseY, 153, 81, 18, 18);
        }
        this.drawHeatTooltip(mouseX, mouseY, 6, 103, 164, 6);
    }

    public List<String> heatInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.YELLOW + Lang.localise("gui.nc.container.fission_controller.heat_stored") + " " + TextFormatting.WHITE + UnitHelper.prefix(((SolidFuelFissionLogic)this.logic).heatBuffer.getHeatStored(), ((SolidFuelFissionLogic)this.logic).heatBuffer.getHeatCapacity(), 6, "H"));
        info.add(TextFormatting.YELLOW + Lang.localise("gui.nc.container.fission_controller.net_cluster_heating") + " " + TextFormatting.WHITE + UnitHelper.prefix(((SolidFuelFissionLogic)this.logic).getNetClusterHeating(), 6, "H/t"));
        info.add(TextFormatting.BLUE + Lang.localise("gui.nc.container.fission_controller.total_cluster_cooling") + " " + TextFormatting.WHITE + UnitHelper.prefix(-((FissionReactor)this.multiblock).cooling, 6, "H/t"));
        return info;
    }

    public void drawHeatTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.heatInfo(), mouseX, mouseY, x, y, width, height);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int fontColor = ((FissionReactor)this.multiblock).isReactorOn ? -1 : 0xEEAA00;
        String title = ((FissionReactor)this.multiblock).getInteriorLengthX() + "*" + ((FissionReactor)this.multiblock).getInteriorLengthY() + "*" + ((FissionReactor)this.multiblock).getInteriorLengthZ() + " " + Lang.localise("gui.nc.container.solid_fission_controller.reactor");
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.width(title) / 2, 6, fontColor);
        String underline = StringHelper.charLine('-', MathHelper.func_76143_f((double)((double)this.width(title) / (double)this.width("-"))));
        this.field_146289_q.func_78276_b(underline, this.field_146999_f / 2 - this.width(underline) / 2, 12, fontColor);
        String clusters = Lang.localise("gui.nc.container.fission_controller.clusters") + " " + ((FissionReactor)this.multiblock).clusterCount;
        this.field_146289_q.func_78276_b(clusters, this.field_146999_f / 2 - this.width(clusters) / 2, 22, fontColor);
        String efficiency = NCUtil.isModifierKeyDown() ? Lang.localise("gui.nc.container.fission_controller.heat_mult") + " " + NCMath.pcDecimalPlaces(((FissionReactor)this.multiblock).meanHeatMult, 1) : Lang.localise("gui.nc.container.fission_controller.efficiency") + " " + NCMath.pcDecimalPlaces(((FissionReactor)this.multiblock).meanEfficiency, 1);
        this.field_146289_q.func_78276_b(efficiency, this.field_146999_f / 2 - this.width(efficiency) / 2, 34, fontColor);
        String outputRate = Lang.localise("gui.nc.container.solid_fission_controller.output_rate") + " " + UnitHelper.prefix(((SolidFuelFissionLogic)this.logic).heatingOutputRateFP, 6, "B/t", -1);
        this.outputRateWidth = this.outputRateWidth - this.width(outputRate) > 1 ? this.width(outputRate) : Math.max(this.outputRateWidth, this.width(outputRate));
        this.field_146289_q.func_78276_b(outputRate, this.field_146999_f / 2 - this.outputRateWidth / 2, 46, fontColor);
        String sparsity = NCUtil.isModifierKeyDown() ? Lang.localise("gui.nc.container.fission_controller.useful_parts") + " " + ((FissionReactor)this.multiblock).usefulPartCount + "/" + ((FissionReactor)this.multiblock).getInteriorVolume() : Lang.localise("gui.nc.container.fission_controller.sparsity") + " " + NCMath.pcDecimalPlaces(((FissionReactor)this.multiblock).sparsityEfficiencyMult, 1);
        this.field_146289_q.func_78276_b(sparsity, this.field_146999_f / 2 - this.width(sparsity) / 2, 58, fontColor);
        String temperature = Lang.localise("gui.nc.container.fission_controller.temperature") + " " + (NCUtil.isModifierKeyDown() ? ((SolidFuelFissionLogic)this.logic).getTemperature() - 273 + " C" : ((SolidFuelFissionLogic)this.logic).getTemperature() + " K");
        this.field_146289_q.func_78276_b(temperature, this.field_146999_f / 2 - this.width(temperature) / 2, NCUtil.isModifierKeyDown() ? 70 : 76, fontColor);
        if (!NCUtil.isModifierKeyDown()) {
            String netClusterHeating = Lang.localise("gui.nc.container.fission_controller.net_cluster_heating") + " " + UnitHelper.prefix(((SolidFuelFissionLogic)this.logic).getNetClusterHeating(), 6, "H/t");
            this.field_146289_q.func_78276_b(netClusterHeating, this.field_146999_f / 2 - this.width(netClusterHeating) / 2, 88, fontColor);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int h = (int)Math.round((double)((SolidFuelFissionLogic)this.logic).heatBuffer.getHeatStored() / (double)((SolidFuelFissionLogic)this.logic).heatBuffer.getHeatCapacity() * 164.0);
        this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + 102, 3, 114, h, 6);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new MultiblockButton.ClearAllMaterial(0, this.field_147003_i + 153, this.field_147009_r + 81));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (((FissionReactor)this.multiblock).WORLD.field_72995_K && guiButton.field_146127_k == 0 && NCUtil.isModifierKeyDown()) {
            PacketHandler.instance.sendToServer((IMessage)new ClearAllMaterialPacket(((IFissionController)this.tile).getTilePos()));
        }
    }
}

