/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.qComputer;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nc.multiblock.qComputer.QuantumComputer;
import nc.util.CollectionHelper;
import nc.util.Complex;
import nc.util.ComplexMatrix;
import nc.util.NCMath;
import nc.util.StringHelper;

public abstract class QuantumGate<GATE extends QuantumGate> {
    protected final QuantumComputer qc;
    protected final Class<GATE> gateClass;
    public static final IntSet S0 = new IntOpenHashSet(0);
    public static final ComplexMatrix I = new ComplexMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}});
    public static final ComplexMatrix X = new ComplexMatrix(new double[][]{{0.0, 0.0, 1.0, 0.0}, {1.0, 0.0, 0.0, 0.0}});
    public static final ComplexMatrix Y = new ComplexMatrix(new double[][]{{0.0, 0.0, 0.0, -1.0}, {0.0, 1.0, 0.0, 0.0}});
    public static final ComplexMatrix Z = new ComplexMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, -1.0, 0.0}});
    public static final ComplexMatrix H = new ComplexMatrix(new double[][]{{1.0, 0.0, 1.0, 0.0}, {1.0, 0.0, -1.0, 0.0}}).multiply(0.7071067811865476);
    public static final ComplexMatrix S = new ComplexMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
    public static final ComplexMatrix Sdg = new ComplexMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, -1.0}});
    public static final ComplexMatrix T = new ComplexMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.7071067811865476, 0.7071067811865476}});
    public static final ComplexMatrix Tdg = new ComplexMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.7071067811865476, -0.7071067811865476}});
    public static final ComplexMatrix P_0 = new ComplexMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}});
    public static final ComplexMatrix P_1 = new ComplexMatrix(new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}});
    public static final Object2ObjectMap<ComplexMatrix, double[]> ZYZ_DECOMPOSITION_ANGLES_CACHE = new Object2ObjectOpenHashMap();

    public QuantumGate(QuantumComputer qc, Class<GATE> gateClass) {
        this.qc = qc;
        this.gateClass = gateClass;
    }

    public abstract String getID();

    public abstract String[] mergerIDs();

    public abstract void run();

    public final QuantumGate merge(QuantumGate next) {
        if (this.gateClass.isInstance(next) && QuantumGate.matchingID(next.getID(), this.mergerIDs())) {
            return this.mergeInernal((QuantumGate)this.gateClass.cast(next));
        }
        return null;
    }

    public abstract GATE mergeInernal(GATE var1);

    public boolean shouldMarkDirty() {
        return false;
    }

    public abstract ComplexMatrix singleQubitOperation();

    public abstract void addRequiredDecomposition(List<QuantumGate> var1);

    public abstract List<String> getCode(int var1);

    public static int dim(int n) {
        return 1 << n;
    }

    public static ComplexMatrix id(int n) {
        return new ComplexMatrix(QuantumGate.dim(n)).id();
    }

    public static IntSet set(int ... n) {
        return new IntOpenHashSet(n);
    }

    public static IntList list(IntSet n) {
        IntArrayList l = new IntArrayList();
        for (int i = 0; i < QuantumComputer.getMaxQubits(); ++i) {
            if (!n.contains(i)) continue;
            l.add(i);
        }
        return l;
    }

    public static String intSetToString(IntSet set) {
        return Arrays.toString(QuantumGate.list(set).toIntArray());
    }

    public static String intListToString(IntList list) {
        return Arrays.toString(list.toIntArray());
    }

    public static ComplexMatrix p(double angle) {
        double[] p = Complex.phase_d(angle);
        return new ComplexMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, p[0], p[1]}});
    }

    public static ComplexMatrix rx(double angle) {
        return new ComplexMatrix(new double[][]{{NCMath.cos_d(angle / 2.0), 0.0, 0.0, -NCMath.sin_d(angle / 2.0)}, {0.0, -NCMath.sin_d(angle / 2.0), NCMath.cos_d(angle / 2.0), 0.0}});
    }

    public static ComplexMatrix ry(double angle) {
        return new ComplexMatrix(new double[][]{{NCMath.cos_d(angle / 2.0), 0.0, -NCMath.sin_d(angle / 2.0), 0.0}, {NCMath.sin_d(angle / 2.0), 0.0, NCMath.cos_d(angle / 2.0), 0.0}});
    }

    public static ComplexMatrix rz(double angle) {
        double[] a = Complex.phase_d(-angle / 2.0);
        double[] b = Complex.phase_d(angle / 2.0);
        return new ComplexMatrix(new double[][]{{a[0], a[1], 0.0, 0.0}, {0.0, 0.0, b[0], b[1]}});
    }

    public static boolean matchingID(String id, String[] arr) {
        for (String s : arr) {
            if (!id.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchingControl(IntSet c1, IntSet c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        IntIterator intIterator = c1.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            if (c2.contains(i)) continue;
            return false;
        }
        return true;
    }

    public static double[] getZYZDecompositionAngles(ComplexMatrix matrix) {
        if (ZYZ_DECOMPOSITION_ANGLES_CACHE.containsKey((Object)matrix)) {
            return (double[])ZYZ_DECOMPOSITION_ANGLES_CACHE.get((Object)matrix);
        }
        double[] det = matrix.det();
        double[] phase = Complex.invSqrt(det[0], det[1]);
        ComplexMatrix m = matrix.copy();
        m.multiply(phase[0], phase[1]);
        double ppl = 2.0 * Complex.arg(m.re[1][1], m.im[1][1]);
        double pml = 2.0 * Complex.arg(m.re[1][0], m.im[1][0]);
        return new double[]{-Math.toDegrees(Complex.arg(phase[0], phase[1])), Math.toDegrees((ppl + pml) / 2.0), Math.toDegrees(2.0 * Math.atan2(Complex.abs(m.re[1][0], m.im[1][0]), Complex.abs(m.re[0][0], m.im[0][0]))), Math.toDegrees((ppl - pml) / 2.0)};
    }

    public static <GATE extends QuantumGate<?>> void addZYZDecomposition(GATE gate, List<QuantumGate> decomposition) {
        IntSet t = ((IControl)((Object)gate)).t();
        if (t.isEmpty()) {
            return;
        }
        IntSet c = ((IControl)((Object)gate)).c();
        double[] azyz = QuantumGate.getZYZDecompositionAngles(gate.singleQubitOperation());
        double alpha = azyz[0];
        double beta = azyz[1];
        double hgam = azyz[2] / 2.0;
        double hbpd = (azyz[1] + azyz[3]) / 2.0;
        double hdmb = (azyz[3] - azyz[1]) / 2.0;
        boolean hgam_f = QuantumGate.full(hgam);
        boolean hbpd_f = QuantumGate.full(hbpd);
        if (c.isEmpty()) {
            decomposition.add(((IControl)((Object)gate)).withoutControl());
        } else if (c.size() == 1) {
            if (!QuantumGate.full(hdmb)) {
                new RZ(gate.qc, hdmb, t).addRequiredDecomposition(decomposition);
            }
            if (!hbpd_f || !hgam_f) {
                new CX(gate.qc, c, t).addRequiredDecomposition(decomposition);
                if (!hbpd_f) {
                    new RZ(gate.qc, -hbpd, t).addRequiredDecomposition(decomposition);
                }
                if (!hgam_f) {
                    new RY(gate.qc, -hgam, t).addRequiredDecomposition(decomposition);
                }
                new CX(gate.qc, c, t).addRequiredDecomposition(decomposition);
            }
            if (!hgam_f) {
                new RY(gate.qc, hgam, t).addRequiredDecomposition(decomposition);
            }
            if (!QuantumGate.full(beta)) {
                new RZ(gate.qc, beta, t).addRequiredDecomposition(decomposition);
            }
            if (!QuantumGate.full(alpha)) {
                new P(gate.qc, alpha, c).addRequiredDecomposition(decomposition);
            }
        } else {
            IntList c_list = QuantumGate.list(c);
            IntSet c_rot = QuantumGate.set(c_list.getInt(0));
            IntOpenHashSet c_cx = new IntOpenHashSet((IntCollection)c);
            c_cx.rem(c_list.getInt(0));
            if (!QuantumGate.full(hdmb)) {
                new CRZ(gate.qc, hdmb, c_rot, t).addRequiredDecomposition(decomposition);
            }
            if (!hbpd_f || !hgam_f) {
                new CX(gate.qc, (IntSet)c_cx, t).addRequiredDecomposition(decomposition);
                if (!hbpd_f) {
                    new CRZ(gate.qc, -hbpd, c_rot, t).addRequiredDecomposition(decomposition);
                }
                if (!hgam_f) {
                    new CRY(gate.qc, -hgam, c_rot, t).addRequiredDecomposition(decomposition);
                }
                new CX(gate.qc, (IntSet)c_cx, t).addRequiredDecomposition(decomposition);
            }
            if (!hgam_f) {
                new CRY(gate.qc, hgam, c_rot, t).addRequiredDecomposition(decomposition);
            }
            if (!QuantumGate.full(beta)) {
                new CRZ(gate.qc, beta, c_rot, t).addRequiredDecomposition(decomposition);
            }
            if (!QuantumGate.full(alpha)) {
                new CP(gate.qc, alpha, (IntSet)c_cx, c_rot).addRequiredDecomposition(decomposition);
            }
        }
    }

    public static boolean full(double angle) {
        return angle % 720.0 == 0.0;
    }

    public static String pythonArray(IntList list) {
        return QuantumGate.pythonArray(list, false);
    }

    public static String pythonArray(IntList list, boolean forceBrackets) {
        if (!forceBrackets && list.size() == 1) {
            return Integer.toString(list.getInt(0));
        }
        String out = "[";
        IntListIterator intListIterator = list.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            out = out + i + ", ";
        }
        return StringHelper.removeSuffix(out, 2) + "]";
    }

    static {
        ZYZ_DECOMPOSITION_ANGLES_CACHE.put((Object)I, (Object)new double[]{0.0, 0.0, 0.0, 0.0});
        ZYZ_DECOMPOSITION_ANGLES_CACHE.put((Object)X, (Object)new double[]{90.0, -90.0, 180.0, 90.0});
        ZYZ_DECOMPOSITION_ANGLES_CACHE.put((Object)Y, (Object)new double[]{90.0, 0.0, 180.0, 0.0});
        ZYZ_DECOMPOSITION_ANGLES_CACHE.put((Object)Z, (Object)new double[]{90.0, 90.0, 0.0, 90.0});
        ZYZ_DECOMPOSITION_ANGLES_CACHE.put((Object)H, (Object)new double[]{90.0, 0.0, 90.0, 180.0});
        ZYZ_DECOMPOSITION_ANGLES_CACHE.put((Object)S, (Object)new double[]{45.0, 45.0, 0.0, 45.0});
        ZYZ_DECOMPOSITION_ANGLES_CACHE.put((Object)Sdg, (Object)new double[]{-45.0, -45.0, 0.0, -45.0});
        ZYZ_DECOMPOSITION_ANGLES_CACHE.put((Object)T, (Object)new double[]{22.5, 22.5, 0.0, 22.5});
        ZYZ_DECOMPOSITION_ANGLES_CACHE.put((Object)Tdg, (Object)new double[]{-22.5, -22.5, 0.0, -22.5});
    }

    public static class ControlSwap
    extends Swap
    implements IControl {
        private static final String[] ID = new String[]{"cswap", "swap"};
        protected final IntSet c;

        public ControlSwap(QuantumComputer qc, IntSet c, IntList i, IntList j) {
            super(qc, i, j);
            this.c = c;
        }

        @Override
        public IntSet c() {
            return this.c;
        }

        @Override
        public IntSet t() {
            return null;
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            if (this.i.size() == this.j.size()) {
                this.qc.cswap(this.c, this.i, this.j);
            }
        }

        @Override
        public Swap mergeInernal(Swap next) {
            return ControlSwap.matchingControl(this.c, next instanceof ControlSwap ? ((ControlSwap)next).c : S0) ? this.newMerged(this.c, this.i, this.j, next.i, next.j) : null;
        }

        @Override
        public QuantumGate withoutControl() {
            return new Swap(this.qc, this.i, this.j);
        }

        @Override
        public void addRequiredDecomposition(List<QuantumGate> decomposition) {
            if (!this.i.isEmpty() && this.i.size() == this.j.size()) {
                if (this.c.isEmpty()) {
                    decomposition.add(this.withoutControl());
                } else if (this.c.size() == 1) {
                    decomposition.add(this);
                } else {
                    for (int k = 0; k < this.i.size(); ++k) {
                        IntSet c_1 = ControlSwap.set(this.i.getInt(k));
                        c_1.addAll((IntCollection)this.c);
                        CX cx_1 = new CX(this.qc, c_1, ControlSwap.set(this.j.getInt(k)));
                        IntSet c_2 = ControlSwap.set(this.j.getInt(k));
                        c_2.addAll((IntCollection)this.c);
                        CX cx_2 = new CX(this.qc, c_2, ControlSwap.set(this.i.getInt(k)));
                        ControlSwap.addZYZDecomposition(cx_1, decomposition);
                        ControlSwap.addZYZDecomposition(cx_2, decomposition);
                        ControlSwap.addZYZDecomposition(cx_1, decomposition);
                    }
                }
            }
        }

        @Override
        public List<String> getCode(int type) {
            ArrayList<String> out;
            block4: {
                block5: {
                    IntList l;
                    block6: {
                        if (this.c.isEmpty()) {
                            return this.withoutControl().getCode(type);
                        }
                        out = new ArrayList<String>();
                        if (this.i.isEmpty() || this.i.size() != this.j.size()) break block4;
                        if (this.c.size() != 1) break block5;
                        l = ControlSwap.list(this.c);
                        if (type != 0) break block6;
                        String s = "cswap q[" + l.getInt(0) + "], ";
                        for (int k = 0; k < this.i.size(); ++k) {
                            out.add(s + "q[" + this.i.getInt(k) + "], q[" + this.j.getInt(k) + "];");
                        }
                        break block4;
                    }
                    if (type != 1) break block4;
                    String s = "qc.cswap(" + l.getInt(0) + ", ";
                    for (int k = 0; k < this.i.size(); ++k) {
                        out.add(s + this.i.getInt(k) + ", " + this.j.getInt(k) + ")");
                    }
                    break block4;
                }
                ArrayList<QuantumGate> decomposition = new ArrayList<QuantumGate>();
                this.addRequiredDecomposition(decomposition);
                for (QuantumGate gate : decomposition) {
                    out.addAll(gate.getCode(type));
                }
            }
            return out;
        }
    }

    public static class Swap
    extends QuantumGate<Swap> {
        private static final String[] ID = new String[]{"swap", "cswap"};
        protected final IntList i;
        protected final IntList j;

        public Swap(QuantumComputer qc, IntList i, IntList j) {
            super(qc, Swap.class);
            this.i = i;
            this.j = j;
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            if (this.i.size() == this.j.size()) {
                this.qc.swap(this.i, this.j);
            }
        }

        @Override
        public Swap mergeInernal(Swap next) {
            return Swap.matchingControl(S0, next instanceof ControlSwap ? ((ControlSwap)next).c : S0) ? this.newMerged(S0, this.i, this.j, next.i, next.j) : null;
        }

        public Swap newMerged(IntSet c, IntList i1, IntList j1, IntList i2, IntList j2) {
            IntArrayList i = new IntArrayList(i1);
            IntArrayList j = new IntArrayList(j1);
            i.addAll(i2);
            j.addAll(j2);
            return c.isEmpty() ? new Swap(this.qc, (IntList)i, (IntList)j) : new ControlSwap(this.qc, c, (IntList)i, (IntList)j);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return null;
        }

        @Override
        public void addRequiredDecomposition(List<QuantumGate> decomposition) {
            if (!this.i.isEmpty() && this.i.size() == this.j.size()) {
                decomposition.add(this);
            }
        }

        @Override
        public List<String> getCode(int type) {
            ArrayList<String> out;
            block2: {
                block3: {
                    out = new ArrayList<String>();
                    if (this.i.size() != this.j.size()) break block2;
                    if (type != 0) break block3;
                    for (int k = 0; k < this.i.size(); ++k) {
                        out.add("swap q[" + this.i.getInt(k) + "], q[" + this.j.getInt(k) + "];");
                    }
                    break block2;
                }
                if (type != 1) break block2;
                for (int k = 0; k < this.i.size(); ++k) {
                    out.add("qc.swap(" + this.i.getInt(k) + ", " + this.j.getInt(k) + ")");
                }
            }
            return out;
        }
    }

    public static class CRZ
    extends ControlAngle {
        private static final String[] ID = new String[]{"crz", "rz"};

        public CRZ(QuantumComputer qc, double angle, IntSet c, IntSet t) {
            super(qc, angle, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.crz(this.angle, this.c, this.n);
        }

        @Override
        public BasicAngle newMerged(double angle, IntSet c, IntSet t) {
            return new CRZ(this.qc, angle, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new RZ(this.qc, this.angle, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return CRZ.rz(this.angle);
        }

        @Override
        public String singleControlQasmLine(double angle, int c, int i) {
            return "crz(" + Math.toRadians(angle) + ") q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(double angle, int c, IntList l) {
            return "qc.crz(" + Math.toRadians(angle) + ", " + c + ", " + CRZ.pythonArray(l) + ")";
        }
    }

    public static class CRY
    extends ControlAngle {
        private static final String[] ID = new String[]{"cry", "ry"};

        public CRY(QuantumComputer qc, double angle, IntSet c, IntSet t) {
            super(qc, angle, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.cry(this.angle, this.c, this.n);
        }

        @Override
        public BasicAngle newMerged(double angle, IntSet c, IntSet t) {
            return new CRY(this.qc, angle, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new RY(this.qc, this.angle, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return CRY.ry(this.angle);
        }

        @Override
        public String singleControlQasmLine(double angle, int c, int i) {
            return "cry(" + Math.toRadians(angle) + ") q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(double angle, int c, IntList l) {
            return "qc.cry(" + Math.toRadians(angle) + ", " + c + ", " + CRY.pythonArray(l) + ")";
        }
    }

    public static class CRX
    extends ControlAngle {
        private static final String[] ID = new String[]{"crx", "rx"};

        public CRX(QuantumComputer qc, double angle, IntSet c, IntSet t) {
            super(qc, angle, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.crx(this.angle, this.c, this.n);
        }

        @Override
        public BasicAngle newMerged(double angle, IntSet c, IntSet t) {
            return new CRX(this.qc, angle, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new RX(this.qc, this.angle, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return CRX.rx(this.angle);
        }

        @Override
        public String singleControlQasmLine(double angle, int c, int i) {
            return "crx(" + Math.toRadians(angle) + ") q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(double angle, int c, IntList l) {
            return "qc.crx(" + Math.toRadians(angle) + ", " + c + ", " + CRX.pythonArray(l) + ")";
        }
    }

    public static class CP
    extends ControlAngle {
        private static final String[] ID = new String[]{"cp", "p"};

        public CP(QuantumComputer qc, double angle, IntSet c, IntSet t) {
            super(qc, angle, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.cp(this.angle, this.c, this.n);
        }

        @Override
        public BasicAngle newMerged(double angle, IntSet c, IntSet t) {
            return new CP(this.qc, angle, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new P(this.qc, this.angle, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return CP.p(this.angle);
        }

        @Override
        public String singleControlQasmLine(double angle, int c, int i) {
            return "cp(" + Math.toRadians(angle) + ") q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(double angle, int c, IntList l) {
            return "qc.cp(" + Math.toRadians(angle) + ", " + c + ", " + CP.pythonArray(l) + ")";
        }
    }

    public static abstract class ControlAngle
    extends BasicAngle
    implements IControl {
        protected final IntSet c;

        public ControlAngle(QuantumComputer qc, double angle, IntSet c, IntSet t) {
            super(qc, angle, t);
            this.c = c;
        }

        @Override
        public IntSet c() {
            return this.c;
        }

        @Override
        public IntSet t() {
            return this.n;
        }

        @Override
        public BasicAngle mergeInernal(BasicAngle next) {
            if (this.angle != next.angle) {
                return null;
            }
            if (!ControlAngle.matchingControl(this.c, next instanceof ControlAngle ? ((ControlAngle)next).c : S0)) {
                return null;
            }
            IntIterator intIterator = this.n.iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                if (!next.n.contains(i)) continue;
                return null;
            }
            IntOpenHashSet n = new IntOpenHashSet((IntCollection)this.n);
            n.addAll((IntCollection)next.n);
            return this.newMerged(this.angle, this.c, (IntSet)n);
        }

        @Override
        public void addRequiredDecomposition(List<QuantumGate> decomposition) {
            if (this.c.size() == 1) {
                if (!this.n.isEmpty()) {
                    decomposition.add(this);
                }
            } else {
                ControlAngle.addZYZDecomposition(this, decomposition);
            }
        }

        @Override
        public List<String> getCode(int type) {
            if (this.c.isEmpty()) {
                return this.withoutControl().getCode(type);
            }
            if (this.c.size() == 1) {
                return this.singleControlCode(type);
            }
            ArrayList<QuantumGate> decomposition = new ArrayList<QuantumGate>();
            this.addRequiredDecomposition(decomposition);
            ArrayList<String> out = new ArrayList<String>();
            for (QuantumGate gate : decomposition) {
                out.addAll(gate.getCode(type));
            }
            return out;
        }

        @Override
        public final String qasmLine(double angle, int i) {
            return ";";
        }

        @Override
        public final String qiskitLine(double angle, IntList l) {
            return "";
        }

        public List<String> singleControlCode(int type) {
            int c = ControlAngle.list(this.c).getInt(0);
            IntList l = ControlAngle.list(this.n);
            ArrayList<String> out = new ArrayList<String>();
            if (type == 0) {
                for (int i = 0; i < l.size(); ++i) {
                    out.add(this.singleControlQasmLine(this.angle, c, l.getInt(i)));
                }
            } else if (type == 1 && !l.isEmpty()) {
                out.add(this.singleControlQiskitLine(this.angle, c, l));
            }
            return out;
        }

        public abstract String singleControlQasmLine(double var1, int var3, int var4);

        public abstract String singleControlQiskitLine(double var1, int var3, IntList var4);
    }

    public static class CTdg
    extends Control {
        private static final String[] ID = new String[]{"ctdg", "tdg"};

        public CTdg(QuantumComputer qc, IntSet c, IntSet t) {
            super(qc, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.ctdg(this.c, this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new CTdg(this.qc, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new Tdg(this.qc, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return Tdg;
        }

        @Override
        public String singleControlQasmLine(int c, int i) {
            return "cp(-pi/4) q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(int c, IntList l) {
            return "qc.cp(-pi/4, " + c + ", " + CTdg.pythonArray(l) + ")";
        }
    }

    public static class CT
    extends Control {
        private static final String[] ID = new String[]{"ct", "t"};

        public CT(QuantumComputer qc, IntSet c, IntSet t) {
            super(qc, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.ct(this.c, this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new CT(this.qc, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new T(this.qc, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return T;
        }

        @Override
        public String singleControlQasmLine(int c, int i) {
            return "cp(pi/4) q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(int c, IntList l) {
            return "qc.cp(pi/4, " + c + ", " + CT.pythonArray(l) + ")";
        }
    }

    public static class CSdg
    extends Control {
        private static final String[] ID = new String[]{"csdg", "sdg"};

        public CSdg(QuantumComputer qc, IntSet c, IntSet t) {
            super(qc, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.csdg(this.c, this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new CSdg(this.qc, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new Sdg(this.qc, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return Sdg;
        }

        @Override
        public String singleControlQasmLine(int c, int i) {
            return "cp(-pi/2) q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(int c, IntList l) {
            return "qc.cp(-pi/2, " + c + ", " + CSdg.pythonArray(l) + ")";
        }
    }

    public static class CS
    extends Control {
        private static final String[] ID = new String[]{"cs", "s"};

        public CS(QuantumComputer qc, IntSet c, IntSet t) {
            super(qc, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.cs(this.c, this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new CS(this.qc, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new S(this.qc, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return S;
        }

        @Override
        public String singleControlQasmLine(int c, int i) {
            return "cp(pi/2) q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(int c, IntList l) {
            return "qc.cp(pi/2, " + c + ", " + CS.pythonArray(l) + ")";
        }
    }

    public static class CH
    extends Control {
        private static final String[] ID = new String[]{"ch", "h"};

        public CH(QuantumComputer qc, IntSet c, IntSet t) {
            super(qc, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.ch(this.c, this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new CH(this.qc, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new H(this.qc, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return H;
        }

        @Override
        public String singleControlQasmLine(int c, int i) {
            return "ch q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(int c, IntList l) {
            return "qc.ch(" + c + ", " + CH.pythonArray(l) + ")";
        }
    }

    public static class CZ
    extends Control {
        private static final String[] ID = new String[]{"cz", "z"};

        public CZ(QuantumComputer qc, IntSet c, IntSet t) {
            super(qc, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.cz(this.c, this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new CZ(this.qc, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new Z(this.qc, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return Z;
        }

        @Override
        public String singleControlQasmLine(int c, int i) {
            return "cz q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(int c, IntList l) {
            return "qc.cz(" + c + ", " + CZ.pythonArray(l) + ")";
        }
    }

    public static class CY
    extends Control {
        private static final String[] ID = new String[]{"cy", "y"};

        public CY(QuantumComputer qc, IntSet c, IntSet t) {
            super(qc, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.cy(this.c, this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new CY(this.qc, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new Y(this.qc, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return Y;
        }

        @Override
        public String singleControlQasmLine(int c, int i) {
            return "cy q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(int c, IntList l) {
            return "qc.cy(" + c + ", " + CY.pythonArray(l) + ")";
        }
    }

    public static class CX
    extends Control {
        private static final String[] ID = new String[]{"cx", "x"};

        public CX(QuantumComputer qc, IntSet c, IntSet t) {
            super(qc, c, t);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.cx(this.c, this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new CX(this.qc, c, t);
        }

        @Override
        public QuantumGate withoutControl() {
            return new X(this.qc, this.n);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return X;
        }

        @Override
        public void addRequiredDecomposition(List<QuantumGate> decomposition) {
            boolean four_cx;
            if (this.n.isEmpty()) {
                return;
            }
            if (this.c.isEmpty()) {
                decomposition.add(this.withoutControl());
                return;
            }
            int c_size = this.c.size();
            if (c_size == 1 || c_size == 2) {
                decomposition.add(this);
                return;
            }
            int q = this.qc.qubitCount();
            int h = (int)Math.ceil((double)q / 2.0);
            boolean toffoli = q >= 5 && c_size >= 3 && c_size <= h;
            boolean bl = four_cx = q >= c_size + 2 && c_size >= 3;
            if (toffoli || four_cx) {
                IntList c_list = CX.list(this.c);
                IntListIterator intListIterator = CX.list(this.n).iterator();
                while (intListIterator.hasNext()) {
                    int t = (Integer)intListIterator.next();
                    if (toffoli) {
                        IntArrayList anc = new IntArrayList(q - c_size - 1);
                        for (int i = 0; i < q; ++i) {
                            if (i == t || this.c.contains(i)) continue;
                            anc.add(i);
                        }
                        CX[] repeat = new CX[2 * (c_size - 2)];
                        repeat[0] = new CX(this.qc, CX.set(anc.getInt(0), c_list.getInt(0)), CX.set(t));
                        for (int i = 1; i < c_size - 2; ++i) {
                            repeat[i] = new CX(this.qc, CX.set(anc.getInt(i), c_list.getInt(i)), CX.set(anc.getInt(i - 1)));
                            repeat[2 * (c_size - 2) - i] = repeat[i];
                        }
                        repeat[c_size - 2] = new CX(this.qc, CX.set(c_list.getInt(c_size - 2), c_list.getInt(c_size - 1)), CX.set(anc.getInt(c_size - 3)));
                        for (CX cx : repeat) {
                            decomposition.add(cx);
                        }
                        for (CX cx : repeat) {
                            decomposition.add(cx);
                        }
                        continue;
                    }
                    int m_1 = (int)Math.ceil(((double)c_size + 1.0) / 2.0);
                    int m_2 = c_size - m_1 + 1;
                    int anc = -1;
                    for (int i = 0; i < q; ++i) {
                        if (i == t || this.c.contains(i)) continue;
                        anc = i;
                        break;
                    }
                    IntOpenHashSet c_1 = new IntOpenHashSet(m_1);
                    c_1.addAll((IntCollection)c_list.subList(m_2 - 1, c_size));
                    CX cx_1 = new CX(this.qc, (IntSet)c_1, CX.set(anc));
                    IntOpenHashSet c_2 = new IntOpenHashSet(m_2);
                    c_2.add(anc);
                    c_2.addAll((IntCollection)c_list.subList(0, m_2 - 1));
                    CX cx_2 = new CX(this.qc, (IntSet)c_2, CX.set(t));
                    decomposition.add(cx_1);
                    decomposition.add(cx_2);
                    decomposition.add(cx_1);
                    decomposition.add(cx_2);
                }
            } else {
                CX.addZYZDecomposition(this, decomposition);
            }
        }

        @Override
        public List<String> getCode(int type) {
            if (this.c.isEmpty()) {
                return this.withoutControl().getCode(type);
            }
            int c_size = this.c.size();
            if (c_size == 1) {
                return this.singleControlCode(type);
            }
            if (c_size == 2) {
                return this.doubleControlCode(type);
            }
            ArrayList<String> out = new ArrayList<String>();
            ArrayList<QuantumGate> decomposition = new ArrayList<QuantumGate>();
            this.addRequiredDecomposition(decomposition);
            for (QuantumGate gate : decomposition) {
                out.addAll(gate.getCode(type));
            }
            return out;
        }

        @Override
        public String singleControlQasmLine(int c, int i) {
            return "cx q[" + c + "], q[" + i + "];";
        }

        @Override
        public String singleControlQiskitLine(int c, IntList l) {
            return "qc.cx(" + c + ", " + CX.pythonArray(l) + ")";
        }

        public List<String> doubleControlCode(int type) {
            IntList c_list = CX.list(this.c);
            int c1 = c_list.getInt(0);
            int c2 = c_list.getInt(1);
            IntList l = CX.list(this.n);
            ArrayList<String> out = new ArrayList<String>();
            if (type == 0) {
                for (int i = 0; i < l.size(); ++i) {
                    out.add(this.doubleControlQasmLine(c1, c2, l.getInt(i)));
                }
            } else if (type == 1 && !l.isEmpty()) {
                out.add(this.doubleControlQiskitLine(c1, c2, l));
            }
            return out;
        }

        public String doubleControlQasmLine(int c1, int c2, int i) {
            return "ccx q[" + c1 + "], q[" + c2 + "], q[" + i + "];";
        }

        public String doubleControlQiskitLine(int c1, int c2, IntList l) {
            return "qc.ccx(" + c1 + ", " + c2 + ", " + CX.pythonArray(l) + ")";
        }
    }

    public static abstract class Control
    extends Basic
    implements IControl {
        protected final IntSet c;

        public Control(QuantumComputer qc, IntSet c, IntSet t) {
            super(qc, t);
            this.c = c;
        }

        @Override
        public IntSet c() {
            return this.c;
        }

        @Override
        public IntSet t() {
            return this.n;
        }

        @Override
        public Basic mergeInernal(Basic next) {
            if (!Control.matchingControl(this.c, next instanceof Control ? ((Control)next).c : S0)) {
                return null;
            }
            IntIterator intIterator = this.n.iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                if (!next.n.contains(i)) continue;
                return null;
            }
            IntOpenHashSet n = new IntOpenHashSet((IntCollection)this.n);
            n.addAll((IntCollection)next.n);
            return this.newMerged(this.c, (IntSet)n);
        }

        @Override
        public void addRequiredDecomposition(List<QuantumGate> decomposition) {
            if (this.c.size() == 1) {
                if (!this.n.isEmpty()) {
                    decomposition.add(this);
                }
            } else {
                Control.addZYZDecomposition(this, decomposition);
            }
        }

        @Override
        public List<String> getCode(int type) {
            if (this.c.isEmpty()) {
                return this.withoutControl().getCode(type);
            }
            if (this.c.size() == 1) {
                return this.singleControlCode(type);
            }
            ArrayList<QuantumGate> decomposition = new ArrayList<QuantumGate>();
            this.addRequiredDecomposition(decomposition);
            ArrayList<String> out = new ArrayList<String>();
            for (QuantumGate gate : decomposition) {
                out.addAll(gate.getCode(type));
            }
            return out;
        }

        @Override
        public final String qasmLine(int i) {
            return ";";
        }

        @Override
        public final String qiskitLine(IntList l) {
            return "";
        }

        public List<String> singleControlCode(int type) {
            int c = Control.list(this.c).getInt(0);
            IntList l = Control.list(this.n);
            ArrayList<String> out = new ArrayList<String>();
            if (type == 0) {
                for (int i = 0; i < l.size(); ++i) {
                    out.add(this.singleControlQasmLine(c, l.getInt(i)));
                }
            } else if (type == 1 && !l.isEmpty()) {
                out.add(this.singleControlQiskitLine(c, l));
            }
            return out;
        }

        public abstract String singleControlQasmLine(int var1, int var2);

        public abstract String singleControlQiskitLine(int var1, IntList var2);
    }

    public static class RZ
    extends BasicAngle {
        private static final String[] ID = new String[]{"rz", "crz"};

        public RZ(QuantumComputer qc, double angle, IntSet n) {
            super(qc, angle, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.rz(this.angle, this.n);
        }

        @Override
        public BasicAngle newMerged(double angle, IntSet c, IntSet t) {
            return new RZ(this.qc, angle, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return RZ.rz(this.angle);
        }

        @Override
        public String qasmLine(double angle, int i) {
            return "rz(" + Math.toRadians(angle) + ") q[" + i + "];";
        }

        @Override
        public String qiskitLine(double angle, IntList l) {
            return "qc.rz(" + Math.toRadians(angle) + ", " + RZ.pythonArray(l) + ")";
        }
    }

    public static class RY
    extends BasicAngle {
        private static final String[] ID = new String[]{"ry", "cry"};

        public RY(QuantumComputer qc, double angle, IntSet n) {
            super(qc, angle, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.ry(this.angle, this.n);
        }

        @Override
        public BasicAngle newMerged(double angle, IntSet c, IntSet t) {
            return new RY(this.qc, angle, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return RY.ry(this.angle);
        }

        @Override
        public String qasmLine(double angle, int i) {
            return "ry(" + Math.toRadians(angle) + ") q[" + i + "];";
        }

        @Override
        public String qiskitLine(double angle, IntList l) {
            return "qc.ry(" + Math.toRadians(angle) + ", " + RY.pythonArray(l) + ")";
        }
    }

    public static class RX
    extends BasicAngle {
        private static final String[] ID = new String[]{"rx", "crx"};

        public RX(QuantumComputer qc, double angle, IntSet n) {
            super(qc, angle, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.rx(this.angle, this.n);
        }

        @Override
        public BasicAngle newMerged(double angle, IntSet c, IntSet t) {
            return new RX(this.qc, angle, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return RX.rx(this.angle);
        }

        @Override
        public String qasmLine(double angle, int i) {
            return "rx(" + Math.toRadians(angle) + ") q[" + i + "];";
        }

        @Override
        public String qiskitLine(double angle, IntList l) {
            return "qc.rx(" + Math.toRadians(angle) + ", " + RX.pythonArray(l) + ")";
        }
    }

    public static class P
    extends BasicAngle {
        private static final String[] ID = new String[]{"p", "cp"};

        public P(QuantumComputer qc, double angle, IntSet n) {
            super(qc, angle, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.p(this.angle, this.n);
        }

        @Override
        public BasicAngle newMerged(double angle, IntSet c, IntSet t) {
            return new P(this.qc, angle, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return P.p(this.angle);
        }

        @Override
        public String qasmLine(double angle, int i) {
            return "p(" + Math.toRadians(angle) + ") q[" + i + "];";
        }

        @Override
        public String qiskitLine(double angle, IntList l) {
            return "qc.p(" + Math.toRadians(angle) + ", " + P.pythonArray(l) + ")";
        }
    }

    public static abstract class BasicAngle
    extends QuantumGate<BasicAngle> {
        protected final double angle;
        protected final IntSet n;

        public BasicAngle(QuantumComputer qc, double angle, IntSet n) {
            super(qc, BasicAngle.class);
            this.angle = angle;
            this.n = n;
        }

        @Override
        public BasicAngle mergeInernal(BasicAngle next) {
            if (this.angle != next.angle) {
                return null;
            }
            if (next instanceof ControlAngle && !((ControlAngle)next).c.isEmpty()) {
                return null;
            }
            IntIterator intIterator = this.n.iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                if (!next.n.contains(i)) continue;
                return null;
            }
            IntOpenHashSet n = new IntOpenHashSet((IntCollection)this.n);
            n.addAll((IntCollection)next.n);
            return this.newMerged(this.angle, S0, (IntSet)n);
        }

        public abstract BasicAngle newMerged(double var1, IntSet var3, IntSet var4);

        @Override
        public List<String> getCode(int type) {
            IntList l = BasicAngle.list(this.n);
            ArrayList<String> out = new ArrayList<String>();
            if (type == 0) {
                for (int i = 0; i < l.size(); ++i) {
                    out.add(this.qasmLine(this.angle, l.getInt(i)));
                }
            } else if (type == 1 && !l.isEmpty()) {
                out.add(this.qiskitLine(this.angle, l));
            }
            return out;
        }

        @Override
        public void addRequiredDecomposition(List<QuantumGate> decomposition) {
            if (!this.n.isEmpty()) {
                decomposition.add(this);
            }
        }

        public abstract String qasmLine(double var1, int var3);

        public abstract String qiskitLine(double var1, IntList var3);
    }

    public static class Tdg
    extends Basic {
        private static final String[] ID = new String[]{"tdg", "ctdg"};

        public Tdg(QuantumComputer qc, IntSet n) {
            super(qc, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.tdg(this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new Tdg(this.qc, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return Tdg;
        }

        @Override
        public String qasmLine(int i) {
            return "tdg q[" + i + "];";
        }

        @Override
        public String qiskitLine(IntList l) {
            return "qc.tdg(" + nc.multiblock.qComputer.QuantumGate$Tdg.pythonArray(l) + ")";
        }
    }

    public static class T
    extends Basic {
        private static final String[] ID = new String[]{"t", "ct"};

        public T(QuantumComputer qc, IntSet n) {
            super(qc, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.t(this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new T(this.qc, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return T;
        }

        @Override
        public String qasmLine(int i) {
            return "t q[" + i + "];";
        }

        @Override
        public String qiskitLine(IntList l) {
            return "qc.t(" + nc.multiblock.qComputer.QuantumGate$T.pythonArray(l) + ")";
        }
    }

    public static class Sdg
    extends Basic {
        private static final String[] ID = new String[]{"sdg", "csdg"};

        public Sdg(QuantumComputer qc, IntSet n) {
            super(qc, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.sdg(this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new Sdg(this.qc, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return Sdg;
        }

        @Override
        public String qasmLine(int i) {
            return "sdg q[" + i + "];";
        }

        @Override
        public String qiskitLine(IntList l) {
            return "qc.sdg(" + nc.multiblock.qComputer.QuantumGate$Sdg.pythonArray(l) + ")";
        }
    }

    public static class S
    extends Basic {
        private static final String[] ID = new String[]{"s", "cs"};

        public S(QuantumComputer qc, IntSet n) {
            super(qc, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.s(this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new S(this.qc, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return S;
        }

        @Override
        public String qasmLine(int i) {
            return "s q[" + i + "];";
        }

        @Override
        public String qiskitLine(IntList l) {
            return "qc.s(" + nc.multiblock.qComputer.QuantumGate$S.pythonArray(l) + ")";
        }
    }

    public static class H
    extends Basic {
        private static final String[] ID = new String[]{"h", "ch"};

        public H(QuantumComputer qc, IntSet n) {
            super(qc, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.h(this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new H(this.qc, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return H;
        }

        @Override
        public String qasmLine(int i) {
            return "h q[" + i + "];";
        }

        @Override
        public String qiskitLine(IntList l) {
            return "qc.h(" + nc.multiblock.qComputer.QuantumGate$H.pythonArray(l) + ")";
        }
    }

    public static class Z
    extends Basic {
        private static final String[] ID = new String[]{"z", "cz"};

        public Z(QuantumComputer qc, IntSet n) {
            super(qc, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.z(this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new Z(this.qc, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return Z;
        }

        @Override
        public String qasmLine(int i) {
            return "z q[" + i + "];";
        }

        @Override
        public String qiskitLine(IntList l) {
            return "qc.z(" + nc.multiblock.qComputer.QuantumGate$Z.pythonArray(l) + ")";
        }
    }

    public static class Y
    extends Basic {
        private static final String[] ID = new String[]{"y", "cy"};

        public Y(QuantumComputer qc, IntSet n) {
            super(qc, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.y(this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new Y(this.qc, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return Y;
        }

        @Override
        public String qasmLine(int i) {
            return "y q[" + i + "];";
        }

        @Override
        public String qiskitLine(IntList l) {
            return "qc.y(" + nc.multiblock.qComputer.QuantumGate$Y.pythonArray(l) + ")";
        }
    }

    public static class X
    extends Basic {
        private static final String[] ID = new String[]{"x", "cx"};

        public X(QuantumComputer qc, IntSet n) {
            super(qc, n);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.x(this.n);
        }

        @Override
        public Basic newMerged(IntSet c, IntSet t) {
            return new X(this.qc, t);
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return X;
        }

        @Override
        public String qasmLine(int i) {
            return "x q[" + i + "];";
        }

        @Override
        public String qiskitLine(IntList l) {
            return "qc.x(" + nc.multiblock.qComputer.QuantumGate$X.pythonArray(l) + ")";
        }
    }

    public static abstract class Basic
    extends QuantumGate<Basic> {
        protected final IntSet n;

        public Basic(QuantumComputer qc, IntSet n) {
            super(qc, Basic.class);
            this.n = n;
        }

        @Override
        public Basic mergeInernal(Basic next) {
            if (next instanceof Control && !((Control)next).c.isEmpty()) {
                return null;
            }
            IntIterator intIterator = this.n.iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                if (!next.n.contains(i)) continue;
                return null;
            }
            IntOpenHashSet n = new IntOpenHashSet((IntCollection)this.n);
            n.addAll((IntCollection)next.n);
            return this.newMerged(S0, (IntSet)n);
        }

        public abstract Basic newMerged(IntSet var1, IntSet var2);

        @Override
        public void addRequiredDecomposition(List<QuantumGate> decomposition) {
            if (!this.n.isEmpty()) {
                decomposition.add(this);
            }
        }

        @Override
        public List<String> getCode(int type) {
            IntList l = Basic.list(this.n);
            ArrayList<String> out = new ArrayList<String>();
            if (type == 0) {
                for (int i = 0; i < l.size(); ++i) {
                    out.add(this.qasmLine(l.getInt(i)));
                }
            } else if (type == 1 && !l.isEmpty()) {
                out.add(this.qiskitLine(l));
            }
            return out;
        }

        public abstract String qasmLine(int var1);

        public abstract String qiskitLine(IntList var1);
    }

    public static class Reset
    extends QuantumGate<Reset> {
        private static final String[] ID = new String[]{"reset"};

        public Reset(QuantumComputer qc) {
            super(qc, Reset.class);
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.refreshState(true);
        }

        @Override
        public Reset mergeInernal(Reset next) {
            return new Reset(this.qc);
        }

        @Override
        public boolean shouldMarkDirty() {
            return true;
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return null;
        }

        @Override
        public void addRequiredDecomposition(List<QuantumGate> decomposition) {
            decomposition.add(this);
        }

        @Override
        public List<String> getCode(int type) {
            int q = this.qc.qubitCount();
            ArrayList<String> out = new ArrayList<String>();
            if (type == 0) {
                for (int i = 0; i < q; ++i) {
                    out.add("reset q[" + i + "];");
                }
            } else if (type == 1 && q != 0) {
                String s = Reset.pythonArray(CollectionHelper.increasingList(q));
                out.add("qc.reset(" + s + ")");
            }
            return out;
        }
    }

    public static class Measurement
    extends QuantumGate<Measurement> {
        private static final String[] ID = new String[]{"measure"};
        protected final IntSet n;

        public Measurement(QuantumComputer qc, IntSet n) {
            super(qc, Measurement.class);
            this.n = n;
        }

        @Override
        public String getID() {
            return ID[0];
        }

        @Override
        public String[] mergerIDs() {
            return ID;
        }

        @Override
        public void run() {
            this.qc.measure(this.n);
        }

        @Override
        public Measurement mergeInernal(Measurement next) {
            IntOpenHashSet n = new IntOpenHashSet((IntCollection)this.n);
            n.addAll((IntCollection)next.n);
            return new Measurement(this.qc, (IntSet)n);
        }

        @Override
        public boolean shouldMarkDirty() {
            return true;
        }

        @Override
        public ComplexMatrix singleQubitOperation() {
            return null;
        }

        @Override
        public void addRequiredDecomposition(List<QuantumGate> decomposition) {
            if (!this.n.isEmpty()) {
                decomposition.add(this);
            }
        }

        @Override
        public List<String> getCode(int type) {
            IntList l = Measurement.list(this.n);
            ArrayList<String> out = new ArrayList<String>();
            if (type == 0) {
                for (int i = 0; i < l.size(); ++i) {
                    out.add("measure q[" + l.getInt(i) + "] -> c[" + l.getInt(i) + "];");
                }
            } else if (type == 1 && !l.isEmpty()) {
                String s = Measurement.pythonArray(l);
                out.add("qc.measure(" + s + ", " + s + ")");
            }
            return out;
        }
    }

    public static interface IControl {
        public IntSet c();

        public IntSet t();

        public QuantumGate withoutControl();
    }
}

