/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.qComputer.tile;

import nc.config.NCConfig;
import nc.multiblock.qComputer.QuantumComputer;
import nc.multiblock.qComputer.tile.TileQuantumComputerPart;
import nc.util.Lang;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public abstract class TileQuantumComputerCodeGenerator
extends TileQuantumComputerPart {
    protected final int codeType;

    protected TileQuantumComputerCodeGenerator(int codeType) {
        this.codeType = codeType;
    }

    @Override
    public void onMachineAssembled(QuantumComputer multiblock) {
        this.doStandardNullControllerResponse(multiblock);
    }

    @Override
    public void onMachineBroken() {
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState != newState;
    }

    @Override
    public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
        QuantumComputer qc;
        if (!player.func_70093_af() && (qc = (QuantumComputer)this.getMultiblock()) != null && qc.isAssembled()) {
            if (qc.codeType >= 0) {
                qc.printCode(player);
            } else if (qc.qubitCount() <= NCConfig.quantum_max_qubits_code) {
                qc.codeStart = this.codeType;
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise(this.getUnlocalizedCodeStartMessage())));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.controller.code_too_many_qubits")));
            }
            return true;
        }
        return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
    }

    protected abstract String getUnlocalizedCodeStartMessage();

    public static class Qiskit
    extends TileQuantumComputerCodeGenerator {
        public Qiskit() {
            super(1);
        }

        @Override
        protected String getUnlocalizedCodeStartMessage() {
            return "info.nuclearcraft.multitool.quantum_computer.controller.code_qiskit_start";
        }
    }

    public static class Qasm
    extends TileQuantumComputerCodeGenerator {
        public Qasm() {
            super(0);
        }

        @Override
        protected String getUnlocalizedCodeStartMessage() {
            return "info.nuclearcraft.multitool.quantum_computer.controller.code_qasm_start";
        }
    }
}

