/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.qComputer.tile;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import nc.multiblock.qComputer.QuantumComputer;
import nc.multiblock.qComputer.QuantumGate;
import nc.multiblock.qComputer.tile.TileQuantumComputerPart;
import nc.util.Lang;
import nc.util.NBTHelper;
import nc.util.NCMath;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class TileQuantumComputerGate
extends TileQuantumComputerPart
implements ITickable {
    protected final String gateID;
    protected String toolMode = "";
    public boolean pulsed = false;

    public TileQuantumComputerGate(String gateID) {
        this.gateID = gateID;
    }

    @Override
    public void onMachineAssembled(QuantumComputer multiblock) {
        this.doStandardNullControllerResponse(multiblock);
    }

    @Override
    public void onMachineBroken() {
    }

    @Override
    public int[] weakSidesToCheck(World world, BlockPos pos) {
        return new int[]{2, 3, 4, 5};
    }

    public void func_73660_a() {
        if (!this.pulsed && this.getIsRedstonePowered()) {
            if (this.isMultiblockAssembled()) {
                ((QuantumComputer)this.getMultiblock()).getGateQueue().add(this.newGate((QuantumComputer)this.getMultiblock()));
            }
            this.pulsed = true;
        } else if (this.pulsed && !this.getIsRedstonePowered()) {
            this.pulsed = false;
        }
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState != newState;
    }

    protected abstract QuantumGate newGate(QuantumComputer var1);

    public abstract TextComponentString gateInfo();

    public static void clearMultitoolGateInfo(NBTTagCompound nbt) {
        nbt.func_74780_a("gateAngle", 0.0);
        NBTHelper.writeIntCollection(nbt, (IntCollection)new IntOpenHashSet(), "qubitIDSet");
        NBTHelper.writeIntCollection(nbt, (IntCollection)new IntArrayList(), "qubitIDList");
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74757_a("pulsed", this.pulsed);
        nbt.func_74778_a("toolMode", this.toolMode);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.pulsed = nbt.func_74767_n("pulsed");
        this.toolMode = nbt.func_74779_i("toolMode");
    }

    public static class ControlSwap
    extends TileQuantumComputerGate {
        protected final IntSet c = new IntOpenHashSet();
        protected final IntList i = new IntArrayList();
        protected final IntList j = new IntArrayList();

        public ControlSwap() {
            super("cswap");
            this.toolMode = "getControl";
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.ControlSwap(qc, this.c, this.i, this.j);
        }

        @Override
        public TextComponentString gateInfo() {
            return new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.control_swap_gate_info", QuantumGate.intListToString(this.i), QuantumGate.intListToString(this.j), QuantumGate.intSetToString(this.c)));
        }

        @Override
        public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
            NBTTagCompound nbt = multitoolStack.func_77978_p();
            if (this.toolMode.equals("getControl") && player.func_70093_af()) {
                this.c.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_control_set")));
                nbt.func_74778_a("qubitMode", "set");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setControl";
                ControlSwap.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setControl") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.c, "qubitIDSet");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_control_set", QuantumGate.intSetToString(this.c))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getFirst";
                ControlSwap.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("getFirst") && player.func_70093_af()) {
                this.i.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_first_swap_list")));
                nbt.func_74778_a("qubitMode", "list");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setFirst";
                ControlSwap.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setFirst") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.i, "qubitIDList");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_first_swap_list", QuantumGate.intListToString(this.i))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getSecond";
                ControlSwap.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("getSecond") && player.func_70093_af()) {
                this.j.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_second_swap_list")));
                nbt.func_74778_a("qubitMode", "list");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setSecond";
                ControlSwap.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setSecond") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.j, "qubitIDList");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_second_swap_list", QuantumGate.intListToString(this.j))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getControl";
                ControlSwap.clearMultitoolGateInfo(nbt);
                return true;
            }
            return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
        }

        @Override
        public NBTTagCompound writeAll(NBTTagCompound nbt) {
            super.writeAll(nbt);
            NBTHelper.writeIntCollection(nbt, (IntCollection)this.c, "cQubits");
            NBTHelper.writeIntCollection(nbt, (IntCollection)this.i, "iQubits");
            NBTHelper.writeIntCollection(nbt, (IntCollection)this.j, "jQubits");
            return nbt;
        }

        @Override
        public void readAll(NBTTagCompound nbt) {
            super.readAll(nbt);
            NBTHelper.readIntCollection(nbt, (IntCollection)this.c, "cQubits");
            NBTHelper.readIntCollection(nbt, (IntCollection)this.i, "iQubits");
            NBTHelper.readIntCollection(nbt, (IntCollection)this.j, "jQubits");
        }
    }

    public static class Swap
    extends TileQuantumComputerGate {
        protected final IntList i = new IntArrayList();
        protected final IntList j = new IntArrayList();

        public Swap() {
            super("swap");
            this.toolMode = "getFirst";
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.Swap(qc, this.i, this.j);
        }

        @Override
        public TextComponentString gateInfo() {
            return new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.swap_gate_info", QuantumGate.intListToString(this.i), QuantumGate.intListToString(this.j)));
        }

        @Override
        public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
            NBTTagCompound nbt = multitoolStack.func_77978_p();
            if (this.toolMode.equals("getFirst") && player.func_70093_af()) {
                this.i.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_first_swap_list")));
                nbt.func_74778_a("qubitMode", "list");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setFirst";
                Swap.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setFirst") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.i, "qubitIDList");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_first_swap_list", QuantumGate.intListToString(this.i))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getSecond";
                Swap.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("getSecond") && player.func_70093_af()) {
                this.j.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_second_swap_list")));
                nbt.func_74778_a("qubitMode", "list");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setSecond";
                Swap.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setSecond") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.j, "qubitIDList");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_second_swap_list", QuantumGate.intListToString(this.j))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getFirst";
                Swap.clearMultitoolGateInfo(nbt);
                return true;
            }
            return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
        }

        @Override
        public NBTTagCompound writeAll(NBTTagCompound nbt) {
            super.writeAll(nbt);
            NBTHelper.writeIntCollection(nbt, (IntCollection)this.i, "iQubits");
            NBTHelper.writeIntCollection(nbt, (IntCollection)this.j, "jQubits");
            return nbt;
        }

        @Override
        public void readAll(NBTTagCompound nbt) {
            super.readAll(nbt);
            NBTHelper.readIntCollection(nbt, (IntCollection)this.i, "iQubits");
            NBTHelper.readIntCollection(nbt, (IntCollection)this.j, "jQubits");
        }
    }

    public static class CRZ
    extends ControlAngle {
        public CRZ() {
            super("crz");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CRZ(qc, this.angle, this.c, this.t);
        }
    }

    public static class CRY
    extends ControlAngle {
        public CRY() {
            super("cry");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CRY(qc, this.angle, this.c, this.t);
        }
    }

    public static class CRX
    extends ControlAngle {
        public CRX() {
            super("crx");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CRX(qc, this.angle, this.c, this.t);
        }
    }

    public static class CP
    extends ControlAngle {
        public CP() {
            super("cp");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CP(qc, this.angle, this.c, this.t);
        }
    }

    public static abstract class ControlAngle
    extends Control {
        protected double angle = 0.0;

        public ControlAngle(String gateID) {
            super(gateID);
            this.toolMode = "getAngle";
        }

        @Override
        public TextComponentString gateInfo() {
            return new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.control_angle_gate_info", QuantumGate.intSetToString(this.t), NCMath.decimalPlaces(this.angle, 5), QuantumGate.intSetToString(this.c)));
        }

        @Override
        public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
            NBTTagCompound nbt = multitoolStack.func_77978_p();
            if (this.toolMode.equals("getAngle") && player.func_70093_af()) {
                this.angle = 0.0;
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_angle")));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "angle");
                this.toolMode = "setAngle";
                ControlAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setAngle") && !player.func_70093_af()) {
                this.angle = nbt.func_74769_h("gateAngle");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_angle", NCMath.decimalPlaces(this.angle, 5))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getControl";
                ControlAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("getControl") && player.func_70093_af()) {
                this.c.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_control_set")));
                nbt.func_74778_a("qubitMode", "set");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setControl";
                ControlAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setControl") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.c, "qubitIDSet");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_control_set", QuantumGate.intSetToString(this.c))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getTarget";
                ControlAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("getTarget") && player.func_70093_af()) {
                this.t.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_target_set")));
                nbt.func_74778_a("qubitMode", "set");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setTarget";
                ControlAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setTarget") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.t, "qubitIDSet");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_target_set", QuantumGate.intSetToString(this.t))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getAngle";
                ControlAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
        }

        @Override
        public NBTTagCompound writeAll(NBTTagCompound nbt) {
            super.writeAll(nbt);
            nbt.func_74780_a("gateAngle", this.angle);
            return nbt;
        }

        @Override
        public void readAll(NBTTagCompound nbt) {
            super.readAll(nbt);
            this.angle = nbt.func_74769_h("gateAngle");
        }
    }

    public static class CTdg
    extends Control {
        public CTdg() {
            super("ctdg");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CTdg(qc, this.c, this.t);
        }
    }

    public static class CT
    extends Control {
        public CT() {
            super("ct");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CT(qc, this.c, this.t);
        }
    }

    public static class CSdg
    extends Control {
        public CSdg() {
            super("csdg");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CSdg(qc, this.c, this.t);
        }
    }

    public static class CS
    extends Control {
        public CS() {
            super("cs");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CS(qc, this.c, this.t);
        }
    }

    public static class CH
    extends Control {
        public CH() {
            super("ch");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CH(qc, this.c, this.t);
        }
    }

    public static class CZ
    extends Control {
        public CZ() {
            super("cz");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CZ(qc, this.c, this.t);
        }
    }

    public static class CY
    extends Control {
        public CY() {
            super("cy");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CY(qc, this.c, this.t);
        }
    }

    public static class CX
    extends Control {
        public CX() {
            super("cx");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.CX(qc, this.c, this.t);
        }
    }

    public static abstract class Control
    extends TileQuantumComputerGate {
        protected final IntSet c = new IntOpenHashSet();
        protected final IntSet t = new IntOpenHashSet();

        public Control(String gateID) {
            super(gateID);
            this.toolMode = "getControl";
        }

        @Override
        public TextComponentString gateInfo() {
            return new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.control_gate_info", QuantumGate.intSetToString(this.t), QuantumGate.intSetToString(this.c)));
        }

        @Override
        public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
            NBTTagCompound nbt = multitoolStack.func_77978_p();
            if (this.toolMode.equals("getControl") && player.func_70093_af()) {
                this.c.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_control_set")));
                nbt.func_74778_a("qubitMode", "set");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setControl";
                Control.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setControl") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.c, "qubitIDSet");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_control_set", QuantumGate.intSetToString(this.c))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getTarget";
                Control.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("getTarget") && player.func_70093_af()) {
                this.t.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_target_set")));
                nbt.func_74778_a("qubitMode", "set");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setTarget";
                Control.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setTarget") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.t, "qubitIDSet");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_target_set", QuantumGate.intSetToString(this.t))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getControl";
                Control.clearMultitoolGateInfo(nbt);
                return true;
            }
            return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
        }

        @Override
        public NBTTagCompound writeAll(NBTTagCompound nbt) {
            super.writeAll(nbt);
            NBTHelper.writeIntCollection(nbt, (IntCollection)this.c, "cQubits");
            NBTHelper.writeIntCollection(nbt, (IntCollection)this.t, "tQubits");
            return nbt;
        }

        @Override
        public void readAll(NBTTagCompound nbt) {
            super.readAll(nbt);
            NBTHelper.readIntCollection(nbt, (IntCollection)this.c, "cQubits");
            NBTHelper.readIntCollection(nbt, (IntCollection)this.t, "tQubits");
        }
    }

    public static class RZ
    extends SingleAngle {
        public RZ() {
            super("rz");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.RZ(qc, this.angle, this.n);
        }
    }

    public static class RY
    extends SingleAngle {
        public RY() {
            super("ry");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.RY(qc, this.angle, this.n);
        }
    }

    public static class RX
    extends SingleAngle {
        public RX() {
            super("rx");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.RX(qc, this.angle, this.n);
        }
    }

    public static class P
    extends SingleAngle {
        public P() {
            super("p");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.P(qc, this.angle, this.n);
        }
    }

    public static abstract class SingleAngle
    extends Single {
        protected double angle = 0.0;

        public SingleAngle(String gateID) {
            super(gateID);
            this.toolMode = "getAngle";
        }

        @Override
        public TextComponentString gateInfo() {
            return new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.single_angle_gate_info", QuantumGate.intSetToString(this.n), NCMath.decimalPlaces(this.angle, 5)));
        }

        @Override
        public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
            NBTTagCompound nbt = multitoolStack.func_77978_p();
            if (this.toolMode.equals("getAngle") && player.func_70093_af()) {
                this.angle = 0.0;
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_angle")));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "angle");
                this.toolMode = "setAngle";
                SingleAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setAngle") && !player.func_70093_af()) {
                this.angle = nbt.func_74769_h("gateAngle");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_angle", NCMath.decimalPlaces(this.angle, 5))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getTarget";
                SingleAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("getTarget") && player.func_70093_af()) {
                this.n.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_target_set")));
                nbt.func_74778_a("qubitMode", "set");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setTarget";
                SingleAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setTarget") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.n, "qubitIDSet");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_target_set", QuantumGate.intSetToString(this.n))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getAngle";
                SingleAngle.clearMultitoolGateInfo(nbt);
                return true;
            }
            return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
        }

        @Override
        public NBTTagCompound writeAll(NBTTagCompound nbt) {
            super.writeAll(nbt);
            nbt.func_74780_a("gateAngle", this.angle);
            return nbt;
        }

        @Override
        public void readAll(NBTTagCompound nbt) {
            super.readAll(nbt);
            this.angle = nbt.func_74769_h("gateAngle");
        }
    }

    public static class Tdg
    extends Single {
        public Tdg() {
            super("tdg");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.Tdg(qc, this.n);
        }
    }

    public static class T
    extends Single {
        public T() {
            super("t");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.T(qc, this.n);
        }
    }

    public static class Sdg
    extends Single {
        public Sdg() {
            super("sdg");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.Sdg(qc, this.n);
        }
    }

    public static class S
    extends Single {
        public S() {
            super("s");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.S(qc, this.n);
        }
    }

    public static class H
    extends Single {
        public H() {
            super("h");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.H(qc, this.n);
        }
    }

    public static class Z
    extends Single {
        public Z() {
            super("z");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.Z(qc, this.n);
        }
    }

    public static class Y
    extends Single {
        public Y() {
            super("y");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.Y(qc, this.n);
        }
    }

    public static class X
    extends Single {
        public X() {
            super("x");
        }

        @Override
        protected QuantumGate newGate(QuantumComputer qc) {
            return new QuantumGate.X(qc, this.n);
        }
    }

    public static abstract class Single
    extends TileQuantumComputerGate {
        protected final IntSet n = new IntOpenHashSet();

        public Single(String gateID) {
            super(gateID);
            this.toolMode = "getTarget";
        }

        @Override
        public TextComponentString gateInfo() {
            return new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.single_gate_info", QuantumGate.intSetToString(this.n)));
        }

        @Override
        public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
            NBTTagCompound nbt = multitoolStack.func_77978_p();
            if (this.toolMode.equals("getTarget") && player.func_70093_af()) {
                this.n.clear();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + Lang.localise("info.nuclearcraft.multitool.quantum_computer.start_target_set")));
                nbt.func_74778_a("qubitMode", "set");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "setTarget";
                Single.clearMultitoolGateInfo(nbt);
                return true;
            }
            if (this.toolMode.equals("setTarget") && !player.func_70093_af()) {
                NBTHelper.readIntCollection(nbt, (IntCollection)this.n, "qubitIDSet");
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + Lang.localise("info.nuclearcraft.multitool.quantum_computer.finish_target_set", QuantumGate.intSetToString(this.n))));
                nbt.func_74778_a("qubitMode", "");
                nbt.func_74778_a("gateMode", "");
                this.toolMode = "getTarget";
                Single.clearMultitoolGateInfo(nbt);
                return true;
            }
            return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
        }

        @Override
        public NBTTagCompound writeAll(NBTTagCompound nbt) {
            super.writeAll(nbt);
            NBTHelper.writeIntCollection(nbt, (IntCollection)this.n, "nQubits");
            return nbt;
        }

        @Override
        public void readAll(NBTTagCompound nbt) {
            super.readAll(nbt);
            NBTHelper.readIntCollection(nbt, (IntCollection)this.n, "nQubits");
        }
    }
}

