/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.tile;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Set;
import nc.multiblock.Multiblock;
import nc.multiblock.MultiblockRegistry;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.multiblock.tile.TileBeefAbstract;
import nc.util.NCUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLLog;

public abstract class TileMultiblockPart<MULTIBLOCK extends Multiblock>
extends TileBeefAbstract
implements ITileMultiblockPart<MULTIBLOCK> {
    private MULTIBLOCK multiblock = null;
    protected final Class<MULTIBLOCK> multiblockClass;
    private boolean visited;
    private boolean saveMultiblockData;
    private NBTTagCompound cachedMultiblockData;

    public TileMultiblockPart(Class<MULTIBLOCK> multiblockClass) {
        this.multiblockClass = multiblockClass;
        this.visited = false;
        this.saveMultiblockData = false;
        this.cachedMultiblockData = null;
    }

    @Override
    public Class<MULTIBLOCK> getMultiblockType() {
        return this.multiblockClass;
    }

    @Override
    public Set<MULTIBLOCK> attachToNeighbors() {
        ITileMultiblockPart<MULTIBLOCK>[] partsToCheck;
        Set multiblocks = null;
        Multiblock bestMultiblock = null;
        for (ITileMultiblockPart<MULTIBLOCK> neighborPart : partsToCheck = this.getNeighboringParts()) {
            MULTIBLOCK candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblock()).getClass().equals(this.getMultiblockType())) continue;
            if (multiblocks == null) {
                multiblocks = new ObjectOpenHashSet();
                bestMultiblock = candidate;
            } else if (!multiblocks.contains(candidate) && ((Multiblock)candidate).shouldConsume(bestMultiblock)) {
                bestMultiblock = candidate;
            }
            multiblocks.add(candidate);
        }
        if (bestMultiblock != null) {
            this.multiblock = bestMultiblock;
            bestMultiblock.attachBlock(this);
        }
        return multiblocks;
    }

    @Override
    public void assertDetached() {
        if (this.multiblock != null) {
            BlockPos coord = this.field_174879_c;
            FMLLog.info((String)"[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", (Object[])new Object[]{coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p()});
            this.multiblock = null;
        }
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        if (TileBeefAbstract.SyncReason.FullSync == syncReason) {
            if (data.func_74764_b("multiblockData")) {
                this.cachedMultiblockData = data.func_74775_l("multiblockData");
            }
        } else if (data.func_74764_b("multiblockData")) {
            NBTTagCompound tag = data.func_74775_l("multiblockData");
            if (this.isConnected()) {
                ((Multiblock)this.getMultiblock()).syncDataFrom(tag, syncReason);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        if (TileBeefAbstract.SyncReason.FullSync == syncReason) {
            if (this.isMultiblockSaveDelegate() && this.isConnected()) {
                NBTTagCompound multiblockData = new NBTTagCompound();
                ((Multiblock)this.multiblock).syncDataTo(multiblockData, syncReason);
                data.func_74782_a("multiblockData", (NBTBase)multiblockData);
            }
        } else if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound tag = new NBTTagCompound();
            ((Multiblock)this.multiblock).syncDataTo(tag, syncReason);
            data.func_74782_a("multiblockData", (NBTBase)tag);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.detachSelf(false);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.detachSelf(true);
    }

    public void func_145829_t() {
        super.func_145829_t();
        MultiblockRegistry.INSTANCE.onPartAdded(this.func_145831_w(), this);
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public NBTTagCompound getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MULTIBLOCK var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    @Override
    public boolean isConnected() {
        return this.multiblock != null;
    }

    @Override
    public MULTIBLOCK getMultiblock() {
        return this.multiblock;
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(MULTIBLOCK newMultiblock) {
        assert (this.multiblock != newMultiblock);
        this.multiblock = newMultiblock;
    }

    @Override
    public void onAttached(MULTIBLOCK newMultiblock) {
        this.multiblock = newMultiblock;
    }

    @Override
    public void onDetached(MULTIBLOCK oldMultiblock) {
        this.multiblock = null;
    }

    @Override
    public abstract MULTIBLOCK createNewMultiblock();

    @Override
    public ITileMultiblockPart<MULTIBLOCK>[] getNeighboringParts() {
        ArrayList<ITileMultiblockPart> neighborParts = new ArrayList<ITileMultiblockPart>();
        BlockPos partPosition = this.field_174879_c;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos neighborPosition = partPosition.func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(neighborPosition);
            if (!(te instanceof ITileMultiblockPart)) continue;
            neighborParts.add((ITileMultiblockPart)te);
        }
        return neighborParts.toArray(new ITileMultiblockPart[neighborParts.size()]);
    }

    @Override
    public void onOrphaned(MULTIBLOCK multiblock, int oldSize, int newSize) {
        this.func_70296_d();
    }

    @Override
    public boolean isPartInvalid() {
        return this.func_145837_r();
    }

    public boolean isMultiblockAssembled() {
        return this.multiblock != null && ((Multiblock)this.multiblock).isAssembled();
    }

    protected void doStandardNullControllerResponse(MULTIBLOCK controller) {
        if (controller == null) {
            throw this.nullControllerError();
        }
        if (this.multiblock == null) {
            this.nullControllerWarn();
            this.onAttached(controller);
        }
    }

    protected void setStandardLastError(Multiblock multiblock) {
        multiblock.setLastError("nuclearcraft.multiblock_validation.invalid_block", this.func_174877_v(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.getBlock(this.func_174877_v()).func_149732_F());
    }

    protected IllegalArgumentException nullControllerError() {
        return new IllegalArgumentException("Attempted to attach " + this.getBlock(this.func_174877_v()).func_149732_F() + " to a null controller. This should never happen - please report this bug to the NuclearCraft GitHub repo!");
    }

    protected void nullControllerWarn() {
        NCUtil.getLogger().warn(this.getBlock(this.func_174877_v()).func_149732_F() + " at (%d, %d, %d) is being assembled without being attached to a controller. It is recommended that the multiblock is completely disassambled and rebuilt if these errors continue!", (Object)this.func_174877_v().func_177958_n(), (Object)this.func_174877_v().func_177956_o(), (Object)this.func_174877_v().func_177952_p());
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.multiblock != null) {
            ((Multiblock)this.multiblock).detachBlock(this, chunkUnloading);
            this.multiblock = null;
        }
        MultiblockRegistry.INSTANCE.onPartRemovedFromWorld(this.func_145831_w(), this);
    }

    protected void markMultiblockForRenderUpdate() {
        if (this.multiblock != null) {
            ((Multiblock)this.multiblock).markMultiblockForRenderUpdate();
        }
    }
}

