/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine.tile;

import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbineLogic;
import nc.multiblock.turbine.tile.TileTurbineDynamoPart;
import nc.multiblock.turbine.tile.TileTurbinePart;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileTurbineComputerPort
extends TileTurbinePart
implements SimpleComponent {
    public TileTurbineComputerPort() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public void onMachineAssembled(Turbine controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_turbine";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isComplete(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isTurbineOn(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).isTurbineOn : false};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthX(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getInteriorLengthX() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthY(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getInteriorLengthY() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthZ(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getInteriorLengthZ() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).isProcessing : false};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyStored(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).energyStorage.getEnergyStored() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyCapacity(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).energyStorage.getMaxEnergyStored() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getPower(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).power : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getCoilConductivity(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).conductivity : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFlowDirection(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() && ((Turbine)this.getMultiblock()).flowDir != null ? ((Turbine)this.getMultiblock()).flowDir.func_176610_l() : "null"};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getTotalExpansionLevel(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).totalExpansionLevel : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getIdealTotalExpansionLevel(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).idealTotalExpansionLevel : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getExpansionLevels(Context context, Arguments args) {
        return this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).expansionLevels.toArray() : new Object[]{};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getIdealExpansionLevels(Context context, Arguments args) {
        return this.isMultiblockAssembled() ? ((TurbineLogic)this.getLogic()).getIdealExpansionLevels().toArray() : new Object[]{};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getBladeEfficiencies(Context context, Arguments args) {
        return this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).rawBladeEfficiencies.toArray() : new Object[]{};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getInputRate(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).recipeInputRate : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfDynamoParts(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Turbine)this.getMultiblock()).getPartMap(TileTurbineDynamoPart.class).size() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getDynamoPartStats(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ArrayList<Object[]> stats = new ArrayList<Object[]>();
            for (TileTurbineDynamoPart dynamoPart : ((Turbine)this.getMultiblock()).getPartMap(TileTurbineDynamoPart.class).values()) {
                stats.add(new Object[]{new Object[]{dynamoPart.func_174877_v().func_177958_n(), dynamoPart.func_174877_v().func_177956_o(), dynamoPart.func_174877_v().func_177952_p()}, dynamoPart.partName, dynamoPart.isInValidPosition});
            }
            return new Object[]{stats.toArray()};
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] activate(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((Turbine)this.getMultiblock()).computerActivated = true;
            ((TurbineLogic)this.getLogic()).setIsTurbineOn();
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] deactivate(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((Turbine)this.getMultiblock()).computerActivated = false;
            ((TurbineLogic)this.getLogic()).setIsTurbineOn();
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] clearAllMaterial(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((Turbine)this.getMultiblock()).clearAllMaterial();
        }
        return new Object[0];
    }
}

