/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine.tile;

import nc.block.property.BlockProperties;
import nc.multiblock.container.ContainerMultiblockController;
import nc.multiblock.container.ContainerTurbineController;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbineLogic;
import nc.multiblock.turbine.tile.ITurbineController;
import nc.multiblock.turbine.tile.TileTurbinePart;
import nc.util.NCMath;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTurbineController
extends TileTurbinePart
implements ITurbineController {
    private boolean isRenderer = false;

    public TileTurbineController() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public String getLogicID() {
        return "turbine";
    }

    @Override
    public void onMachineAssembled(Turbine controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)this.getPartPosition().getFacing()), 2);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    public ContainerMultiblockController getContainer(EntityPlayer player) {
        return new ContainerTurbineController(player, this);
    }

    @Override
    public int[] weakSidesToCheck(World world, BlockPos pos) {
        return new int[]{2, 3, 4, 5};
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isRenderer || !this.isMultiblockAssembled()) {
            return Block.field_185505_j.func_186670_a(this.field_174879_c);
        }
        return new AxisAlignedBB(((Turbine)this.getMultiblock()).getMinimumCoord(), ((Turbine)this.getMultiblock()).getMaximumCoord());
    }

    public double func_145835_a(double x, double y, double z) {
        double dZ;
        double dY;
        double dX;
        if (!this.isRenderer || !this.isMultiblockAssembled()) {
            dX = (double)this.field_174879_c.func_177958_n() + 0.5 - x;
            dY = (double)this.field_174879_c.func_177956_o() + 0.5 - y;
            dZ = (double)this.field_174879_c.func_177952_p() + 0.5 - z;
        } else {
            dX = (double)((Turbine)this.getMultiblock()).getMiddleX() + 0.5 - x;
            dY = (double)((Turbine)this.getMultiblock()).getMiddleY() + 0.5 - y;
            dZ = (double)((Turbine)this.getMultiblock()).getMiddleZ() + 0.5 - z;
        }
        return dX * dX + dY * dY + dZ * dZ;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        double defaultDistSq = super.func_145833_n();
        if (!this.isRenderer || !this.isMultiblockAssembled()) {
            return defaultDistSq;
        }
        return defaultDistSq + (double)(NCMath.sq(((Turbine)this.getMultiblock()).getExteriorLengthX()) + NCMath.sq(((Turbine)this.getMultiblock()).getExteriorLengthY()) + NCMath.sq(((Turbine)this.getMultiblock()).getExteriorLengthZ())) / 4.0;
    }

    @Override
    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        super.onBlockNeighborChanged(state, world, pos, fromPos);
        if (this.getMultiblock() != null) {
            ((TurbineLogic)this.getLogic()).setIsTurbineOn();
        }
    }

    @Override
    public boolean isRenderer() {
        return this.isRenderer;
    }

    @Override
    public void setIsRenderer(boolean isRenderer) {
        this.isRenderer = isRenderer;
    }
}

