/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.tile.fluid.ITileFluid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class EmptyTankPacket
implements IMessage {
    private BlockPos pos;
    private int tankNo;

    public EmptyTankPacket() {
    }

    public EmptyTankPacket(ITileFluid machine, int tankNo) {
        this.pos = machine.getTilePos();
        this.tankNo = tankNo;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.tankNo = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.tankNo);
    }

    public static class Handler
    implements IMessageHandler<EmptyTankPacket, IMessage> {
        public IMessage onMessage(EmptyTankPacket message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            }
            return null;
        }

        void processMessage(EmptyTankPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            if (!world.func_175667_e(message.pos) || !world.func_175660_a((EntityPlayer)player, message.pos)) {
                return;
            }
            TileEntity tile = world.func_175625_s(message.pos);
            if (tile instanceof ITileFluid) {
                ITileFluid machine = (ITileFluid)tile;
                machine.clearTank(message.tankNo);
                tile.func_70296_d();
            }
        }
    }
}

