/*
 * Decompiled with CFR 0.152.
 */
package nc.network.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.List;
import nc.network.multiblock.FissionPortUpdatePacket;
import nc.network.tile.TileUpdatePacket;
import nc.tile.ITileGui;
import nc.tile.internal.fluid.Tank;
import net.minecraft.util.math.BlockPos;

public class FissionHeaterPortUpdatePacket
extends FissionPortUpdatePacket {
    public List<Tank.TankInfo> tanksInfo;
    public List<Tank.TankInfo> filterTanksInfo;

    public FissionHeaterPortUpdatePacket() {
    }

    public FissionHeaterPortUpdatePacket(BlockPos pos, BlockPos masterPortPos, List<Tank> tanks, List<Tank> filterTanks) {
        super(pos, masterPortPos);
        this.tanksInfo = Tank.TankInfo.infoList(tanks);
        this.filterTanksInfo = Tank.TankInfo.infoList(filterTanks);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        byte numberOfTanks = buf.readByte();
        this.tanksInfo = Tank.TankInfo.readBuf(buf, numberOfTanks);
        byte numberOfFilterTanks = buf.readByte();
        this.filterTanksInfo = Tank.TankInfo.readBuf(buf, numberOfFilterTanks);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.tanksInfo.size());
        for (Tank.TankInfo info : this.tanksInfo) {
            info.writeBuf(buf);
        }
        buf.writeByte(this.filterTanksInfo.size());
        for (Tank.TankInfo info : this.filterTanksInfo) {
            info.writeBuf(buf);
        }
    }

    public static class Handler
    extends TileUpdatePacket.Handler<FissionHeaterPortUpdatePacket, ITileGui> {
        @Override
        protected void onPacket(FissionHeaterPortUpdatePacket message, ITileGui processor) {
            processor.onGuiPacket(message);
        }
    }
}

