/*
 * Decompiled with CFR 0.152.
 */
package nc.network.multiblock;

import io.netty.buffer.ByteBuf;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.tile.TileTurbineController;
import nc.network.multiblock.MultiblockUpdatePacket;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TurbineRenderPacket
extends MultiblockUpdatePacket {
    public String particleEffect;
    public double particleSpeedMult;
    public double recipeInputRateFP;
    public float angVel;
    public boolean isProcessing;
    public int recipeInputRate;

    public TurbineRenderPacket() {
    }

    public TurbineRenderPacket(BlockPos pos, String particleEffect, double particleSpeedMult, float angVel, boolean isProcessing, int recipeInputRate, double recipeInputRateFP) {
        this.pos = pos;
        this.particleEffect = particleEffect;
        this.particleSpeedMult = particleSpeedMult;
        this.angVel = angVel;
        this.isProcessing = isProcessing;
        this.recipeInputRate = recipeInputRate;
        this.recipeInputRateFP = recipeInputRateFP;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.particleEffect = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.particleSpeedMult = buf.readDouble();
        this.angVel = buf.readFloat();
        this.isProcessing = buf.readBoolean();
        this.recipeInputRate = buf.readInt();
        this.recipeInputRateFP = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.particleEffect);
        buf.writeDouble(this.particleSpeedMult);
        buf.writeFloat(this.angVel);
        buf.writeBoolean(this.isProcessing);
        buf.writeInt(this.recipeInputRate);
        buf.writeDouble(this.recipeInputRateFP);
    }

    public static class Handler
    extends MultiblockUpdatePacket.Handler<TurbineRenderPacket, Turbine, TileTurbineController> {
        public Handler() {
            super(TileTurbineController.class);
        }

        @Override
        protected void onPacket(TurbineRenderPacket message, Turbine multiblock) {
            multiblock.onRenderPacket(message);
        }
    }
}

