/*
 * Decompiled with CFR 0.152.
 */
package nc.proxy;

import crafttweaker.CraftTweakerAPI;
import java.io.IOException;
import nc.ModCheck;
import nc.capability.radiation.RadiationCapabilityHandler;
import nc.command.CommandHandler;
import nc.config.NCConfig;
import nc.handler.CapabilityHandler;
import nc.handler.DropHandler;
import nc.handler.DungeonLootHandler;
import nc.handler.EntityHandler;
import nc.handler.ItemUseHandler;
import nc.handler.OreDictHandler;
import nc.handler.PlayerRespawnHandler;
import nc.handler.ScriptAddonHandler;
import nc.init.NCAdvancements;
import nc.init.NCArmor;
import nc.init.NCBlocks;
import nc.init.NCCoolantFluids;
import nc.init.NCEntities;
import nc.init.NCFissionFluids;
import nc.init.NCFluids;
import nc.init.NCItems;
import nc.init.NCSounds;
import nc.init.NCTiles;
import nc.init.NCTools;
import nc.integration.crafttweaker.CTRegistration;
import nc.integration.hwyla.NCHWLYA;
import nc.integration.projecte.NCProjectE;
import nc.integration.tconstruct.TConstructIMC;
import nc.integration.tconstruct.TConstructMaterials;
import nc.integration.tconstruct.conarm.ConArmMaterials;
import nc.item.ItemMultitool;
import nc.multiblock.MultiblockHandler;
import nc.multiblock.MultiblockLogic;
import nc.multiblock.PlacementRule;
import nc.network.PacketHandler;
import nc.radiation.RadArmor;
import nc.radiation.RadBiomes;
import nc.radiation.RadEntities;
import nc.radiation.RadPotionEffects;
import nc.radiation.RadSources;
import nc.radiation.RadStructures;
import nc.radiation.RadWorlds;
import nc.radiation.RadiationHandler;
import nc.radiation.environment.RadiationEnvironmentHandler;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeStats;
import nc.recipe.vanilla.CraftingRecipeHandler;
import nc.util.GasHelper;
import nc.util.NCUtil;
import nc.util.OreDictHelper;
import nc.util.StructureHelper;
import nc.worldgen.biome.NCBiomes;
import nc.worldgen.decoration.MushroomGenerator;
import nc.worldgen.dimension.NCWorlds;
import nc.worldgen.ore.OreGenerator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameRegistry;
import slimeknights.tconstruct.library.materials.Material;

public class CommonProxy {
    public void onConstruction(FMLConstructionEvent constructionEvent) {
        try {
            ScriptAddonHandler.init();
        }
        catch (IOException e) {
            NCUtil.getLogger().catching((Throwable)e);
        }
    }

    public void preInit(FMLPreInitializationEvent preEvent) {
        ModCheck.init();
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockHandler());
        if (ModCheck.craftTweakerLoaded()) {
            CraftTweakerAPI.tweaker.loadScript(false, "nc_preinit");
        }
        NCSounds.init();
        NCBlocks.init();
        NCItems.init();
        NCTools.init();
        NCArmor.init();
        NCFluids.init();
        NCFissionFluids.init();
        NCCoolantFluids.init();
        NCBlocks.register();
        NCItems.register();
        NCTools.register();
        NCArmor.register();
        OreDictHandler.registerOres();
        NCTiles.register();
        for (CTRegistration.RegistrationInfo info : CTRegistration.INFO_LIST) {
            info.preInit();
        }
        NCFluids.register();
        NCFissionFluids.register();
        NCCoolantFluids.register();
        MultiblockHandler.init();
        MultiblockLogic.init();
        PlacementRule.preInit();
        PacketHandler.registerMessages("nuclearcraft");
        if (ModCheck.mekanismLoaded()) {
            GasHelper.preInit();
        }
        MinecraftForge.EVENT_BUS.register((Object)new NCRecipes());
        if (ModCheck.tinkersLoaded()) {
            TConstructMaterials.init();
            TConstructIMC.init();
        }
        if (ModCheck.constructsArmoryLoaded()) {
            ConArmMaterials.preInit();
        }
    }

    public void init(FMLInitializationEvent event) {
        this.initFluidColors();
        CapabilityHandler.init();
        NCRecipes.init();
        MinecraftForge.EVENT_BUS.register((Object)new DropHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DungeonLootHandler());
        RadSources.refreshRadSources(false);
        RadArmor.init();
        NCBiomes.initBiomeManagerAndDictionary();
        NCWorlds.registerDimensions();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new MushroomGenerator(NCBlocks.glowing_mushroom.func_176223_P()), (int)255);
        NCEntities.register();
        MinecraftForge.EVENT_BUS.register((Object)new EntityHandler());
        PlacementRule.init();
        ItemMultitool.registerRightClickLogic();
        if (ModCheck.constructsArmoryLoaded()) {
            ConArmMaterials.init();
        }
        if (ModCheck.hwylaLoaded()) {
            NCHWLYA.init();
        }
        for (CTRegistration.RegistrationInfo info : CTRegistration.INFO_LIST) {
            info.init();
        }
        NCAdvancements.init();
    }

    public void postInit(FMLPostInitializationEvent postEvent) {
        if (ModCheck.mekanismLoaded()) {
            GasHelper.init();
        }
        CraftingRecipeHandler.registerRadShieldingCraftingRecipes();
        RadArmor.postInit();
        RadWorlds.init();
        RadPotionEffects.init();
        RadSources.postInit();
        RadStructures.init();
        RadEntities.init();
        MinecraftForge.EVENT_BUS.register((Object)new RadiationCapabilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RadiationHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RadiationEnvironmentHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerRespawnHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemUseHandler());
        RecipeStats.init();
        PlacementRule.postInit();
        if (ModCheck.projectELoaded() && NCConfig.register_projecte_emc) {
            NCProjectE.addEMCValues();
        }
        for (CTRegistration.RegistrationInfo info : CTRegistration.INFO_LIST) {
            info.postInit();
        }
        CTRegistration.INFO_LIST.clear();
    }

    public void serverStart(FMLServerStartingEvent serverStartEvent) {
        RadBiomes.init();
        CommandHandler.registerCommands(serverStartEvent);
    }

    public void serverStop(FMLServerStoppedEvent serverStopEvent) {
        StructureHelper.CACHE.clear();
    }

    public void onIdMapping(FMLModIdMappingEvent idMappingEvent) {
        OreDictHelper.refreshOreDictCache();
        NCRecipes.refreshRecipeCaches();
        PlacementRule.refreshRecipeCaches();
        RadSources.refreshRadSources(true);
        RadArmor.refreshRadiationArmor();
    }

    public World getWorld(int dimensionId) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimensionId);
    }

    public int getCurrentClientDimension() {
        return Integer.MIN_VALUE;
    }

    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }

    public void registerFluidBlockRendering(Block block, String name) {
    }

    public void initFluidColors() {
    }

    @Optional.Method(modid="tconstruct")
    public void setRenderInfo(Material mat, int color) {
    }

    @Optional.Method(modid="tconstruct")
    public void setRenderInfo(Material mat, int lo, int mid, int hi) {
    }
}

