/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import nc.ModCheck;
import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.entity.EntityFeralGhoul;
import nc.init.NCSounds;
import nc.network.PacketHandler;
import nc.network.radiation.PlayerRadsUpdatePacket;
import nc.radiation.RadBiomes;
import nc.radiation.RadPotionEffects;
import nc.radiation.RadSources;
import nc.radiation.RadStructures;
import nc.radiation.RadWorlds;
import nc.radiation.RadiationHelper;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeHelper;
import nc.recipe.RecipeInfo;
import nc.recipe.RecipeStats;
import nc.tile.internal.fluid.Tank;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.DamageSources;
import nc.util.Lang;
import nc.util.StackHelper;
import nc.util.StructureHelper;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import vazkii.patchouli.common.item.ItemModBook;

public class RadiationHandler {
    private static final Random RAND = new Random();
    private static final String RAD_X_WORE_OFF = Lang.localise("message.nuclearcraft.rad_x_wore_off");
    private static final String RAD_WARNING = Lang.localise("message.nuclearcraft.rad_warning");
    private static EnumFacing tile_side = EnumFacing.DOWN;
    public static boolean default_rad_immunity = false;
    public static String[] rad_immunity_stages = new String[0];
    private static final List<byte[]> ADJACENT_COORDS = Lists.newArrayList((Object[])new byte[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}});

    @SubscribeEvent
    public void updatePlayerRadiation(TickEvent.PlayerTickEvent event) {
        if (NCConfig.radiation_enabled_public && !NCConfig.radiation_require_counter && event.phase == TickEvent.Phase.START && event.side == Side.CLIENT) {
            RadiationHandler.playGeigerSound(event.player);
        }
        UUID playerUUID = event.player.func_110124_au();
        if (event.phase != TickEvent.Phase.START || (event.player.field_70170_p.func_82737_E() + (long)playerUUID.hashCode()) % (long)NCConfig.radiation_player_tick_rate != 0L) {
            return;
        }
        if (event.side == Side.SERVER && event.player instanceof EntityPlayerMP) {
            double change;
            double radXDecayRate;
            double previousImmunityTime;
            boolean success;
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            IEntityRads playerRads = RadiationHelper.getEntityRadiation((EntityLivingBase)player);
            if (playerRads == null) {
                return;
            }
            if (NCConfig.give_guidebook && ModCheck.patchouliLoaded() && playerRads.getGiveGuidebook() && (success = player.field_71071_by.func_70441_a(ItemModBook.forBook((String)"nuclearcraft:guide")))) {
                playerRads.setGiveGuidebook(false);
            }
            if (!NCConfig.radiation_enabled_public) {
                return;
            }
            if (ModCheck.gameStagesLoaded()) {
                playerRads.setRadiationImmunityStage(default_rad_immunity ^ GameStageHelper.hasAnyOf((EntityPlayer)player, (String[])rad_immunity_stages));
            }
            String uuidString = playerUUID.toString();
            for (String uuid : NCConfig.radiation_immune_players) {
                if (!uuidString.equals(uuid)) continue;
                playerRads.setRadiationImmunityStage(true);
                break;
            }
            if (NCConfig.radiation_player_rads_fatal && !player.func_184812_l_() && !player.func_175149_v() && !playerRads.isImmune() && playerRads.isFatal()) {
                player.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
            }
            if ((previousImmunityTime = playerRads.getRadiationImmunityTime()) > 0.0) {
                playerRads.setRadiationImmunityTime(previousImmunityTime - (double)NCConfig.radiation_player_tick_rate);
            }
            double previousRadPercentage = playerRads.getRadsPercentage();
            playerRads.setExternalRadiationResistance(RadiationHelper.getArmorInventoryRadResistance((Entity)player));
            if (NCConfig.radiation_player_decay_rate > 0.0) {
                playerRads.setTotalRads(playerRads.getTotalRads() * Math.pow(1.0 - NCConfig.radiation_player_decay_rate, NCConfig.radiation_player_tick_rate), false);
            }
            double radiationLevel = RadiationHelper.transferRadsFromInventoryToPlayer(playerRads, (EntityPlayer)player, NCConfig.radiation_player_tick_rate);
            Chunk chunk = player.field_70170_p.func_72964_e((int)Math.floor(player.field_70165_t) >> 4, (int)Math.floor(player.field_70161_v) >> 4);
            if (chunk.func_177410_o()) {
                IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk);
                radiationLevel += RadiationHelper.transferRadsToPlayer(chunkSource, playerRads, (EntityPlayer)player, NCConfig.radiation_player_tick_rate);
            }
            if (playerRads.getPoisonBuffer() > 0.0) {
                double poisonRads = Math.min(playerRads.getPoisonBuffer() / (double)NCConfig.radiation_player_tick_rate, playerRads.getRecentPoisonAddition() / NCConfig.radiation_poison_time);
                radiationLevel += RadiationHelper.addRadsToEntity(playerRads, (EntityLivingBase)player, poisonRads, true, true, NCConfig.radiation_player_tick_rate);
                playerRads.setPoisonBuffer(playerRads.getPoisonBuffer() - poisonRads * (double)NCConfig.radiation_player_tick_rate);
                if (playerRads.getPoisonBuffer() == 0.0) {
                    playerRads.resetRecentPoisonAddition();
                }
            } else {
                playerRads.resetRecentPoisonAddition();
            }
            playerRads.setMessageCooldownTime(playerRads.getMessageCooldownTime() - NCConfig.radiation_player_tick_rate);
            playerRads.setRadiationLevel(radiationLevel);
            if (!(player.func_184812_l_() || player.func_175149_v() || playerRads.isImmune())) {
                if (NCConfig.radiation_player_rads_fatal && playerRads.isFatal()) {
                    player.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
                } else if (!RadPotionEffects.PLAYER_RAD_LEVEL_LIST.isEmpty() && previousRadPercentage < RadPotionEffects.PLAYER_RAD_LEVEL_LIST.get(0) && playerRads.getRadsPercentage() >= RadPotionEffects.PLAYER_RAD_LEVEL_LIST.get(0) && !RadiationHelper.shouldShowHUD((EntityPlayer)player)) {
                    playerRads.setShouldWarn(true);
                } else {
                    playerRads.setShouldWarn(false);
                }
            }
            double previousInternalResistance = playerRads.getInternalRadiationResistance();
            double recentRadXAdditionModified = NCConfig.radiation_rad_x_amount * (1.0 + playerRads.getRecentRadXAddition()) / (1.0 + NCConfig.radiation_rad_x_amount);
            if (previousInternalResistance > 0.0) {
                radXDecayRate = Math.max(previousInternalResistance, recentRadXAdditionModified) / NCConfig.radiation_rad_x_lifetime;
                playerRads.setInternalRadiationResistance(Math.max(0.0, previousInternalResistance - radXDecayRate * (double)NCConfig.radiation_player_tick_rate));
                if (playerRads.getInternalRadiationResistance() == 0.0) {
                    playerRads.resetRecentRadXAddition();
                    playerRads.setRadXWoreOff(true);
                }
            } else {
                if (previousInternalResistance < 0.0) {
                    radXDecayRate = Math.max(-previousInternalResistance, recentRadXAdditionModified) / NCConfig.radiation_rad_x_lifetime;
                    playerRads.setInternalRadiationResistance(Math.min(0.0, previousInternalResistance + radXDecayRate * (double)NCConfig.radiation_player_tick_rate));
                    if (playerRads.getInternalRadiationResistance() == 0.0) {
                        playerRads.resetRecentRadXAddition();
                    }
                } else {
                    playerRads.resetRecentRadXAddition();
                }
                playerRads.setRadXWoreOff(false);
            }
            if (playerRads.getRadXWoreOff() && playerRads.getRadXUsed()) {
                playerRads.setRadXUsed(false);
            }
            if (playerRads.getRadawayBuffer(false) > 0.0) {
                change = Math.min(playerRads.getRadawayBuffer(false), playerRads.getRecentRadawayAddition() * NCConfig.radiation_radaway_rate * (double)NCConfig.radiation_player_tick_rate / NCConfig.radiation_radaway_amount);
                playerRads.setTotalRads(playerRads.getTotalRads() - change, false);
                playerRads.setRadawayBuffer(false, playerRads.getRadawayBuffer(false) - change);
                if (playerRads.getRadawayBuffer(false) == 0.0) {
                    playerRads.resetRecentRadawayAddition();
                }
            } else {
                playerRads.resetRecentRadawayAddition();
            }
            if (playerRads.getRadawayBuffer(true) > 0.0) {
                change = Math.min(playerRads.getRadawayBuffer(true), NCConfig.radiation_radaway_slow_rate * (double)NCConfig.radiation_player_tick_rate);
                playerRads.setTotalRads(playerRads.getTotalRads() - change, false);
                playerRads.setRadawayBuffer(true, playerRads.getRadawayBuffer(true) - change);
            }
            if (playerRads.getRadawayCooldown() > 0.0) {
                playerRads.setRadawayCooldown(playerRads.getRadawayCooldown() - (double)NCConfig.radiation_player_tick_rate);
            }
            if (playerRads.getRadXCooldown() > 0.0) {
                playerRads.setRadXCooldown(playerRads.getRadXCooldown() - (double)NCConfig.radiation_player_tick_rate);
            }
            PacketHandler.instance.sendTo((IMessage)new PlayerRadsUpdatePacket(playerRads), player);
            if (!(player.func_184812_l_() || player.func_175149_v() || playerRads.isImmune())) {
                RadiationHelper.applyPotionEffects((EntityLivingBase)player, playerRads, 1, RadPotionEffects.PLAYER_RAD_LEVEL_LIST, RadPotionEffects.PLAYER_DEBUFF_LIST);
            }
        } else {
            if (!NCConfig.radiation_enabled_public) {
                return;
            }
            EntityPlayer player = event.player;
            IEntityRads playerRads = RadiationHelper.getEntityRadiation((EntityLivingBase)player);
            if (playerRads == null) {
                return;
            }
            if (playerRads.getRadXWoreOff() && playerRads.getRadXUsed()) {
                player.func_184185_a(NCSounds.chems_wear_off, (float)(0.65 * NCConfig.radiation_sound_volumes[4]), 1.0f);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + RAD_X_WORE_OFF));
            }
            if (playerRads.getShouldWarn()) {
                player.func_184185_a(NCSounds.chems_wear_off, (float)(0.8 * NCConfig.radiation_sound_volumes[6]), 0.7f);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + RAD_WARNING));
            }
        }
    }

    @SubscribeEvent
    public void updateWorldRadiation(TickEvent.WorldTickEvent event) {
        Chunk chunk;
        int i;
        String randomStructure;
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (event.phase != TickEvent.Phase.START || event.side == Side.CLIENT || !(event.world instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)event.world;
        ChunkProviderServer chunkProvider = world.func_72863_F();
        Collection loadedChunks = chunkProvider.func_189548_a();
        int chunkArrSize = loadedChunks.size();
        Chunk[] chunkArray = null;
        try {
            chunkArray = loadedChunks.toArray(new Chunk[chunkArrSize]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (chunkArray == null) {
            return;
        }
        int chunkStart = RAND.nextInt(chunkArrSize + 1);
        int chunksPerTick = Math.min(NCConfig.radiation_world_chunks_per_tick, chunkArrSize);
        int tickMult = chunkArrSize > 0 ? Math.max(1, chunkArrSize / chunksPerTick) : 1;
        BiomeProvider biomeProvider = world.func_72959_q();
        int dimension = world.field_73011_w.getDimension();
        BlockPos randomOffsetPos = RadiationHandler.newRandomOffsetPos((World)world);
        String string = randomStructure = ModCheck.cubicChunksLoaded() || RadStructures.STRUCTURE_LIST.isEmpty() ? null : RadStructures.STRUCTURE_LIST.get(RAND.nextInt(RadStructures.STRUCTURE_LIST.size()));
        if (chunkArrSize > 0) {
            for (i = chunkStart; i < chunkStart + chunksPerTick; ++i) {
                Biome biome;
                int packed;
                Double structureRadiation;
                Double biomeRadiation;
                TileEntity[] entityRads;
                IRadiationSource chunkSource;
                chunk = chunkArray[i % chunkArrSize];
                if (!chunk.func_177410_o() || (chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk)) == null) continue;
                ClassInheritanceMultiMap[] entityListArray = chunk.func_177429_s();
                for (int j = 0; j < entityListArray.length; ++j) {
                    Entity[] entityArray;
                    for (Entity entity : entityArray = (Entity[])entityListArray[j].toArray((Object[])new Entity[entityListArray[j].size()])) {
                        EntityLiving entityLiving;
                        if (entity instanceof EntityPlayer) {
                            RadiationHelper.transferRadsFromInventoryToChunkBuffer(((EntityPlayer)entity).field_71071_by, chunkSource);
                            continue;
                        }
                        if (NCConfig.radiation_dropped_items && entity instanceof EntityItem) {
                            RadiationHelper.transferRadiationFromStackToChunkBuffer(((EntityItem)entity).func_92059_d(), chunkSource, 1.0);
                            continue;
                        }
                        if (!(entity instanceof EntityLiving) || (entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)(entityLiving = (EntityLiving)entity))) == null) continue;
                        entityRads.setExternalRadiationResistance(RadiationHelper.getEntityArmorRadResistance((EntityLivingBase)entityLiving));
                        if (NCConfig.radiation_entity_decay_rate > 0.0) {
                            entityRads.setTotalRads(entityRads.getTotalRads() * Math.pow(1.0 - NCConfig.radiation_entity_decay_rate, tickMult), false);
                        }
                        RadiationHelper.transferRadsFromSourceToEntity(chunkSource, (IEntityRads)entityRads, (EntityLivingBase)entityLiving, tickMult);
                        if (entityRads.getPoisonBuffer() > 0.0) {
                            double poisonRads = Math.min(entityRads.getPoisonBuffer(), entityRads.getRecentPoisonAddition() * (double)tickMult / NCConfig.radiation_poison_time);
                            entityRads.setTotalRads(entityRads.getTotalRads() + poisonRads, false);
                            entityRads.setPoisonBuffer(entityRads.getPoisonBuffer() - poisonRads);
                            if (entityRads.getPoisonBuffer() == 0.0) {
                                entityRads.resetRecentPoisonAddition();
                            }
                        } else {
                            entityRads.resetRecentPoisonAddition();
                        }
                        if (entityLiving instanceof IMob) {
                            if (NCConfig.radiation_mob_rads_fatal && entityRads.isFatal()) {
                                entityLiving.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
                            } else {
                                RadiationHelper.applyPotionEffects((EntityLivingBase)entityLiving, (IEntityRads)entityRads, tickMult, RadPotionEffects.MOB_RAD_LEVEL_LIST, RadPotionEffects.MOB_EFFECTS_LIST);
                            }
                        } else if (entityRads.isFatal()) {
                            if (NCConfig.register_entity[0] && entityLiving instanceof INpc) {
                                RadiationHandler.spawnFeralGhoul((World)world, entityLiving);
                            } else if (NCConfig.radiation_passive_rads_fatal) {
                                entityLiving.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
                            }
                        } else {
                            RadiationHelper.applyPotionEffects((EntityLivingBase)entityLiving, (IEntityRads)entityRads, tickMult, RadPotionEffects.ENTITY_RAD_LEVEL_LIST, RadPotionEffects.ENTITY_DEBUFF_LIST);
                        }
                        entityRads.setRadiationLevel(entityRads.getRadiationLevel() * Math.pow(1.0 - NCConfig.radiation_decay_rate, tickMult));
                    }
                }
                chunkSource.setScrubbingFraction(0.0);
                chunkSource.setEffectiveScrubberCount(0.0);
                Collection tileCollection = chunk.func_177434_r().values();
                TileEntity[] tileArray = null;
                try {
                    tileArray = tileCollection.toArray(new TileEntity[tileCollection.size()]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tileArray != null) {
                    for (Entity entity : tileArray) {
                        RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)entity, tile_side, chunkSource);
                    }
                }
                if (RadWorlds.RAD_MAP.containsKey(dimension)) {
                    RadiationHelper.addToSourceBuffer(chunkSource, RadWorlds.RAD_MAP.get(dimension));
                }
                if (!RadBiomes.DIM_BLACKLIST.contains(dimension) && (biomeRadiation = (Double)RadBiomes.RAD_MAP.get((Object)chunk.func_177411_a(randomOffsetPos, biomeProvider))) != null) {
                    RadiationHelper.addToSourceBuffer(chunkSource, biomeRadiation);
                }
                BlockPos randomChunkPos = RadiationHandler.newRandomPosInChunk((World)world, chunk);
                if (randomStructure != null && StructureHelper.CACHE.isInStructure((World)world, randomStructure, randomChunkPos) && (structureRadiation = (Double)RadStructures.RAD_MAP.get((Object)randomStructure)) != null) {
                    RadiationHelper.addToSourceBuffer(chunkSource, structureRadiation);
                }
                if (NCConfig.radiation_check_blocks && i == chunkStart && RadSources.STACK_MAP.containsKey(packed = RecipeItemHelper.func_194113_b((ItemStack)StackHelper.blockStateToStack(world.func_180495_p(randomChunkPos))))) {
                    RadiationHelper.addToSourceBuffer(chunkSource, RadSources.STACK_MAP.get(packed));
                }
                double currentLevel = chunkSource.getRadiationLevel();
                double d = chunkSource.getRadiationBuffer();
                entityRads = tileArray;
                int n = entityRads.length;
                for (int j = 0; j < n; ++j) {
                    TileEntity tile = entityRads[j];
                    if (!(tile instanceof ITileRadiationEnvironment)) continue;
                    ((ITileRadiationEnvironment)tile).setCurrentChunkRadiationLevel(currentLevel);
                    ((ITileRadiationEnvironment)tile).setCurrentChunkRadiationBuffer(d);
                    RadiationHelper.addScrubbingFractionToChunk(RadiationHelper.getRadiationSource((ICapabilityProvider)chunk), (ITileRadiationEnvironment)tile);
                }
                if (NCConfig.radiation_scrubber_non_linear) {
                    double scrubbers = chunkSource.getEffectiveScrubberCount();
                    double scrubbingFraction = RadiationHelper.getAltScrubbingFraction(scrubbers);
                    RadiationHelper.addToSourceBuffer(chunkSource, -scrubbingFraction * chunkSource.getRadiationBuffer());
                    chunkSource.setScrubbingFraction(scrubbingFraction);
                }
                double changeRate = chunkSource.getRadiationLevel() < chunkSource.getRadiationBuffer() ? NCConfig.radiation_spread_rate : NCConfig.radiation_decay_rate * (1.0 - chunkSource.getScrubbingFraction()) + NCConfig.radiation_spread_rate * chunkSource.getScrubbingFraction();
                double newLevel = Math.max(0.0, chunkSource.getRadiationLevel() + (chunkSource.getRadiationBuffer() - chunkSource.getRadiationLevel()) * changeRate);
                if (NCConfig.radiation_chunk_limit >= 0.0) {
                    newLevel = Math.min(newLevel, NCConfig.radiation_chunk_limit);
                }
                if (RadBiomes.LIMIT_MAP.containsKey((Object)(biome = chunk.func_177411_a(randomOffsetPos, biomeProvider)))) {
                    newLevel = Math.min(newLevel, (Double)RadBiomes.LIMIT_MAP.get((Object)biome));
                }
                if (RadWorlds.LIMIT_MAP.containsKey(dimension)) {
                    newLevel = Math.min(newLevel, RadWorlds.LIMIT_MAP.get(dimension));
                }
                chunkSource.setRadiationLevel(newLevel);
                RadiationHandler.mutateTerrain((World)world, chunk, newLevel);
            }
        }
        if (chunkArrSize > 0) {
            for (i = chunkStart; i < chunkStart + chunksPerTick; ++i) {
                chunk = chunkArray[i % chunkArrSize];
                RadiationHelper.spreadRadiationFromChunk(chunk, RadiationHandler.getRandomAdjacentChunk(chunkProvider, chunk));
            }
        }
        tile_side = EnumFacing.func_82600_a((int)(tile_side.func_176745_a() + 1));
    }

    private static Chunk getRandomAdjacentChunk(ChunkProviderServer chunkProvider, Chunk chunk) {
        if (chunkProvider == null || chunk == null || !chunk.func_177410_o()) {
            return null;
        }
        int x = chunk.func_76632_l().field_77276_a;
        int z = chunk.func_76632_l().field_77275_b;
        Collections.shuffle(ADJACENT_COORDS);
        for (byte[] pos : ADJACENT_COORDS) {
            Chunk adjChunk;
            if (!chunkProvider.func_73149_a(x + pos[0], z + pos[1]) || (adjChunk = chunkProvider.func_186026_b(x + pos[0], z + pos[1])) == null) continue;
            return adjChunk;
        }
        return null;
    }

    private static BlockPos newRandomOffsetPos(World world) {
        return new BlockPos(RAND.nextInt(16), RAND.nextInt(world.func_72800_K()), RAND.nextInt(16));
    }

    private static BlockPos newRandomPosInChunk(World world, Chunk chunk) {
        return chunk.func_76632_l().func_180331_a(RAND.nextInt(16), RAND.nextInt(world.func_72800_K()), RAND.nextInt(16));
    }

    private static void mutateTerrain(World world, Chunk chunk, double radiation) {
        IBlockState result;
        ItemStack output;
        RecipeInfo mutationInfo;
        ItemStack stack;
        IBlockState state;
        BlockPos randomChunkPos;
        long j;
        for (j = Math.min((long)NCConfig.radiation_block_effect_max_rate, (long)Math.log(1.718281828459045 + radiation / RecipeStats.getBlockMutationThreshold())); j > 0L; --j) {
            randomChunkPos = RadiationHandler.newRandomPosInChunk(world, chunk);
            state = world.func_180495_p(randomChunkPos);
            stack = StackHelper.blockStateToStack(state);
            if (stack == null || stack.func_190926_b() || (mutationInfo = NCRecipes.radiation_block_mutation.getRecipeInfoFromInputs(Lists.newArrayList((Object[])new ItemStack[]{stack}), new ArrayList<Tank>())) == null || !(radiation >= ((BasicRecipe)mutationInfo.getRecipe()).getBlockMutationThreshold()) || (output = RecipeHelper.getItemStackFromIngredientList(((BasicRecipe)mutationInfo.getRecipe()).getItemProducts(), 0)) == null || (result = StackHelper.getBlockStateFromStack(output)) == null) continue;
            world.func_175656_a(randomChunkPos, result);
        }
        long l = j = radiation == 0.0 ? (long)NCConfig.radiation_block_effect_max_rate : Math.min((long)NCConfig.radiation_block_effect_max_rate, (long)Math.log(1.718281828459045 + RecipeStats.getBlockPurificationThreshold() / radiation));
        while (j > 0L) {
            --j;
            randomChunkPos = RadiationHandler.newRandomPosInChunk(world, chunk);
            state = world.func_180495_p(randomChunkPos);
            stack = StackHelper.blockStateToStack(state);
            if (stack == null || stack.func_190926_b() || (mutationInfo = NCRecipes.radiation_block_purification.getRecipeInfoFromInputs(Lists.newArrayList((Object[])new ItemStack[]{stack}), new ArrayList<Tank>())) == null || !(radiation < ((BasicRecipe)mutationInfo.getRecipe()).getBlockMutationThreshold()) || (output = RecipeHelper.getItemStackFromIngredientList(((BasicRecipe)mutationInfo.getRecipe()).getItemProducts(), 0)) == null || (result = StackHelper.getBlockStateFromStack(output)) == null) continue;
            world.func_175656_a(randomChunkPos, result);
        }
    }

    public static void playGeigerSound(EntityPlayer player) {
        int loops;
        IEntityRads entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)player);
        if (entityRads == null || entityRads.isRawRadiationNegligible()) {
            return;
        }
        double radiation = entityRads.getRawRadiationLevel();
        int n = loops = radiation == 0.0 ? 0 : Math.min(4, (int)Math.log(Math.E + entityRads.getRawRadiationLevel()));
        if (loops == 0) {
            return;
        }
        double soundChance = Math.cbrt(entityRads.getRawRadiationLevel() / 200.0);
        double soundVolume = MathHelper.func_151237_a((double)(8.0 * soundChance), (double)0.55, (double)1.1);
        for (int i = 0; i < loops; ++i) {
            if (!(RAND.nextDouble() < soundChance)) continue;
            player.func_184185_a(NCSounds.geiger_tick, (float)((soundVolume + RAND.nextDouble() * 0.12) * NCConfig.radiation_sound_volumes[0]), 0.92f + RAND.nextFloat() * 0.16f);
        }
    }

    private static void spawnFeralGhoul(World world, EntityLiving entityLiving) {
        EntityFeralGhoul feralGhoul = new EntityFeralGhoul(world);
        feralGhoul.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, entityLiving.field_70177_z, entityLiving.field_70125_A);
        feralGhoul.func_180482_a(world.func_175649_E(new BlockPos((Entity)feralGhoul)), null);
        feralGhoul.func_94061_f(entityLiving.func_175446_cd());
        if (entityLiving.func_145818_k_()) {
            feralGhoul.func_96094_a(entityLiving.func_95999_t());
            feralGhoul.func_174805_g(entityLiving.func_174833_aM());
        }
        world.func_72838_d((Entity)feralGhoul);
        entityLiving.func_70106_y();
    }
}

