/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import baubles.api.BaubleType;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import ic2.api.reactor.IReactor;
import java.util.List;
import nc.ModCheck;
import nc.capability.radiation.IRadiation;
import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.init.NCItems;
import nc.radiation.RadSources;
import nc.tile.dummy.TileDummy;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.ArmorHelper;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RadiationHelper {
    public static IEntityRads getEntityRadiation(EntityLivingBase entity) {
        if (entity == null || !entity.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            return null;
        }
        return (IEntityRads)entity.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
    }

    public static IRadiationSource getRadiationSource(ICapabilityProvider provider) {
        if (provider == null || !provider.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return null;
        }
        return (IRadiationSource)provider.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
    }

    public static IRadiationResistance getRadiationResistance(ICapabilityProvider provider) {
        if (provider == null || !provider.hasCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null)) {
            return null;
        }
        return (IRadiationResistance)provider.getCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null);
    }

    public static boolean hasInfiniteRadiationResistance(ICapabilityProvider provider) {
        IRadiationResistance resistance = RadiationHelper.getRadiationResistance(provider);
        return resistance != null && resistance.getTotalRadResistance() == Double.POSITIVE_INFINITY;
    }

    public static IItemHandler getTileInventory(ICapabilityProvider provider, EnumFacing side) {
        if (!(provider instanceof TileEntity) || provider instanceof TileDummy || RadiationHelper.hasInfiniteRadiationResistance(provider) || !provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return null;
        }
        return (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    public static IFluidHandler getTileTanks(ICapabilityProvider provider, EnumFacing side) {
        if (!(provider instanceof TileEntity) || provider instanceof TileDummy || RadiationHelper.hasInfiniteRadiationResistance(provider) || !provider.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return null;
        }
        return (IFluidHandler)provider.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
    }

    public static void addToSourceBuffer(IRadiationSource source, double addedRadiation) {
        source.setRadiationBuffer(source.getRadiationBuffer() + addedRadiation);
    }

    public static void addToSourceRadiation(IRadiationSource source, double addedRadiation) {
        source.setRadiationLevel(source.getRadiationLevel() + addedRadiation);
    }

    public static void addScrubbingFractionToChunk(IRadiationSource chunkSource, ITileRadiationEnvironment tile) {
        if (chunkSource == null) {
            return;
        }
        if (NCConfig.radiation_scrubber_non_linear) {
            if (tile.getRadiationContributionFraction() < 0.0) {
                chunkSource.setEffectiveScrubberCount(chunkSource.getEffectiveScrubberCount() - tile.getRadiationContributionFraction());
            }
        } else {
            RadiationHelper.addToSourceBuffer(chunkSource, tile.getRadiationContributionFraction() * tile.getCurrentChunkRadiationBuffer());
            if (tile.getRadiationContributionFraction() < 0.0) {
                chunkSource.setScrubbingFraction(chunkSource.getScrubbingFraction() - tile.getRadiationContributionFraction());
                chunkSource.setEffectiveScrubberCount(chunkSource.getEffectiveScrubberCount() - tile.getRadiationContributionFraction());
            }
        }
    }

    public static double getAltScrubbingFraction(double scrubbers) {
        return scrubbers <= 0.0 ? 0.0 : 1.0 - Math.pow(NCConfig.radiation_scrubber_param[0], -Math.pow(scrubbers / NCConfig.radiation_scrubber_param[1], Math.pow(scrubbers / NCConfig.radiation_scrubber_param[2] + 1.0, 1.0 / NCConfig.radiation_scrubber_param[3])));
    }

    public static void transferRadiationFromStackToChunkBuffer(ItemStack stack, IRadiationSource chunkSource, double multiplier) {
        if (chunkSource == null) {
            return;
        }
        RadiationHelper.addToSourceBuffer(chunkSource, RadiationHelper.getRadiationFromStack(stack, multiplier));
    }

    public static double getRadiationFromStack(ItemStack stack, double multiplier) {
        if (stack.func_190926_b()) {
            return 0.0;
        }
        IRadiationSource stackSource = RadiationHelper.getRadiationSource((ICapabilityProvider)stack);
        return stackSource == null ? 0.0 : stackSource.getRadiationLevel() * (double)stack.func_190916_E() * multiplier;
    }

    public static double getRadiationFromFluid(FluidStack stack, double multiplier) {
        if (stack == null || stack.getFluid() == null) {
            return 0.0;
        }
        return RadSources.FLUID_MAP.getDouble((Object)stack.getFluid().getName()) * (double)stack.amount * multiplier / 1000.0;
    }

    public static void transferRadiationFromProviderToChunkBuffer(ICapabilityProvider provider, EnumFacing side, IRadiationSource chunkSource) {
        IRadiationSource radiationSource;
        if (chunkSource == null) {
            return;
        }
        double rawRadiation = 0.0;
        if (ModCheck.ic2Loaded() && provider instanceof IReactor) {
            rawRadiation += ((IReactor)provider).getReactorEUEnergyOutput() * 1.0E-5;
        }
        if (NCConfig.radiation_hardcore_containers > 0.0) {
            IFluidTankProperties[] props;
            IFluidHandler tanks;
            IItemHandler inventory = RadiationHelper.getTileInventory(provider, side);
            if (inventory != null) {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    rawRadiation += RadiationHelper.getRadiationFromStack(stack, NCConfig.radiation_hardcore_containers);
                }
            }
            if ((tanks = RadiationHelper.getTileTanks(provider, side)) != null && (props = tanks.getTankProperties()) != null) {
                for (IFluidTankProperties prop : props) {
                    FluidStack stack = prop.getContents();
                    rawRadiation += RadiationHelper.getRadiationFromFluid(stack, NCConfig.radiation_hardcore_containers);
                }
            }
        }
        if ((radiationSource = RadiationHelper.getRadiationSource(provider)) != null) {
            rawRadiation += radiationSource.getRadiationLevel();
        }
        double resistance = 0.0;
        IRadiationResistance providerResistance = RadiationHelper.getRadiationResistance(provider);
        if (providerResistance != null) {
            resistance = providerResistance.getTotalRadResistance();
        }
        double radiation = rawRadiation <= 0.0 ? 0.0 : NCMath.sq(rawRadiation) / (rawRadiation + resistance);
        RadiationHelper.addToSourceBuffer(chunkSource, radiation);
    }

    public static void transferRadsFromInventoryToChunkBuffer(InventoryPlayer inventory, IRadiationSource chunkSource) {
        if (!NCConfig.radiation_hardcore_stacks) {
            return;
        }
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack.func_190926_b()) continue;
            RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)stack, null, chunkSource);
        }
        for (ItemStack stack : inventory.field_70460_b) {
            if (stack.func_190926_b()) continue;
            RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)stack, null, chunkSource);
        }
        for (ItemStack stack : inventory.field_184439_c) {
            if (stack.func_190926_b()) continue;
            RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)stack, null, chunkSource);
        }
    }

    public static void spreadRadiationFromChunk(Chunk chunk, Chunk targetChunk) {
        if (chunk != null && chunk.func_177410_o()) {
            IRadiationSource targetChunkSource;
            IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk);
            if (chunkSource == null) {
                return;
            }
            if (targetChunk != null && targetChunk.func_177410_o() && (targetChunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)targetChunk)) != null && !chunkSource.isRadiationNegligible() && (targetChunkSource.getRadiationLevel() == 0.0 || chunkSource.getRadiationLevel() / targetChunkSource.getRadiationLevel() > 1.0 + NCConfig.radiation_spread_gradient)) {
                double radiationSpread = (chunkSource.getRadiationLevel() - targetChunkSource.getRadiationLevel()) * NCConfig.radiation_spread_rate;
                chunkSource.setRadiationLevel(chunkSource.getRadiationLevel() - radiationSpread);
                targetChunkSource.setRadiationLevel(targetChunkSource.getRadiationLevel() + radiationSpread * (1.0 - targetChunkSource.getScrubbingFraction()));
            }
            chunkSource.setRadiationBuffer(0.0);
            if (chunkSource.isRadiationNegligible()) {
                chunkSource.setRadiationLevel(0.0);
            }
        }
    }

    public static double getArmorInventoryRadResistance(Entity entity) {
        IBaublesItemHandler baublesHandler;
        if (entity == null) {
            return 0.0;
        }
        double resistance = 0.0;
        for (ItemStack armor : entity.func_184193_aE()) {
            resistance += RadiationHelper.getArmorRadResistance(armor);
        }
        if (ModCheck.baublesLoaded() && entity.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null) && (baublesHandler = (IBaublesItemHandler)entity.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) != null) {
            for (int i = 0; i < baublesHandler.getSlots(); ++i) {
                resistance += RadiationHelper.getArmorRadResistance(baublesHandler.getStackInSlot(i));
            }
        }
        return resistance;
    }

    private static double getArmorRadResistance(ItemStack armor) {
        if (armor.func_190926_b()) {
            return 0.0;
        }
        double resistance = 0.0;
        IRadiationResistance armorResistance = RadiationHelper.getRadiationResistance((ICapabilityProvider)armor);
        if (armorResistance != null) {
            resistance += armorResistance.getTotalRadResistance();
        }
        if (armor.func_77942_o() && armor.func_77978_p().func_74764_b("ncRadiationResistance")) {
            resistance += armor.func_77978_p().func_74769_h("ncRadiationResistance");
        }
        return resistance;
    }

    public static double addRadsToEntity(IEntityRads entityRads, EntityLivingBase entity, double rawRadiation, boolean ignoreResistance, boolean ignoreMultipliers, int updateRate) {
        if (rawRadiation <= 0.0) {
            return 0.0;
        }
        if (!ignoreMultipliers) {
            if (entity.func_70090_H()) {
                rawRadiation *= NCConfig.radiation_swim_mult;
            } else if (NCConfig.radiation_rain_mult != 1.0 && entity.func_70026_G()) {
                rawRadiation *= NCConfig.radiation_rain_mult;
            }
        }
        double resistance = ignoreResistance ? Math.min(0.0, entityRads.getInternalRadiationResistance()) : entityRads.getFullRadiationResistance();
        double addedRadiation = resistance > 0.0 ? NCMath.sq(rawRadiation) / (rawRadiation + resistance) : rawRadiation * (1.0 - resistance);
        entityRads.setTotalRads(entityRads.getTotalRads() + addedRadiation * (double)updateRate, true);
        return addedRadiation;
    }

    public static double getEntityArmorRadResistance(EntityLivingBase entity) {
        double resistance = RadiationHelper.getArmorInventoryRadResistance((Entity)entity);
        if (NCConfig.radiation_horse_armor_public && entity instanceof EntityHorse) {
            resistance += RadiationHelper.getHorseArmorRadResistance((EntityHorse)entity);
        }
        return resistance;
    }

    private static double getHorseArmorRadResistance(EntityHorse horse) {
        double resistance = 0.0;
        NBTTagCompound compound = new NBTTagCompound();
        horse.func_70014_b(compound);
        ItemStack armor = new ItemStack(compound.func_74775_l("ArmorItem"));
        if (ArmorHelper.isHorseArmor(armor.func_77973_b())) {
            resistance += RadiationHelper.getArmorRadResistance(armor);
        }
        return resistance;
    }

    public static double transferRadsFromInventoryToPlayer(IEntityRads playerRads, EntityPlayer player, int updateRate) {
        double radiationLevel = 0.0;
        InventoryPlayer inventory = player.field_71071_by;
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack.func_190926_b()) continue;
            radiationLevel += RadiationHelper.transferRadsFromStackToPlayer(stack, playerRads, player, updateRate);
        }
        for (ItemStack stack : inventory.field_70460_b) {
            if (stack.func_190926_b()) continue;
            radiationLevel += RadiationHelper.transferRadsFromStackToPlayer(stack, playerRads, player, updateRate);
        }
        for (ItemStack stack : inventory.field_184439_c) {
            if (stack.func_190926_b()) continue;
            radiationLevel += RadiationHelper.transferRadsFromStackToPlayer(stack, playerRads, player, updateRate);
        }
        return radiationLevel;
    }

    private static double transferRadsFromStackToPlayer(ItemStack stack, IEntityRads playerRads, EntityPlayer player, int updateRate) {
        IRadiationSource stackSource = RadiationHelper.getRadiationSource((ICapabilityProvider)stack);
        if (stackSource == null) {
            return 0.0;
        }
        return RadiationHelper.addRadsToEntity(playerRads, (EntityLivingBase)player, stackSource.getRadiationLevel() * (double)stack.func_190916_E(), false, false, updateRate);
    }

    public static double transferRadsToPlayer(IRadiationSource source, IEntityRads playerRads, EntityPlayer player, int updateRate) {
        if (source == null) {
            return 0.0;
        }
        return RadiationHelper.addRadsToEntity(playerRads, (EntityLivingBase)player, source.getRadiationLevel(), false, false, updateRate);
    }

    public static void transferRadsFromSourceToEntity(IRadiationSource source, IEntityRads entityRads, EntityLivingBase entity, int updateRate) {
        if (source == null) {
            return;
        }
        entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity(entityRads, entity, source.getRadiationLevel(), false, false, updateRate));
    }

    public static void applyPotionEffects(EntityLivingBase entity, IEntityRads entityRads, int durationMult, List<Double> radLevelList, List<List<PotionEffect>> potionList) {
        if (radLevelList.isEmpty() || radLevelList.size() != potionList.size()) {
            return;
        }
        double radPercentage = entityRads.getRadsPercentage();
        for (int i = 0; i < radLevelList.size(); ++i) {
            int j = radLevelList.size() - 1 - i;
            if (!(radPercentage >= radLevelList.get(j))) continue;
            for (PotionEffect potionEffect : potionList.get(j)) {
                entity.func_70690_d(new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b() * durationMult, potionEffect.func_76458_c(), potionEffect.func_82720_e(), potionEffect.func_188418_e()));
            }
            break;
        }
    }

    public static boolean shouldShowHUD(EntityPlayer player) {
        if (!player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            return false;
        }
        if (!NCConfig.radiation_require_counter) {
            return true;
        }
        ItemStack geiger_counter = new ItemStack(NCItems.geiger_counter);
        ItemStack geiger_block = new ItemStack(NCItems.geiger_counter);
        if (ModCheck.baublesLoaded() && player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) {
            IBaublesItemHandler baublesHandler = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
            if (baublesHandler == null) {
                return false;
            }
            for (int slot : BaubleType.TRINKET.getValidSlots()) {
                if (!baublesHandler.getStackInSlot(slot).func_77969_a(geiger_counter)) continue;
                return true;
            }
        }
        return player.field_71071_by.func_70431_c(geiger_counter) || player.field_71071_by.func_70431_c(geiger_block);
    }

    public static TextFormatting getRadsTextColor(IEntityRads entityRads) {
        double radsPercent = entityRads.getRadsPercentage();
        return radsPercent < 30.0 ? TextFormatting.WHITE : (radsPercent < 50.0 ? TextFormatting.YELLOW : (radsPercent < 70.0 ? TextFormatting.GOLD : (radsPercent < 90.0 ? TextFormatting.RED : TextFormatting.DARK_RED)));
    }

    public static TextFormatting getRadiationTextColor(double radiation) {
        return radiation < 1.0E-9 ? TextFormatting.WHITE : (radiation < 0.001 ? TextFormatting.YELLOW : (radiation < 0.1 ? TextFormatting.GOLD : (radiation < 1.0 ? TextFormatting.RED : TextFormatting.DARK_RED)));
    }

    public static TextFormatting getRadiationTextColor(IRadiation irradiated) {
        return RadiationHelper.getRadiationTextColor(irradiated.getRadiationLevel());
    }

    public static TextFormatting getRawRadiationTextColor(IEntityRads entityRads) {
        return RadiationHelper.getRadiationTextColor(entityRads.getRawRadiationLevel());
    }

    public static TextFormatting getFoodRadiationTextColor(double radiation) {
        return radiation <= -100.0 ? TextFormatting.LIGHT_PURPLE : (radiation <= -10.0 ? TextFormatting.BLUE : (radiation < 0.0 ? TextFormatting.AQUA : (radiation < 0.1 ? TextFormatting.WHITE : (radiation < 1.0 ? TextFormatting.YELLOW : (radiation < 10.0 ? TextFormatting.GOLD : (radiation < 100.0 ? TextFormatting.RED : TextFormatting.DARK_RED))))));
    }

    public static TextFormatting getFoodResistanceTextColor(double resistance) {
        return resistance < 0.0 ? TextFormatting.GRAY : TextFormatting.WHITE;
    }

    public static String radsPrefix(double rads, boolean rate) {
        String unit = rate ? "Rad/t" : "Rad";
        return NCConfig.radiation_unit_prefixes > 0 ? NCMath.sigFigs(rads, NCConfig.radiation_unit_prefixes) + " " + unit : UnitHelper.prefix(rads, 3, unit);
    }

    public static String radsColoredPrefix(double rads, boolean rate) {
        return RadiationHelper.getRadiationTextColor(rads) + RadiationHelper.radsPrefix(rads, rate);
    }

    public static String resistanceSigFigs(double resistance) {
        return NCMath.sigFigs(resistance, Math.max(2, NCConfig.radiation_unit_prefixes));
    }
}

