/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import crafttweaker.annotations.ZenRegister;
import java.util.List;
import nc.multiblock.fission.FissionPlacement;
import nc.recipe.IRecipe;
import nc.recipe.IngredientSorption;
import nc.recipe.RecipeHelper;
import nc.recipe.RecipeMatchResult;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.FontRenderHelper;
import nc.util.InfoHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import stanhebben.zenscript.annotations.ZenClass;

@ZenClass(value="mods.nuclearcraft.ProcessorRecipe")
@ZenRegister
public class BasicRecipe
implements IRecipe {
    protected List<IItemIngredient> itemIngredients;
    protected List<IItemIngredient> itemProducts;
    protected List<IFluidIngredient> fluidIngredients;
    protected List<IFluidIngredient> fluidProducts;
    protected List extras;
    protected boolean isShapeless;

    public BasicRecipe(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts, List extras, boolean shapeless) {
        this.itemIngredients = itemIngredients;
        this.fluidIngredients = fluidIngredients;
        this.itemProducts = itemProducts;
        this.fluidProducts = fluidProducts;
        this.extras = extras;
        this.isShapeless = shapeless;
    }

    @Override
    public List<IItemIngredient> getItemIngredients() {
        return this.itemIngredients;
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    @Override
    public List<IItemIngredient> getItemProducts() {
        return this.itemProducts;
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.fluidProducts;
    }

    @Override
    public List getExtras() {
        return this.extras;
    }

    public boolean isShapeless() {
        return this.isShapeless;
    }

    @Override
    public RecipeMatchResult matchInputs(List<ItemStack> itemInputs, List<Tank> fluidInputs) {
        return RecipeHelper.matchIngredients(IngredientSorption.INPUT, this.itemIngredients, this.fluidIngredients, itemInputs, fluidInputs, this.isShapeless);
    }

    @Override
    public RecipeMatchResult matchOutputs(List<ItemStack> itemOutputs, List<Tank> fluidOutputs) {
        return RecipeHelper.matchIngredients(IngredientSorption.OUTPUT, this.itemProducts, this.fluidProducts, itemOutputs, fluidOutputs, this.isShapeless);
    }

    @Override
    public RecipeMatchResult matchIngredients(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients) {
        return RecipeHelper.matchIngredients(IngredientSorption.INPUT, this.itemIngredients, this.fluidIngredients, itemIngredients, fluidIngredients, this.isShapeless);
    }

    @Override
    public RecipeMatchResult matchProducts(List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts) {
        return RecipeHelper.matchIngredients(IngredientSorption.OUTPUT, this.itemProducts, this.fluidProducts, itemProducts, fluidProducts, this.isShapeless);
    }

    public double getBaseProcessTime(double defaultProcessTime) {
        return (Double)this.extras.get(0) * defaultProcessTime;
    }

    public double getBaseProcessPower(double defaultProcessPower) {
        return (Double)this.extras.get(1) * defaultProcessPower;
    }

    public double getBaseProcessRadiation() {
        return (Double)this.extras.get(2);
    }

    public String getCollectorProductionRate() {
        return (String)this.extras.get(0);
    }

    public double getDecayGeneratorLifetime() {
        return (Double)this.extras.get(0);
    }

    public double getDecayGeneratorPower() {
        return (Double)this.extras.get(1);
    }

    public double getDecayGeneratorRadiation() {
        return (Double)this.extras.get(2);
    }

    public String getPlacementRuleID() {
        return (String)this.extras.get(0);
    }

    public int getFissionModeratorFluxFactor() {
        return (Integer)this.extras.get(0);
    }

    public double getFissionModeratorEfficiency() {
        return (Double)this.extras.get(1);
    }

    public double getFissionReflectorEfficiency() {
        return (Double)this.extras.get(0);
    }

    public double getFissionReflectorReflectivity() {
        return (Double)this.extras.get(1);
    }

    public int getIrradiatorFluxRequired() {
        return (Integer)this.extras.get(0);
    }

    public double getIrradiatorHeatPerFlux() {
        return (Double)this.extras.get(1);
    }

    public double getIrradiatorProcessEfficiency() {
        return (Double)this.extras.get(2);
    }

    public double getIrradiatorBaseProcessRadiation() {
        return (Double)this.extras.get(3);
    }

    public int getFissionFuelTime() {
        return (Integer)this.extras.get(0);
    }

    public double getSaltFissionFuelTime() {
        return (Double)this.extras.get(0);
    }

    public int getFissionFuelHeat() {
        return (Integer)this.extras.get(1);
    }

    public double getFissionFuelEfficiency() {
        return (Double)this.extras.get(2);
    }

    public int getFissionFuelCriticality() {
        return (Integer)this.extras.get(3);
    }

    public double getFissionFuelDecayFactor() {
        return (Double)this.extras.get(4);
    }

    public boolean getFissionFuelSelfPriming() {
        return (Boolean)this.extras.get(5);
    }

    public double getFissionFuelRadiation() {
        return (Double)this.extras.get(6);
    }

    public int getFissionHeatingHeatPerInputMB() {
        return (Integer)this.extras.get(0);
    }

    public double getEmergencyCoolingHeatPerInputMB() {
        return (Double)this.extras.get(0);
    }

    public double getFusionComboTime() {
        return (Double)this.extras.get(0);
    }

    public double getFusionComboPower() {
        return (Double)this.extras.get(1);
    }

    public double getFusionComboHeatVariable() {
        return (Double)this.extras.get(2);
    }

    public double getFusionComboRadiation() {
        return (Double)this.extras.get(3);
    }

    public int getCoolantHeaterCoolingRate() {
        return (Integer)this.extras.get(0);
    }

    public String getCoolantHeaterPlacementRule() {
        return (String)this.extras.get(1);
    }

    public String[] getCoolantHeaterJEIInfo() {
        String rule = (String)FissionPlacement.TOOLTIP_MAP.get((Object)this.getCoolantHeaterPlacementRule());
        if (rule != null) {
            return FontRenderHelper.wrapString(rule, 225);
        }
        return InfoHelper.EMPTY_ARRAY;
    }

    public double getHeatExchangerProcessTime() {
        return (Double)this.extras.get(0);
    }

    public int getHeatExchangerInputTemperature() {
        return (Integer)this.extras.get(1);
    }

    public int getHeatExchangerOutputTemperature() {
        return (Integer)this.extras.get(2);
    }

    public boolean getHeatExchangerIsHeating() {
        return this.getHeatExchangerInputTemperature() - this.getHeatExchangerOutputTemperature() < 0;
    }

    public double getTurbinePowerPerMB() {
        return (Double)this.extras.get(0);
    }

    public double getTurbineExpansionLevel() {
        return (Double)this.extras.get(1);
    }

    public double getTurbineSpinUpMultiplier() {
        return (Double)this.extras.get(2);
    }

    public String getTurbineParticleEffect() {
        EnumParticleTypes particle = EnumParticleTypes.func_186831_a((String)((String)this.extras.get(3)));
        return particle == null ? "cloud" : (String)this.extras.get(3);
    }

    public double getTurbineParticleSpeedMultiplier() {
        return (Double)this.extras.get(4);
    }

    public double getCondenserProcessTime() {
        return (Double)this.extras.get(0);
    }

    public int getCondenserCondensingTemperature() {
        return (Integer)this.extras.get(1);
    }

    public int getScrubberProcessTime() {
        return (Integer)this.extras.get(0);
    }

    public int getScrubberProcessPower() {
        return (Integer)this.extras.get(1);
    }

    public double getScrubberProcessEfficiency() {
        return (Double)this.extras.get(2);
    }

    public double getBlockMutationThreshold() {
        return (Double)this.extras.get(0);
    }
}

