/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import crafttweaker.annotations.ZenRegister;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.integration.gtce.GTCERecipeHelper;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.RecipeHelper;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.util.NCMath;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.nuclearcraft.BasicRecipeHandler")
@ZenRegister
public abstract class BasicRecipeHandler
extends AbstractRecipeHandler<BasicRecipe> {
    protected final String name;
    protected final int itemInputSize;
    protected final int fluidInputSize;
    protected final int itemOutputSize;
    protected final int fluidOutputSize;
    protected final boolean isShapeless;
    private static final Object2BooleanMap<String> GTCE_INTEGRATION = new Object2BooleanOpenHashMap();

    public BasicRecipeHandler(@Nonnull String name, int itemInputSize, int fluidInputSize, int itemOutputSize, int fluidOutputSize) {
        this(name, itemInputSize, fluidInputSize, itemOutputSize, fluidOutputSize, true);
    }

    public BasicRecipeHandler(@Nonnull String name, int itemInputSize, int fluidInputSize, int itemOutputSize, int fluidOutputSize, boolean isShapeless) {
        this.name = name;
        this.itemInputSize = itemInputSize;
        this.fluidInputSize = fluidInputSize;
        this.itemOutputSize = itemOutputSize;
        this.fluidOutputSize = fluidOutputSize;
        this.isShapeless = isShapeless;
        this.addRecipes();
    }

    @Override
    public void addRecipe(Object ... objects) {
        ArrayList<Object> itemInputs = new ArrayList<Object>();
        ArrayList<Object> fluidInputs = new ArrayList<Object>();
        ArrayList<Object> itemOutputs = new ArrayList<Object>();
        ArrayList<Object> fluidOutputs = new ArrayList<Object>();
        ArrayList<Object> extras = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (i < this.itemInputSize) {
                itemInputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize) {
                fluidInputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.itemOutputSize) {
                itemOutputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.itemOutputSize + this.fluidOutputSize) {
                fluidOutputs.add(object);
                continue;
            }
            extras.add(object);
        }
        BasicRecipe recipe = this.buildRecipe(itemInputs, fluidInputs, itemOutputs, fluidOutputs, extras, this.isShapeless);
        this.addRecipe(NCConfig.factor_recipes ? this.factorRecipe(recipe) : recipe);
    }

    public BasicRecipe newRecipe(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts, List extras, boolean shapeless) {
        return new BasicRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts, extras, shapeless);
    }

    public void addGTCERecipes() {
        if (ModCheck.gregtechLoaded() && GTCE_INTEGRATION.getBoolean((Object)this.name)) {
            for (BasicRecipe recipe : this.recipeList) {
                GTCERecipeHelper.addGTCERecipe(this.name, recipe);
            }
        }
    }

    public abstract List fixExtras(List var1);

    public BasicRecipe factorRecipe(BasicRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        if (recipe.getItemIngredients().size() != 0 || recipe.getItemProducts().size() != 0) {
            return recipe;
        }
        IntArrayList stackSizes = new IntArrayList();
        for (IFluidIngredient ingredient : recipe.getFluidIngredients()) {
            stackSizes.addAll(ingredient.getFactors());
        }
        for (IFluidIngredient ingredient : recipe.getFluidProducts()) {
            stackSizes.addAll(ingredient.getFactors());
        }
        stackSizes.addAll(this.getExtraFactors(recipe.getExtras()));
        int hcf = NCMath.hcf(stackSizes.toIntArray());
        if (hcf == 1) {
            return recipe;
        }
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        ArrayList<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
        for (IFluidIngredient ingredient : recipe.getFluidIngredients()) {
            fluidIngredients.add(ingredient.getFactoredIngredient(hcf));
        }
        for (IFluidIngredient ingredient : recipe.getFluidProducts()) {
            fluidProducts.add(ingredient.getFactoredIngredient(hcf));
        }
        return this.newRecipe(recipe.getItemIngredients(), fluidIngredients, recipe.getItemProducts(), fluidProducts, this.getFactoredExtras(recipe.getExtras(), hcf), recipe.isShapeless());
    }

    public IntList getExtraFactors(List extras) {
        return new IntArrayList();
    }

    public List getFactoredExtras(List extras, int factor) {
        return extras;
    }

    public static void initGTCEIntegration() {
        boolean[] arr = NCConfig.gtce_recipe_integration;
        GTCE_INTEGRATION.put((Object)"manufactory", arr[0]);
        GTCE_INTEGRATION.put((Object)"separator", arr[1]);
        GTCE_INTEGRATION.put((Object)"decay_hastener", arr[2]);
        GTCE_INTEGRATION.put((Object)"fuel_reprocessor", arr[3]);
        GTCE_INTEGRATION.put((Object)"alloy_furnace", arr[4]);
        GTCE_INTEGRATION.put((Object)"infuser", arr[5]);
        GTCE_INTEGRATION.put((Object)"melter", arr[6]);
        GTCE_INTEGRATION.put((Object)"supercooler", arr[7]);
        GTCE_INTEGRATION.put((Object)"electrolyzer", arr[8]);
        GTCE_INTEGRATION.put((Object)"assembler", arr[9]);
        GTCE_INTEGRATION.put((Object)"ingot_former", arr[10]);
        GTCE_INTEGRATION.put((Object)"pressurizer", arr[11]);
        GTCE_INTEGRATION.put((Object)"chemical_reactor", arr[12]);
        GTCE_INTEGRATION.put((Object)"salt_mixer", arr[13]);
        GTCE_INTEGRATION.put((Object)"crystallizer", arr[14]);
        GTCE_INTEGRATION.put((Object)"enricher", arr[15]);
        GTCE_INTEGRATION.put((Object)"extractor", arr[16]);
        GTCE_INTEGRATION.put((Object)"centrifuge", arr[17]);
        GTCE_INTEGRATION.put((Object)"rock_crusher", arr[18]);
    }

    @Nullable
    public BasicRecipe buildRecipe(List itemInputs, List fluidInputs, List itemOutputs, List fluidOutputs, List extras, boolean shapeless) {
        IIngredient<ItemStack> output;
        IIngredient<ItemStack> input;
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IItemIngredient> itemProducts = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        ArrayList<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
        for (Object obj : itemInputs) {
            if (obj != null && BasicRecipeHandler.isValidItemInputType(obj)) {
                input = RecipeHelper.buildItemIngredient(obj);
                if (input == null) {
                    return null;
                }
                itemIngredients.add((IItemIngredient)input);
                continue;
            }
            return null;
        }
        for (Object obj : fluidInputs) {
            if (obj != null && BasicRecipeHandler.isValidFluidInputType(obj)) {
                input = RecipeHelper.buildFluidIngredient(obj);
                if (input == null) {
                    return null;
                }
                fluidIngredients.add((IFluidIngredient)input);
                continue;
            }
            return null;
        }
        for (Object obj : itemOutputs) {
            if (obj != null && BasicRecipeHandler.isValidItemOutputType(obj)) {
                output = RecipeHelper.buildItemIngredient(obj);
                if (output == null) {
                    return null;
                }
                itemProducts.add((IItemIngredient)output);
                continue;
            }
            return null;
        }
        for (Object obj : fluidOutputs) {
            if (obj != null && BasicRecipeHandler.isValidFluidOutputType(obj)) {
                output = RecipeHelper.buildFluidIngredient(obj);
                if (output == null) {
                    return null;
                }
                fluidProducts.add((IFluidIngredient)output);
                continue;
            }
            return null;
        }
        if (!this.isValidRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts)) {
            NCUtil.getLogger().info(this.name + " - a recipe failed to be registered: " + RecipeHelper.getRecipeString(itemIngredients, fluidIngredients, itemProducts, fluidProducts));
        }
        return this.newRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts, this.fixExtras(extras), shapeless);
    }

    public boolean isValidRecipe(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts) {
        return itemIngredients.size() == this.itemInputSize && fluidIngredients.size() == this.fluidInputSize && itemProducts.size() == this.itemOutputSize && fluidProducts.size() == this.fluidOutputSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @ZenMethod
    public List<BasicRecipe> getRecipeList() {
        return this.recipeList;
    }

    @ZenMethod
    public int getItemInputSize() {
        return this.itemInputSize;
    }

    @ZenMethod
    public int getFluidInputSize() {
        return this.fluidInputSize;
    }

    @ZenMethod
    public int getItemOutputSize() {
        return this.itemOutputSize;
    }

    @ZenMethod
    public int getFluidOutputSize() {
        return this.fluidOutputSize;
    }

    @ZenMethod
    public boolean isShapeless() {
        return this.isShapeless;
    }
}

