/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientOr;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

public class ItemArrayIngredient
implements IItemIngredient {
    public List<IItemIngredient> ingredientList;
    public List<ItemStack> cachedStackList = new ArrayList<ItemStack>();

    public ItemArrayIngredient(IItemIngredient ... ingredients) {
        this(Lists.newArrayList((Object[])ingredients));
    }

    public ItemArrayIngredient(List<IItemIngredient> ingredientList) {
        this.ingredientList = ingredientList;
        ingredientList.forEach(input -> this.cachedStackList.add((ItemStack)input.getStack()));
    }

    @Override
    public ItemStack getStack() {
        return this.isValid() ? this.cachedStackList.get(0).func_77946_l() : null;
    }

    @Override
    public List<ItemStack> getInputStackList() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.ingredientList.forEach(ingredient -> ingredient.getInputStackList().forEach(obj -> stacks.add((ItemStack)obj)));
        return stacks;
    }

    @Override
    public List<ItemStack> getOutputStackList() {
        return this.isValid() ? Lists.newArrayList((Object[])new ItemStack[]{this.getStack()}) : new ArrayList();
    }

    @Override
    public int getMaxStackSize(int ingredientNumber) {
        return this.ingredientList.get(ingredientNumber).getMaxStackSize(0);
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        for (IItemIngredient ingredient : this.ingredientList) {
            ingredient.setMaxStackSize(stackSize);
        }
        for (ItemStack stack : this.cachedStackList) {
            stack.func_190920_e(stackSize);
        }
    }

    @Override
    public String getIngredientName() {
        return this.getIngredientNamesConcat();
    }

    @Override
    public String getIngredientNamesConcat() {
        String names = "";
        for (IItemIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    public String getIngredientRecipeString() {
        String names = "";
        for (IItemIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    @Override
    public IntList getFactors() {
        IntArrayList list = new IntArrayList();
        for (IItemIngredient ingredient : this.ingredientList) {
            list.addAll(ingredient.getFactors());
        }
        return new IntArrayList((IntList)list);
    }

    @Override
    public IItemIngredient getFactoredIngredient(int factor) {
        ArrayList<IItemIngredient> list = new ArrayList<IItemIngredient>();
        for (IItemIngredient ingredient : this.ingredientList) {
            list.add(ingredient.getFactoredIngredient(factor));
        }
        return new ItemArrayIngredient(list);
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption sorption) {
        if (object instanceof ItemArrayIngredient) {
            block0: for (IItemIngredient ingredient : this.ingredientList) {
                for (IItemIngredient ingr : ((ItemArrayIngredient)object).ingredientList) {
                    if (!ingredient.match(ingr, sorption).matches()) continue;
                    continue block0;
                }
                return IngredientMatchResult.FAIL;
            }
            return IngredientMatchResult.PASS_0;
        }
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            if (!this.ingredientList.get(i).match(object, sorption).matches()) continue;
            return new IngredientMatchResult(true, i);
        }
        return IngredientMatchResult.FAIL;
    }

    @Override
    public boolean isValid() {
        return this.cachedStackList != null && !this.cachedStackList.isEmpty() && this.cachedStackList.get(0) != null;
    }

    @Override
    @Optional.Method(modid="crafttweaker")
    public IIngredient ct() {
        IIngredient[] array = new IIngredient[this.ingredientList.size()];
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            array[i] = this.ingredientList.get(i).ct();
        }
        return new IngredientOr(array);
    }
}

