/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.util.StackHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

public class ItemIngredient
implements IItemIngredient {
    public ItemStack stack;

    public ItemIngredient(@Nonnull ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ItemStack getStack() {
        return this.stack == null ? null : this.stack.func_77946_l();
    }

    @Override
    public List<ItemStack> getInputStackList() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.stack});
    }

    @Override
    public List<ItemStack> getOutputStackList() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.stack});
    }

    @Override
    public int getMaxStackSize(int ingredientNumber) {
        return this.stack.func_190916_E();
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        this.stack.func_190920_e(stackSize);
    }

    @Override
    public String getIngredientName() {
        return StackHelper.stackName(this.stack);
    }

    @Override
    public String getIngredientNamesConcat() {
        return StackHelper.stackName(this.stack);
    }

    @Override
    public IntList getFactors() {
        return new IntArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{this.stack.func_190916_E()}));
    }

    @Override
    public IItemIngredient getFactoredIngredient(int factor) {
        ItemStack newStack = this.stack.func_77946_l();
        newStack.func_190920_e(this.stack.func_190916_E() / factor);
        return new ItemIngredient(newStack);
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption type) {
        if (object instanceof ItemStack) {
            ItemStack itemstack = (ItemStack)object;
            if (!itemstack.func_77969_a(this.stack) || !StackHelper.areItemStackTagsEqual(itemstack, this.stack)) {
                return IngredientMatchResult.FAIL;
            }
            return new IngredientMatchResult(type.checkStackSize(this.stack.func_190916_E(), itemstack.func_190916_E()), 0);
        }
        if (object instanceof OreIngredient) {
            OreIngredient oreStack = (OreIngredient)object;
            for (ItemStack itemStack : oreStack.cachedStackList) {
                if (!this.match(itemStack, type).matches()) continue;
                return new IngredientMatchResult(type.checkStackSize(this.stack.func_190916_E(), oreStack.stackSize), 0);
            }
        } else if (object instanceof ItemIngredient && this.match(((ItemIngredient)object).stack, type).matches()) {
            return new IngredientMatchResult(type.checkStackSize(this.getMaxStackSize(0), ((ItemIngredient)object).getMaxStackSize(0)), 0);
        }
        return IngredientMatchResult.FAIL;
    }

    @Override
    public boolean isValid() {
        return this.stack != null;
    }

    @Override
    @Optional.Method(modid="crafttweaker")
    public IIngredient ct() {
        return CraftTweakerMC.getIItemStack((ItemStack)this.stack);
    }
}

