/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.multiblock;

import java.util.ArrayList;
import java.util.List;
import nc.config.NCConfig;
import nc.init.NCCoolantFluids;
import nc.recipe.BasicRecipeHandler;

public class HeatExchangerRecipes
extends BasicRecipeHandler {
    public HeatExchangerRecipes() {
        super("heat_exchanger", 0, 1, 0, 1);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(HeatExchangerRecipes.fluidStack("nak_hot", 1), HeatExchangerRecipes.fluidStack("nak", 1), (double)NCConfig.fission_heater_cooling_rate[0] * NCConfig.heat_exchanger_coolant_mult, 700, 300);
        for (int i = 1; i < NCCoolantFluids.COOLANTS.size(); ++i) {
            this.addRecipe(HeatExchangerRecipes.fluidStack(NCCoolantFluids.COOLANTS.get(i) + "_nak_hot", 1), HeatExchangerRecipes.fluidStack(NCCoolantFluids.COOLANTS.get(i) + "_nak", 1), (double)NCConfig.fission_heater_cooling_rate[i] * NCConfig.heat_exchanger_coolant_mult, 700, 300);
        }
        this.addRecipe(HeatExchangerRecipes.fluidStack("water", 1), HeatExchangerRecipes.fluidStack("high_pressure_steam", 4), 128.0, 300, 1200);
        this.addRecipe(HeatExchangerRecipes.fluidStack("preheated_water", 1), HeatExchangerRecipes.fluidStack("high_pressure_steam", 4), 64.0, 400, 1200);
        if (!NCConfig.heat_exchanger_alternate_exhaust_recipe) {
            this.addRecipe(HeatExchangerRecipes.fluidStack("exhaust_steam", 1), HeatExchangerRecipes.fluidStack("low_pressure_steam", 1), 4.0, 500, 800);
        } else {
            this.addRecipe(HeatExchangerRecipes.fluidStack("exhaust_steam", 1), HeatExchangerRecipes.fluidStack("steam", 1), 4.0, 500, 800);
        }
        this.addRecipe(HeatExchangerRecipes.fluidStack("high_pressure_steam", 1), HeatExchangerRecipes.fluidStack("steam", 4), 16.0, 1200, 800);
        this.addRecipe(HeatExchangerRecipes.fluidStack("condensate_water", 1), HeatExchangerRecipes.fluidStack("preheated_water", 1), 32.0, 300, 400);
    }

    @Override
    public List fixExtras(List extras) {
        ArrayList<Number> fixed = new ArrayList<Number>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 16000.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Integer ? (Integer)extras.get(1) : 300);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Integer ? (Integer)extras.get(2) : 300);
        return fixed;
    }

    @Override
    public List getFactoredExtras(List extras, int factor) {
        ArrayList<Double> factored = new ArrayList<Double>(extras);
        factored.set(0, (Double)extras.get(0) / (double)factor);
        return factored;
    }
}

