/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nc.config.NCConfig;
import nc.radiation.RadSources;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.RecipeHelper;
import nc.util.NCMath;
import nc.util.OreDictHelper;

public class DecayHastenerRecipes
extends BasicRecipeHandler {
    private static final Set<String> NON_FISSION = Sets.newHashSet((Object[])new String[]{"Thorium", "Lead", "Bismuth", "Thallium", "Radium", "Polonium", "TBP", "Zirconium", "Palladium", "Barium", "Neodymium", "Gadolinium"});

    public DecayHastenerRecipes() {
        super("decay_hastener", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addDecayRecipes("Thorium", "Lead", 7.15E-11);
        this.addDecayRecipes("Bismuth", "Thallium", 4.975E-20);
        this.addDecayRecipes("Radium", "Lead", 6.25E-4);
        this.addDecayRecipes("Polonium", "Lead", 0.29333333333333333);
        this.addDecayRecipes("TBP", "TBU", RadSources.TBP);
        this.addDecayRecipes("Protactinium233", "Uranium233", 1.5044444444444443);
        this.addDecayRecipes("Strontium90", "Zirconium", 0.0345);
        this.addDecayRecipes("Ruthenium106", "Palladium", 0.98);
        this.addDecayRecipes("Caesium137", "Barium", 0.033);
        this.addDecayRecipes("Promethium147", "Neodymium", 0.38);
        this.addDecayRecipes("Europium155", "Gadolinium", 0.21);
        this.addDecayRecipes("Uranium233", "Bismuth", 6.3E-6);
        this.addDecayRecipes("Uranium235", "Lead", 1.45E-9);
        this.addDecayRecipes("Uranium238", "Radium", 2.25E-10);
        this.addDecayRecipes("Neptunium236", "Thorium", 6.5E-6);
        this.addDecayRecipes("Neptunium237", "Uranium233", 4.7E-7);
        this.addDecayRecipes("Plutonium238", "Lead", 0.0115);
        this.addDecayRecipes("Plutonium239", "Uranium235", 4.15E-5);
        this.addDecayRecipes("Plutonium241", "Neptunium237", 0.0715);
        this.addDecayRecipes("Plutonium242", "Uranium238", 2.7E-6);
        this.addDecayRecipes("Americium241", "Neptunium237", 0.00235);
        this.addDecayRecipes("Americium242", "Lead", 0.0071);
        this.addDecayRecipes("Americium243", "Plutonium239", 1.4E-4);
        this.addDecayRecipes("Curium243", "Plutonium239", 0.0345);
        this.addDecayRecipes("Curium245", "Plutonium241", 1.2E-4);
        this.addDecayRecipes("Curium246", "Plutonium242", 2.15E-4);
        this.addDecayRecipes("Curium247", "Americium243", 6.45E-8);
        this.addDecayRecipes("Berkelium247", "Americium243", 7.25E-4);
        this.addDecayRecipes("Berkelium248", "Thorium", 0.00325);
        this.addDecayRecipes("Californium249", "Curium245", 0.00285);
        this.addDecayRecipes("Californium250", "Curium246", 0.0765);
        this.addDecayRecipes("Californium251", "Curium247", 0.00115);
        this.addDecayRecipes("Californium252", "Thorium", 0.38);
    }

    public void addDecayRecipes(String input, String output, double radiation) {
        String inputName = (OreDictHelper.oreExists("ingot" + input) ? "ingot" : "dust") + input;
        double timeMult = NCMath.roundTo(RecipeHelper.getDecayTimeMultiplier(1.0E-6, radiation, 3.16E-7), 5.0 / (double)NCConfig.processor_time[2]);
        if (NON_FISSION.contains(output)) {
            this.addRecipe(Lists.newArrayList((Object[])new String[]{inputName, inputName + "Oxide", inputName + "Nitride"}), "dust" + output, timeMult, 1.0, radiation);
        } else {
            for (String type : new String[]{"", "Carbide", "Oxide", "Nitride", "ZA"}) {
                this.addRecipe(inputName + type, "ingot" + output + type, timeMult, 1.0, radiation);
            }
        }
    }

    @Override
    public List fixExtras(List extras) {
        ArrayList<Double> fixed = new ArrayList<Double>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 1.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }
}

