/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import java.util.ArrayList;
import java.util.List;
import nc.recipe.BasicRecipeHandler;
import nc.util.FissionHelper;

public class ElectrolyzerRecipes
extends BasicRecipeHandler {
    public ElectrolyzerRecipes() {
        super("electrolyzer", 0, 1, 0, 4);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(ElectrolyzerRecipes.fluidStack("water", 250), ElectrolyzerRecipes.fluidStack("hydrogen", 500), ElectrolyzerRecipes.fluidStack("oxygen", 250), ElectrolyzerRecipes.emptyFluidStack(), ElectrolyzerRecipes.emptyFluidStack(), 0.5, 1.0);
        this.addRecipe(ElectrolyzerRecipes.fluidStack("heavy_water", 250), ElectrolyzerRecipes.fluidStack("deuterium", 500), ElectrolyzerRecipes.fluidStack("oxygen", 250), ElectrolyzerRecipes.emptyFluidStack(), ElectrolyzerRecipes.emptyFluidStack(), 0.5, 1.0);
        this.addRecipe(ElectrolyzerRecipes.fluidStack("hydrofluoric_acid", 250), ElectrolyzerRecipes.fluidStack("hydrogen", 250), ElectrolyzerRecipes.fluidStack("fluorine", 250), ElectrolyzerRecipes.emptyFluidStack(), ElectrolyzerRecipes.emptyFluidStack(), 0.5, 1.0);
        this.addRecipe(ElectrolyzerRecipes.fluidStack("naoh", 333), ElectrolyzerRecipes.fluidStack("sodium", 72), ElectrolyzerRecipes.fluidStack("water", 500), ElectrolyzerRecipes.fluidStack("oxygen", 250), ElectrolyzerRecipes.emptyFluidStack(), 0.5, 1.0);
        this.addRecipe(ElectrolyzerRecipes.fluidStack("koh", 333), ElectrolyzerRecipes.fluidStack("potassium", 72), ElectrolyzerRecipes.fluidStack("water", 500), ElectrolyzerRecipes.fluidStack("oxygen", 250), ElectrolyzerRecipes.emptyFluidStack(), 0.5, 1.0);
        this.addRecipe(ElectrolyzerRecipes.fluidStack("alumina", 72), ElectrolyzerRecipes.fluidStack("aluminum", 144), ElectrolyzerRecipes.fluidStack("oxygen", 1500), ElectrolyzerRecipes.emptyFluidStack(), ElectrolyzerRecipes.emptyFluidStack(), 1.0, 1.0);
        this.addFissionFluorideRecipes();
    }

    public void addFissionFluorideRecipes() {
        for (String element : FissionHelper.FISSION_FLUID) {
            this.addRecipe(ElectrolyzerRecipes.fluidStack(element + "_fluoride", 72), ElectrolyzerRecipes.fluidStack(element, 72), ElectrolyzerRecipes.fluidStack("fluorine", 500), ElectrolyzerRecipes.emptyFluidStack(), ElectrolyzerRecipes.emptyFluidStack(), 0.5, 1.0);
            this.addRecipe(ElectrolyzerRecipes.fluidStack("depleted_" + element + "_fluoride", 72), ElectrolyzerRecipes.fluidStack("depleted_" + element, 72), ElectrolyzerRecipes.fluidStack("fluorine", 500), ElectrolyzerRecipes.emptyFluidStack(), ElectrolyzerRecipes.emptyFluidStack(), 0.5, 1.0);
        }
    }

    @Override
    public List fixExtras(List extras) {
        ArrayList<Double> fixed = new ArrayList<Double>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 1.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }

    @Override
    public List getFactoredExtras(List extras, int factor) {
        ArrayList<Double> factored = new ArrayList<Double>(extras);
        factored.set(0, (Double)extras.get(0) / (double)factor);
        return factored;
    }
}

