/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import java.util.ArrayList;
import java.util.List;
import nc.recipe.BasicRecipeHandler;
import nc.util.FissionHelper;

public class SaltMixerRecipes
extends BasicRecipeHandler {
    public SaltMixerRecipes() {
        super("salt_mixer", 0, 2, 0, 1);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(SaltMixerRecipes.fluidStack("lif", 144), SaltMixerRecipes.fluidStack("bef2", 72), SaltMixerRecipes.fluidStack("flibe", 72), 0.5, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("sodium", 72), SaltMixerRecipes.fluidStack("potassium", 288), SaltMixerRecipes.fluidStack("nak", 144), 1.0, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("boron_11", 144), SaltMixerRecipes.fluidStack("boron_10", 48), SaltMixerRecipes.fluidStack("boron", 192), 1.3333333333333333, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("lithium_7", 144), SaltMixerRecipes.fluidStack("lithium_6", 16), SaltMixerRecipes.fluidStack("lithium", 160), 1.1111111111111112, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("steel", 72), SaltMixerRecipes.fluidStack("boron", 72), SaltMixerRecipes.fluidStack("ferroboron", 144), 1.0, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("ferroboron", 72), SaltMixerRecipes.fluidStack("lithium", 72), SaltMixerRecipes.fluidStack("tough", 144), 1.0, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("coal", 100), SaltMixerRecipes.fluidStack("diamond", 333), SaltMixerRecipes.fluidStack("hardCarbon", 144), 1.0, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("lead_platinum", 144), SaltMixerRecipes.fluidStack("ender", 250), SaltMixerRecipes.fluidStack("enderium", 144), 1.0, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("radaway", 250), SaltMixerRecipes.fluidStack("redstone", 200), SaltMixerRecipes.fluidStack("radaway_slow", 250), 1.0, 0.5);
        this.addRecipe(SaltMixerRecipes.fluidStack("ethanol", 250), SaltMixerRecipes.fluidStack("redstone", 200), SaltMixerRecipes.fluidStack("redstone_ethanol", 250), 1.0, 0.5);
        this.addRecipe(SaltMixerRecipes.fluidStack("ice", 1000), SaltMixerRecipes.fluidStack("ethanol", 250), SaltMixerRecipes.fluidStack("slurry_ice", 1000), 1.0, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("slurry_ice", 1000), SaltMixerRecipes.fluidStack("cryotheum", 250), SaltMixerRecipes.fluidStack("emergency_coolant", 1000), 1.0, 1.0);
        this.addRecipe(SaltMixerRecipes.fluidStack("chocolate_liquor", 72), SaltMixerRecipes.fluidStack("cocoa_butter", 72), SaltMixerRecipes.fluidStack("unsweetened_chocolate", 144), 0.5, 0.5);
        this.addRecipe(SaltMixerRecipes.fluidStack("unsweetened_chocolate", 144), SaltMixerRecipes.fluidStack("sugar", 72), SaltMixerRecipes.fluidStack("dark_chocolate", 144), 0.5, 0.5);
        this.addRecipe(SaltMixerRecipes.fluidStack("dark_chocolate", 144), SaltMixerRecipes.fluidStack("milk", 250), SaltMixerRecipes.fluidStack("milk_chocolate", 288), 0.5, 0.5);
        this.addRecipe(SaltMixerRecipes.fluidStack("gelatin", 72), SaltMixerRecipes.fluidStack("water", 250), SaltMixerRecipes.fluidStack("hydrated_gelatin", 72), 0.5, 0.5);
        this.addRecipe(SaltMixerRecipes.fluidStack("hydrated_gelatin", 144), SaltMixerRecipes.fluidStack("sugar", 72), SaltMixerRecipes.fluidStack("marshmallow", 144), 1.0, 0.5);
        this.addCoolantNAKRecipe("iron", 144);
        this.addCoolantNAKRecipe("redstone", 200);
        this.addCoolantNAKRecipe("quartz", 1332);
        this.addCoolantNAKRecipe("obsidian", 360);
        this.addCoolantNAKRecipe("nether_brick", 360);
        this.addCoolantNAKRecipe("glowstone", 500);
        this.addCoolantNAKRecipe("lapis", 1332);
        this.addCoolantNAKRecipe("gold", 144);
        this.addCoolantNAKRecipe("prismarine", 144);
        this.addCoolantNAKRecipe("slime", 288);
        this.addCoolantNAKRecipe("end_stone", 360);
        this.addCoolantNAKRecipe("purpur", 360);
        this.addCoolantNAKRecipe("diamond", 666);
        this.addCoolantNAKRecipe("emerald", 666);
        this.addCoolantNAKRecipe("copper", 144);
        this.addCoolantNAKRecipe("tin", 144);
        this.addCoolantNAKRecipe("lead", 144);
        this.addCoolantNAKRecipe("boron", 144);
        this.addCoolantNAKRecipe("lithium", 144);
        this.addCoolantNAKRecipe("magnesium", 144);
        this.addCoolantNAKRecipe("manganese", 144);
        this.addCoolantNAKRecipe("aluminum", 144);
        this.addCoolantNAKRecipe("silver", 144);
        this.addCoolantNAKRecipe("fluorite", 1332);
        this.addCoolantNAKRecipe("villiaumite", 1332);
        this.addCoolantNAKRecipe("carobbiite", 1332);
        this.addCoolantNAKRecipe("arsenic", 1332);
        this.addCoolantNAKRecipe("liquid_nitrogen", 250);
        this.addCoolantNAKRecipe("liquid_helium", 250);
        this.addCoolantNAKRecipe("enderium", 144);
        this.addCoolantNAKRecipe("cryotheum", 250);
        this.addFissionFuelIsotopeRecipes("u", "uranium", 238, 233, 235);
        this.addFissionFuelIsotopeRecipes("n", "neptunium", 237, 236);
        this.addFissionFuelIsotopeRecipes("p", "plutonium", 242, 239, 241);
        for (int fissile : new int[]{239, 241}) {
            this.addRecipe(SaltMixerRecipes.fluidStack("uranium_238", 128), SaltMixerRecipes.fluidStack("plutonium_" + fissile, 16), SaltMixerRecipes.fluidStack("fuel_mix_" + fissile, 144), 1.0, 1.0);
        }
        this.addFissionFuelIsotopeRecipes("a", "americium", 243, 242);
        this.addFissionFuelIsotopeRecipes("cm", "curium", 246, 243, 245, 247);
        this.addFissionFuelIsotopeRecipes("b", "berkelium", 247, 248);
        this.addFissionFuelIsotopeRecipes("cf", "californium", 252, 249, 251);
        this.addFissionFLIBERecipes();
    }

    public void addCoolantNAKRecipe(String name, int amount) {
        this.addRecipe(SaltMixerRecipes.fluidStack(name, amount), SaltMixerRecipes.fluidStack("nak", 144), SaltMixerRecipes.fluidStack(name + "_nak", 144), 0.5, 1.0);
    }

    public void addFissionFuelIsotopeRecipes(String suffix, String element, int fertile, int ... fissiles) {
        for (int fissile : fissiles) {
            this.addRecipe(SaltMixerRecipes.fluidStack(element + "_" + fertile, 128), SaltMixerRecipes.fluidStack(element + "_" + fissile, 16), SaltMixerRecipes.fluidStack("le" + suffix + "_" + fissile, 144), 1.0, 1.0);
            this.addRecipe(SaltMixerRecipes.fluidStack("le" + suffix + "_" + fissile, 48), SaltMixerRecipes.fluidStack(element + "_" + fissile, 16), SaltMixerRecipes.fluidStack("he" + suffix + "_" + fissile, 64), 0.5, 1.0);
        }
    }

    public void addFissionFLIBERecipes() {
        for (String element : FissionHelper.FISSION_FLUID) {
            this.addRecipe(SaltMixerRecipes.fluidStack(element + "_fluoride", 72), SaltMixerRecipes.fluidStack("flibe", 72), SaltMixerRecipes.fluidStack(element + "_fluoride_flibe", 72), 0.5, 1.0);
        }
    }

    @Override
    public List fixExtras(List extras) {
        ArrayList<Double> fixed = new ArrayList<Double>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 1.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }

    @Override
    public List getFactoredExtras(List extras, int factor) {
        ArrayList<Double> factored = new ArrayList<Double>(extras);
        factored.set(0, (Double)extras.get(0) / (double)factor);
        return factored;
    }
}

