/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.vanilla;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.init.NCArmor;
import nc.init.NCBlocks;
import nc.init.NCItems;
import nc.init.NCTools;
import nc.multiblock.qComputer.QuantumGateEnums;
import nc.radiation.RadArmor;
import nc.recipe.vanilla.ingredient.BucketIngredient;
import nc.recipe.vanilla.recipe.ShapedEnergyRecipe;
import nc.recipe.vanilla.recipe.ShapedFluidRecipe;
import nc.recipe.vanilla.recipe.ShapelessArmorRadShieldingRecipe;
import nc.recipe.vanilla.recipe.ShapelessFluidRecipe;
import nc.util.ArmorHelper;
import nc.util.NCUtil;
import nc.util.OreDictHelper;
import nc.util.RegistryHelper;
import nc.util.StackHelper;
import nc.util.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.patchouli.common.item.ItemModBook;

public class CraftingRecipeHandler {
    private static final Object2IntMap<String> RECIPE_COUNT_MAP = new Object2IntOpenHashMap();

    public static void registerCraftingRecipes() {
        int i;
        if (ModCheck.patchouliLoaded()) {
            CraftingRecipeHandler.addShapelessOreRecipe(ItemModBook.forBook((String)"nuclearcraft:guide"), Items.field_151122_aG, "ingotUranium");
            CraftingRecipeHandler.addShapelessOreRecipe(Items.field_151122_aG, ItemModBook.forBook((String)"nuclearcraft:guide"));
        }
        for (i = 0; i < MetaEnums.IngotType.values().length; ++i) {
            String type = StringHelper.capitalize(MetaEnums.IngotType.values()[i].func_176610_l());
            if (!NCConfig.ore_dict_raw_material_recipes) {
                CraftingRecipeHandler.blockCompress(NCBlocks.ingot_block, i, "block" + type, new ItemStack(NCItems.ingot, 1, i));
            } else {
                for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + type))) {
                    CraftingRecipeHandler.blockCompress(NCBlocks.ingot_block, i, "block" + type, ingot);
                }
            }
            if (!NCConfig.ore_dict_raw_material_recipes) {
                CraftingRecipeHandler.blockOpen(NCItems.ingot, i, "ingot" + type, new ItemStack(NCBlocks.ingot_block, 1, i));
                continue;
            }
            for (ItemStack block : OreDictionary.getOres((String)("block" + type))) {
                CraftingRecipeHandler.blockOpen(NCItems.ingot, i, "ingot" + type, block);
            }
        }
        CraftingRecipeHandler.blockCompress(NCBlocks.fertile_isotope, 0, "blockUranium238", "ingotUranium238");
        CraftingRecipeHandler.blockCompress(NCBlocks.fertile_isotope, 1, "blockNeptunium237", "ingotNeptunium237");
        CraftingRecipeHandler.blockCompress(NCBlocks.fertile_isotope, 2, "blockPlutonium242", "ingotPlutonium242");
        CraftingRecipeHandler.blockCompress(NCBlocks.fertile_isotope, 3, "blockAmericium243", "ingotAmericium243");
        CraftingRecipeHandler.blockCompress(NCBlocks.fertile_isotope, 4, "blockCurium246", "ingotCurium246");
        CraftingRecipeHandler.blockCompress(NCBlocks.fertile_isotope, 5, "blockBerkelium247", "ingotBerkelium247");
        CraftingRecipeHandler.blockCompress(NCBlocks.fertile_isotope, 6, "blockCalifornium252", "ingotCalifornium252");
        CraftingRecipeHandler.blockOpen(NCItems.uranium, 10, "ingotUranium238", "blockUranium238");
        CraftingRecipeHandler.blockOpen(NCItems.neptunium, 5, "ingotNeptunium237", "blockNeptunium237");
        CraftingRecipeHandler.blockOpen(NCItems.plutonium, 15, "ingotPlutonium242", "blockPlutonium242");
        CraftingRecipeHandler.blockOpen(NCItems.americium, 10, "ingotAmericium243", "blockAmericium243");
        CraftingRecipeHandler.blockOpen(NCItems.curium, 10, "ingotCurium246", "blockCurium246");
        CraftingRecipeHandler.blockOpen(NCItems.berkelium, 0, "ingotBerkelium247", "blockBerkelium247");
        CraftingRecipeHandler.blockOpen(NCItems.californium, 15, "ingotCalifornium252", "blockCalifornium252");
        if (NCConfig.register_processor[0]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.nuclear_furnace, "PTP", "TFT", "PTP", Character.valueOf('T'), "ingotTough", Character.valueOf('P'), "plateBasic", Character.valueOf('F'), Blocks.field_150460_al);
        }
        if (NCConfig.register_processor[1]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.manufactory, "LRL", "FPF", "LSL", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('L'), "ingotLead", Character.valueOf('S'), "solenoidCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), Items.field_151145_ak);
        }
        if (NCConfig.register_processor[2]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.alloy_furnace, "PRP", "BFB", "PSP", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('P'), "plateBasic", Character.valueOf('S'), "solenoidCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('B'), Items.field_151118_aC);
        }
        if (NCConfig.register_processor[3]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.decay_hastener, "PGP", "ECE", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "solenoidCopper", Character.valueOf('G'), "dustGlowstone", Character.valueOf('E'), Items.field_151079_bi);
        }
        if (NCConfig.register_processor[4]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.fuel_reprocessor, "PBP", "TCT", "PAP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateBasic", Character.valueOf('A'), "actuator", Character.valueOf('T'), "ingotTough", Character.valueOf('B'), "ingotBoron");
        }
        if (NCConfig.register_processor[5]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.separator, "PMP", "RCR", "PMP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateBasic", Character.valueOf('M'), "motor", Character.valueOf('R'), "dustRedstone");
        }
        if (NCConfig.register_processor[6]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.pressurizer, "PTP", "ACA", "PTP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('T'), "ingotTough", Character.valueOf('A'), "actuator");
        }
        if (NCConfig.register_processor[7]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_mixer, "PSP", "BCB", "PMP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateBasic", Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('M'), "motor", Character.valueOf('S'), "ingotSteel");
        }
        if (NCConfig.register_processor[8]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.enricher, "PHP", "LCL", "PMP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('L'), "gemLapis", Character.valueOf('M'), "motor", Character.valueOf('H'), Blocks.field_150438_bZ);
        }
        if (NCConfig.register_processor[9]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.chemical_reactor, "PMP", "GCG", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('G'), "dustGlowstone", Character.valueOf('M'), "motor", Character.valueOf('S'), "servo");
        }
        if (NCConfig.register_processor[10]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.electrolyzer, "PGP", "SCS", "PMP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "solenoidCopper", Character.valueOf('G'), "ingotGraphite", Character.valueOf('M'), "motor");
        }
        if (NCConfig.register_processor[11]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.assembler, "PHP", "ACA", "PMP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateBasic", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('A'), "actuator", Character.valueOf('M'), "motor");
        }
        if (NCConfig.register_processor[12]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.supercooler, "PDP", "HCH", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('D'), "ingotMagnesiumDiboride", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('S'), "servo");
        }
        if (NCConfig.register_processor[13]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.ingot_former, "PHP", "FCF", "PTP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateBasic", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), Blocks.field_150438_bZ);
        }
        if (NCConfig.register_processor[14]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.melter, "PNP", "NCN", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('N'), "ingotBrickNether", Character.valueOf('S'), "servo");
        }
        if (NCConfig.register_processor[15]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.crystallizer, "PSP", "SCS", "PUP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "solenoidCopper", Character.valueOf('U'), Items.field_151066_bu);
        }
        if (NCConfig.register_processor[16]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.infuser, "PBP", "GCG", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('G'), "ingotGold", Character.valueOf('S'), "servo", Character.valueOf('B'), Items.field_151133_ar);
        }
        if (NCConfig.register_processor[17]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.extractor, "PMP", "BCB", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('S'), "servo", Character.valueOf('B'), Items.field_151133_ar);
        }
        if (NCConfig.register_processor[18]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.centrifuge, "PFP", "MCM", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('M'), "motor", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('S'), "servo");
        }
        if (NCConfig.register_processor[19]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rock_crusher, "PMP", "ACA", "PTP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('A'), "actuator", Character.valueOf('T'), "ingotTough", Character.valueOf('M'), "motor");
        }
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.machine_interface, " A ", "MCM", " S ", Character.valueOf('C'), "chassis", Character.valueOf('A'), "actuator", Character.valueOf('M'), "motor", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rtg_uranium, "PGP", "GUG", "PGP", Character.valueOf('G'), "ingotGraphite", Character.valueOf('P'), "plateBasic", Character.valueOf('U'), "blockUranium238");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rtg_plutonium, "PGP", "GUG", "PGP", Character.valueOf('G'), "ingotGraphite", Character.valueOf('P'), "plateAdvanced", Character.valueOf('U'), "ingotPlutonium238All");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rtg_americium, "PGP", "GAG", "PGP", Character.valueOf('G'), "ingotGraphite", Character.valueOf('P'), "plateAdvanced", Character.valueOf('A'), "ingotAmericium241All");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rtg_californium, "PGP", "GCG", "PGP", Character.valueOf('G'), "ingotGraphite", Character.valueOf('P'), "plateAdvanced", Character.valueOf('C'), "ingotCalifornium250All");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_basic, "GQG", "PLP", "CPC", Character.valueOf('G'), "dustGraphite", Character.valueOf('Q'), "dustQuartz", Character.valueOf('P'), Blocks.field_150443_bT, Character.valueOf('L'), "gemLapis", Character.valueOf('C'), "solenoidCopper");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_basic, "GQG", "PLP", "CPC", Character.valueOf('G'), "dustGraphite", Character.valueOf('Q'), "dustNetherQuartz", Character.valueOf('P'), Blocks.field_150443_bT, Character.valueOf('L'), "gemLapis", Character.valueOf('C'), "solenoidCopper");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_advanced, "PGP", "SSS", "PCP", Character.valueOf('S'), NCBlocks.solar_panel_basic, Character.valueOf('G'), "dustGraphite", Character.valueOf('P'), "plateAdvanced", Character.valueOf('C'), "solenoidCopper");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_du, "PGP", "SSS", "PMP", Character.valueOf('S'), NCBlocks.solar_panel_advanced, Character.valueOf('G'), "dustGraphite", Character.valueOf('P'), "plateDU", Character.valueOf('M'), "solenoidMagnesiumDiboride");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_elite, "PBP", "SSS", "PMP", Character.valueOf('S'), NCBlocks.solar_panel_du, Character.valueOf('B'), "gemBoronArsenide", Character.valueOf('P'), "plateElite", Character.valueOf('M'), "solenoidMagnesiumDiboride");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.decay_generator, "LCL", "CRC", "LCL", Character.valueOf('C'), "cobblestone", Character.valueOf('L'), "ingotLead", Character.valueOf('R'), "dustRedstone");
        if (NCConfig.register_battery[0]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.voltaic_pile_basic, "PSP", "SMS", "PSP", Character.valueOf('P'), "plateBasic", Character.valueOf('S'), "solenoidCopper", Character.valueOf('M'), "blockMagnesium");
            CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.voltaic_pile_advanced, "PMP", "VVV", "PCP", Character.valueOf('V'), NCBlocks.voltaic_pile_basic, Character.valueOf('P'), "plateAdvanced", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('C'), "ingotCopper");
            CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.voltaic_pile_du, "PMP", "VVV", "PCP", Character.valueOf('V'), NCBlocks.voltaic_pile_advanced, Character.valueOf('P'), "plateDU", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('C'), "ingotCopper");
            CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.voltaic_pile_elite, "PMP", "VVV", "PCP", Character.valueOf('V'), NCBlocks.voltaic_pile_du, Character.valueOf('P'), "plateElite", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('C'), "ingotCopper");
        }
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.lithium_ion_cell, "CCC", "FLF", "DDD", Character.valueOf('C'), "ingotHardCarbon", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('L'), "ingotLithium", Character.valueOf('D'), "ingotLithiumManganeseDioxide");
        if (NCConfig.register_battery[1]) {
            CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.lithium_ion_battery_basic, "PCP", "CSC", "PCP", Character.valueOf('C'), NCItems.lithium_ion_cell, Character.valueOf('P'), "plateElite", Character.valueOf('S'), "solenoidMagnesiumDiboride");
            CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.lithium_ion_battery_advanced, "PDP", "LLL", "PSP", Character.valueOf('L'), NCBlocks.lithium_ion_battery_basic, Character.valueOf('P'), "plateAdvanced", Character.valueOf('D'), "ingotLithiumManganeseDioxide", Character.valueOf('S'), "solenoidMagnesiumDiboride");
            CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.lithium_ion_battery_du, "PDP", "LLL", "PSP", Character.valueOf('L'), NCBlocks.lithium_ion_battery_advanced, Character.valueOf('P'), "plateDU", Character.valueOf('D'), "ingotLithiumManganeseDioxide", Character.valueOf('S'), "solenoidMagnesiumDiboride");
            CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.lithium_ion_battery_elite, "PDP", "LLL", "PSP", Character.valueOf('L'), NCBlocks.lithium_ion_battery_du, Character.valueOf('P'), "plateElite", Character.valueOf('D'), "ingotLithiumManganeseDioxide", Character.valueOf('S'), "solenoidMagnesiumDiboride");
        }
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.bin, "PZP", "Z Z", "PZP", Character.valueOf('P'), "plateBasic", Character.valueOf('Z'), "ingotSiliconCarbide");
        if (NCConfig.register_passive[0]) {
            CraftingRecipeHandler.addShapedFluidRecipe(NCBlocks.cobblestone_generator, new Object[]{"PIP", "L W", "PIP", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), "plateBasic", Character.valueOf('L'), new BucketIngredient("lava"), Character.valueOf('W'), new BucketIngredient("water")});
            CraftingRecipeHandler.addShapedFluidRecipe(NCBlocks.cobblestone_generator, new Object[]{"PIP", "W L", "PIP", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), "plateBasic", Character.valueOf('L'), new BucketIngredient("lava"), Character.valueOf('W'), new BucketIngredient("water")});
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.cobblestone_generator_compact, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.cobblestone_generator, Character.valueOf('I'), "ingotBronze");
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.cobblestone_generator_dense, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.cobblestone_generator_compact, Character.valueOf('I'), "ingotGold");
        }
        if (NCConfig.register_passive[1]) {
            CraftingRecipeHandler.addShapedFluidRecipe(NCBlocks.water_source, new Object[]{"PIP", "W W", "PIP", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), "plateBasic", Character.valueOf('W'), new BucketIngredient("water")});
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.water_source_compact, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.water_source, Character.valueOf('I'), "ingotBronze");
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.water_source_dense, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.water_source_compact, Character.valueOf('I'), "ingotGold");
        }
        if (NCConfig.register_passive[2]) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.nitrogen_collector, "PIP", "B B", "PIP", Character.valueOf('I'), "ingotBeryllium", Character.valueOf('P'), "plateAdvanced", Character.valueOf('B'), Items.field_151133_ar);
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.nitrogen_collector_compact, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.nitrogen_collector, Character.valueOf('I'), "ingotBronze");
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.nitrogen_collector_dense, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.nitrogen_collector_compact, Character.valueOf('I'), "ingotGold");
        }
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_casing, 8), " P ", "PFP", " P ", Character.valueOf('P'), "plateBasic", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.fission_casing, NCBlocks.fission_glass);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.fission_casing, NCBlocks.fission_conductor);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.fission_glass, NCBlocks.fission_casing, "blockGlass");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.fission_conductor, NCBlocks.fission_casing);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_monitor, 4), "PGP", "TFT", "PGP", Character.valueOf('P'), "plateBasic", Character.valueOf('G'), "dustGlowstone", Character.valueOf('T'), "ingotTough", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_power_port, 4), "PTP", "RFR", "PTP", Character.valueOf('P'), "plateBasic", Character.valueOf('T'), "ingotTough", Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_vent, 4), "PTP", "VFV", "PTP", Character.valueOf('P'), "plateBasic", Character.valueOf('T'), "ingotTough", Character.valueOf('V'), "servo", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_irradiator, 4), "PZP", "AFA", "PZP", Character.valueOf('P'), "plateBasic", Character.valueOf('Z'), "ingotZirconium", Character.valueOf('A'), "ingotZircaloy", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_source, 2, 0), "PRP", "BFB", "PRP", Character.valueOf('P'), "plateBasic", Character.valueOf('R'), "dustRadium", Character.valueOf('B'), "dustBeryllium", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_source, 2, 1), "PLP", "BFB", "PLP", Character.valueOf('P'), "plateBasic", Character.valueOf('L'), "dustPolonium", Character.valueOf('B'), "dustBeryllium", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_source, 2, 2), "PCP", "CFC", "PCP", Character.valueOf('P'), "plateBasic", Character.valueOf('C'), "ingotCalifornium252All", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_shield, 4, 0), "PBP", "IFI", "PBP", Character.valueOf('P'), "plateBasic", Character.valueOf('B'), "ingotBoron", Character.valueOf('I'), "ingotSilver", Character.valueOf('F'), "steelFrame");
        if (ModCheck.openComputersLoaded()) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.fission_computer_port, "PMP", "CFC", "PBP", Character.valueOf('P'), "plateBasic", Character.valueOf('M'), RegistryHelper.itemStackFromRegistry("opencomputers:material:7"), Character.valueOf('C'), RegistryHelper.blockStackFromRegistry("opencomputers:cable:0"), Character.valueOf('B'), RegistryHelper.itemStackFromRegistry("opencomputers:material:4"), Character.valueOf('F'), "steelFrame");
        }
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_reflector, 2, 0), "BGB", "GFG", "BGB", Character.valueOf('B'), "ingotBeryllium", Character.valueOf('G'), "ingotGraphite", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_reflector, 2, 1), "LSL", "SFS", "LSL", Character.valueOf('L'), "ingotLead", Character.valueOf('S'), "ingotSteel", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_irradiator_port, 4), "PHP", "ZFZ", "PHP", Character.valueOf('P'), "plateBasic", Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('Z'), "ingotZirconium", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_cell_port, 4), "PHP", "ZFZ", "PHP", Character.valueOf('P'), "plateAdvanced", Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('Z'), "ingotZircaloy", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_vessel_port, 4), "PSP", "ZFZ", "PSP", Character.valueOf('P'), "plateElite", Character.valueOf('S'), "servo", Character.valueOf('Z'), "ingotZircaloy", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 4, 0), "PSP", "TFT", "PSP", Character.valueOf('P'), "plateElite", Character.valueOf('S'), "servo", Character.valueOf('T'), "ingotThermoconducting", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 1), " I ", "IPI", " I ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('I'), "ingotIron");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 2), "RRR", "RPR", "RRR", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('R'), "dustRedstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 3), "QQQ", "QPQ", "QQQ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('Q'), "gemQuartz");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 4), "DOD", "OPO", "DOD", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('O'), "obsidian", Character.valueOf('D'), "dustObsidian");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 5), "INI", "NPN", "INI", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('N'), Blocks.field_150385_bj, Character.valueOf('I'), "ingotBrickNether");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 6), "GGG", "GPG", "GGG", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('G'), "dustGlowstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 7), "LLL", "LPL", "LLL", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('L'), "gemLapis");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 8), " G ", "GPG", " G ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('G'), "ingotGold");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 9), " R ", "RPR", " R ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('R'), "gemPrismarine");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 10), "BBB", "BPB", "BBB", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('B'), "slimeball");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 11), "DED", "EPE", "DED", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('E'), "endstone", Character.valueOf('D'), "dustEndstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 12), "CBC", "BPB", "CBC", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('B'), Blocks.field_185767_cT, Character.valueOf('C'), Items.field_185162_cT);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 13), " D ", "DPD", " D ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('D'), "gemDiamond");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 14), " E ", "EPE", " E ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('E'), "gemEmerald");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port, 1, 15), " C ", "CPC", " C ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('C'), "ingotCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 0), " T ", "TPT", " T ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('T'), "ingotTin");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 1), " L ", "LPL", " L ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('L'), "ingotLead");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 2), " B ", "BPB", " B ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('B'), "ingotBoron");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 3), " L ", "LPL", " L ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('L'), "ingotLithium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 4), " M ", "MPM", " M ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('M'), "ingotMagnesium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 5), " M ", "MPM", " M ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('M'), "ingotManganese");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 6), " A ", "APA", " A ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('A'), "ingotAluminum");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 7), " I ", "IPI", " I ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('I'), "ingotSilver");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 8), "FFF", "FPF", "FFF", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('F'), "gemFluorite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 9), "VVV", "VPV", "VVV", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('V'), "gemVilliaumite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 10), "CCC", "CPC", "CCC", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('C'), "gemCarobbiite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 11), "AAA", "APA", "AAA", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('A'), "dustArsenic");
        CraftingRecipeHandler.addShapelessFluidRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 12), new Object[]{new ItemStack(NCBlocks.fission_heater_port, 1, 0), new BucketIngredient("liquid_nitrogen")});
        CraftingRecipeHandler.addShapelessFluidRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 13), new Object[]{new ItemStack(NCBlocks.fission_heater_port, 1, 0), new BucketIngredient("liquid_helium")});
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 14), " E ", "EPE", " E ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('E'), "ingotEnderium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_heater_port2, 1, 15), " C ", "CPC", " C ", Character.valueOf('P'), new ItemStack(NCBlocks.fission_heater_port, 1, 0), Character.valueOf('C'), "dustCryotheum");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_shield_manager, 4), "PTP", "RFR", "PTP", Character.valueOf('P'), "plateBasic", Character.valueOf('T'), "ingotTough", Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solid_fission_controller, "PTP", "HFH", "PTP", Character.valueOf('P'), "plateAdvanced", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_cell, 4), "PTP", "ZFZ", "PTP", Character.valueOf('P'), "plateAdvanced", Character.valueOf('T'), "ingotTough", Character.valueOf('Z'), "ingotZircaloy", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapelessFluidRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 0), new Object[]{"emptyHeatSink", new BucketIngredient("water")});
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 1), " I ", "ISI", " I ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('I'), "ingotIron");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 2), "RRR", "RSR", "RRR", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('R'), "dustRedstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 3), "QQQ", "QSQ", "QQQ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('Q'), "gemQuartz");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 4), "DOD", "OSO", "DOD", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('O'), "obsidian", Character.valueOf('D'), "dustObsidian");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 5), "INI", "NSN", "INI", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('N'), Blocks.field_150385_bj, Character.valueOf('I'), "ingotBrickNether");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 6), "GGG", "GSG", "GGG", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('G'), "dustGlowstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 7), "LLL", "LSL", "LLL", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('L'), "gemLapis");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 8), " G ", "GSG", " G ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('G'), "ingotGold");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 9), " P ", "PSP", " P ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('P'), "gemPrismarine");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 10), "BBB", "BSB", "BBB", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('B'), "slimeball");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 11), "DED", "ESE", "DED", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('E'), "endstone", Character.valueOf('D'), "dustEndstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 12), "CPC", "PSP", "CPC", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('P'), Blocks.field_185767_cT, Character.valueOf('C'), Items.field_185162_cT);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 13), " D ", "DSD", " D ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('D'), "gemDiamond");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 14), " E ", "ESE", " E ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('E'), "gemEmerald");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink, 1, 15), " C ", "CSC", " C ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('C'), "ingotCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 0), " T ", "TST", " T ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('T'), "ingotTin");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 1), " L ", "LSL", " L ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('L'), "ingotLead");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 2), " B ", "BSB", " B ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('B'), "ingotBoron");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 3), " L ", "LSL", " L ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('L'), "ingotLithium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 4), " M ", "MSM", " M ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('M'), "ingotMagnesium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 5), " M ", "MSM", " M ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('M'), "ingotManganese");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 6), " A ", "ASA", " A ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('A'), "ingotAluminum");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 7), " I ", "ISI", " I ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('I'), "ingotSilver");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 8), "FFF", "FSF", "FFF", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('F'), "gemFluorite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 9), "VVV", "VSV", "VVV", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('V'), "gemVilliaumite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 10), "CCC", "CSC", "CCC", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('C'), "gemCarobbiite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 11), "AAA", "ASA", "AAA", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('A'), "dustArsenic");
        CraftingRecipeHandler.addShapelessFluidRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 12), new Object[]{"emptyHeatSink", new BucketIngredient("liquid_nitrogen")});
        CraftingRecipeHandler.addShapelessFluidRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 13), new Object[]{"emptyHeatSink", new BucketIngredient("liquid_helium")});
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 14), " E ", "ESE", " E ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('E'), "ingotEnderium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.solid_fission_sink2, 1, 15), " C ", "CSC", " C ", Character.valueOf('S'), "emptyHeatSink", Character.valueOf('C'), "dustCryotheum");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_controller, "PMP", "EFE", "PMP", Character.valueOf('P'), "plateElite", Character.valueOf('E'), "ingotExtreme", Character.valueOf('M'), "ingotZirconiumMolybdenum", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_vessel, 4), "PMP", "ZFZ", "PMP", Character.valueOf('P'), "plateElite", Character.valueOf('M'), "ingotZirconiumMolybdenum", Character.valueOf('Z'), "ingotZircaloy", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 8, 0), "PEP", "TFT", "PEP", Character.valueOf('P'), "plateElite", Character.valueOf('E'), "ingotExtreme", Character.valueOf('T'), "ingotThermoconducting", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 1), " I ", "IHI", " I ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('I'), "ingotIron");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 2), "RRR", "RHR", "RRR", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('R'), "dustRedstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 3), "QQQ", "QHQ", "QQQ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('Q'), "gemQuartz");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 4), "DOD", "OHO", "DOD", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('O'), "obsidian", Character.valueOf('D'), "dustObsidian");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 5), "INI", "NHN", "INI", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('N'), Blocks.field_150385_bj, Character.valueOf('I'), "ingotBrickNether");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 6), "GGG", "GHG", "GGG", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('G'), "dustGlowstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 7), "LLL", "LHL", "LLL", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('L'), "gemLapis");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 8), " G ", "GHG", " G ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('G'), "ingotGold");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 9), " P ", "PHP", " P ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('P'), "gemPrismarine");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 10), "BBB", "BHB", "BBB", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('B'), "slimeball");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 11), "DED", "EHE", "DED", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('E'), "endstone", Character.valueOf('D'), "dustEndstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 12), "CPC", "PHP", "CPC", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('P'), Blocks.field_185767_cT, Character.valueOf('C'), Items.field_185162_cT);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 13), " D ", "DHD", " D ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('D'), "gemDiamond");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 14), " E ", "EHE", " E ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('E'), "gemEmerald");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater, 1, 15), " C ", "CHC", " C ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('C'), "ingotCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 0), " T ", "THT", " T ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('T'), "ingotTin");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 1), " L ", "LHL", " L ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('L'), "ingotLead");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 2), " B ", "BHB", " B ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('B'), "ingotBoron");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 3), " L ", "LHL", " L ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('L'), "ingotLithium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 4), " M ", "MHM", " M ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('M'), "ingotMagnesium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 5), " M ", "MHM", " M ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('M'), "ingotManganese");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 6), " A ", "AHA", " A ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('A'), "ingotAluminum");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 7), " I ", "IHI", " I ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('I'), "ingotSilver");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 8), "FFF", "FHF", "FFF", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('F'), "gemFluorite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 9), "VVV", "VHV", "VVV", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('V'), "gemVilliaumite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 10), "CCC", "CHC", "CCC", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('C'), "gemCarobbiite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 11), "AAA", "AHA", "AAA", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('A'), "dustArsenic");
        CraftingRecipeHandler.addShapelessFluidRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 12), new Object[]{new ItemStack(NCBlocks.salt_fission_heater, 1, 0), new BucketIngredient("liquid_nitrogen")});
        CraftingRecipeHandler.addShapelessFluidRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 13), new Object[]{new ItemStack(NCBlocks.salt_fission_heater, 1, 0), new BucketIngredient("liquid_helium")});
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 14), " E ", "EHE", " E ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('E'), "ingotEnderium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_heater2, 1, 15), " C ", "CHC", " C ", Character.valueOf('H'), new ItemStack(NCBlocks.salt_fission_heater, 1, 0), Character.valueOf('C'), "dustCryotheum");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.heat_exchanger_controller, "SES", "TFT", "SES", Character.valueOf('S'), "stone", Character.valueOf('E'), "ingotExtreme", Character.valueOf('T'), "ingotThermoconducting", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_casing, 8), " S ", "SFS", " S ", Character.valueOf('S'), "stone", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_casing, NCBlocks.heat_exchanger_glass);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_glass, NCBlocks.heat_exchanger_casing, "blockGlass");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_vent, 4), "SIS", "VFV", "SIS", Character.valueOf('S'), "stone", Character.valueOf('I'), "ingotSteel", Character.valueOf('V'), "servo", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_tube_copper, 4), "SCS", "CFC", "SVS", Character.valueOf('S'), "stone", Character.valueOf('C'), "ingotCopper", Character.valueOf('F'), "steelFrame", Character.valueOf('V'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_tube_hard_carbon, 4), "SHS", "HFH", "SVS", Character.valueOf('S'), "stone", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('F'), "steelFrame", Character.valueOf('V'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_tube_thermoconducting, 4), "STS", "TFT", "SVS", Character.valueOf('S'), "stone", Character.valueOf('T'), "ingotThermoconducting", Character.valueOf('F'), "steelFrame", Character.valueOf('V'), "servo");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_tube_copper, NCBlocks.condenser_tube_copper);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_tube_hard_carbon, NCBlocks.condenser_tube_hard_carbon);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_tube_thermoconducting, NCBlocks.condenser_tube_thermoconducting);
        if (ModCheck.openComputersLoaded()) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.heat_exchanger_computer_port, "SMS", "CFC", "SPS", Character.valueOf('S'), "stone", Character.valueOf('M'), RegistryHelper.itemStackFromRegistry("opencomputers:material:7"), Character.valueOf('C'), RegistryHelper.blockStackFromRegistry("opencomputers:cable:0"), Character.valueOf('P'), RegistryHelper.itemStackFromRegistry("opencomputers:material:4"), Character.valueOf('F'), "steelFrame");
        }
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.condenser_controller, "STS", "CFC", "STS", Character.valueOf('S'), "stone", Character.valueOf('T'), "ingotTough", Character.valueOf('C'), "ingotThermoconducting", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.condenser_tube_copper, NCBlocks.heat_exchanger_tube_copper);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.condenser_tube_hard_carbon, NCBlocks.heat_exchanger_tube_hard_carbon);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.condenser_tube_thermoconducting, NCBlocks.heat_exchanger_tube_thermoconducting);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.turbine_controller, "STS", "TFT", "STS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('T'), "ingotTough", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_casing, 8), " S ", "SFS", " S ", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.turbine_casing, NCBlocks.turbine_glass);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.turbine_glass, NCBlocks.turbine_casing, "blockGlass");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_shaft, 4), "SSS", "TTT", "SSS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('T'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_blade_steel, 4), "SHS", "SHS", "SHS", Character.valueOf('S'), "ingotSteel", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_blade_extreme, 4), "EHE", "EHE", "EHE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_blade_sic_sic_cmc, 4), "SHS", "SHS", "SHS", Character.valueOf('S'), "ingotSiCSiCCMC", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_stator, 4), "SS", "SS", "SS", Character.valueOf('S'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_bearing, 4), "SGS", "GFG", "SGS", Character.valueOf('G'), "nuggetGold", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 2, 0), "MMM", "HTH", "MMM", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 2, 1), "BBB", "HTH", "BBB", Character.valueOf('B'), "ingotBeryllium", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 2, 2), "AAA", "HTH", "AAA", Character.valueOf('A'), "ingotAluminum", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 2, 3), "GGG", "HTH", "GGG", Character.valueOf('G'), "ingotGold", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 2, 4), "CCC", "HTH", "CCC", Character.valueOf('C'), "ingotCopper", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 2, 5), "SSS", "HTH", "SSS", Character.valueOf('S'), "ingotSilver", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_coil_connector, 4), "HHH", "HTH", "HHH", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_inlet, 4), "STS", "VFV", "STS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('T'), "ingotTough", Character.valueOf('V'), "servo", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_outlet, 4), "SSS", "VFV", "SSS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('V'), "servo", Character.valueOf('F'), "steelFrame");
        if (ModCheck.openComputersLoaded()) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.turbine_computer_port, "SMS", "CFC", "SPS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('M'), RegistryHelper.itemStackFromRegistry("opencomputers:material:7"), Character.valueOf('C'), RegistryHelper.blockStackFromRegistry("opencomputers:cable:0"), Character.valueOf('P'), RegistryHelper.itemStackFromRegistry("opencomputers:material:4"), Character.valueOf('F'), "steelFrame");
        }
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 2, 0), "LG", "GL", Character.valueOf('L'), "ingotLead", Character.valueOf('G'), "dustGraphite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 2, 0), "GL", "LG", Character.valueOf('L'), "ingotLead", Character.valueOf('G'), "dustGraphite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 1), " R ", "TPT", " R ", Character.valueOf('R'), "dustRedstone", Character.valueOf('T'), "ingotTough", Character.valueOf('P'), "plateBasic");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 2), "SUS", "UPU", "SUS", Character.valueOf('S'), "dustSulfur", Character.valueOf('U'), "ingotUranium238", Character.valueOf('P'), "plateAdvanced");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 3), "RBR", "BPB", "RBR", Character.valueOf('R'), "dustCrystalBinder", Character.valueOf('B'), "ingotBoron", Character.valueOf('P'), "plateDU");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 2, 4), "CC", "II", "CC", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotIron");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 2, 5), "MM", "TT", "MM", Character.valueOf('M'), "ingotMagnesiumDiboride", Character.valueOf('T'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 7), "F F", "RSR", "SCS", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "ingotCopper", Character.valueOf('R'), "dustRedstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 8), "SSG", "CCI", "SSG", Character.valueOf('G'), "nuggetGold", Character.valueOf('S'), "ingotSteel", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "solenoidCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 9), "  S", "FP ", "CF ", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('C'), "ingotCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 10), "LSL", "STS", "LSL", Character.valueOf('L'), "ingotLead", Character.valueOf('T'), "ingotTough", Character.valueOf('S'), "ingotSteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 11), "PTP", "I I", "PTP", Character.valueOf('P'), "plateBasic", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "ingotTin");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 12), "STS", "TBT", "STS", Character.valueOf('S'), "ingotSteel", Character.valueOf('B'), "ingotBronze", Character.valueOf('T'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 8, 14), "PSP", "T T", "PSP", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "ingotSteel", Character.valueOf('T'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.upgrade, 1, 0), "LRL", "RPR", "LRL", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Blocks.field_150443_bT);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.upgrade, 1, 1), "OQO", "QPQ", "OQO", Character.valueOf('O'), "dustObsidian", Character.valueOf('Q'), "dustQuartz", Character.valueOf('P'), Blocks.field_150445_bS);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.upgrade, 1, 1), "OQO", "QPQ", "OQO", Character.valueOf('O'), "dustObsidian", Character.valueOf('Q'), "dustNetherQuartz", Character.valueOf('P'), Blocks.field_150445_bS);
        CraftingRecipeHandler.tools("ingotBoron", NCTools.sword_boron, NCTools.pickaxe_boron, NCTools.shovel_boron, NCTools.axe_boron, NCTools.hoe_boron, NCTools.spaxelhoe_boron);
        CraftingRecipeHandler.tools("ingotTough", NCTools.sword_tough, NCTools.pickaxe_tough, NCTools.shovel_tough, NCTools.axe_tough, NCTools.hoe_tough, NCTools.spaxelhoe_tough);
        CraftingRecipeHandler.tools("ingotHardCarbon", NCTools.sword_hard_carbon, NCTools.pickaxe_hard_carbon, NCTools.shovel_hard_carbon, NCTools.axe_hard_carbon, NCTools.hoe_hard_carbon, NCTools.spaxelhoe_hard_carbon);
        CraftingRecipeHandler.tools("gemBoronNitride", NCTools.sword_boron_nitride, NCTools.pickaxe_boron_nitride, NCTools.shovel_boron_nitride, NCTools.axe_boron_nitride, NCTools.hoe_boron_nitride, NCTools.spaxelhoe_boron_nitride);
        CraftingRecipeHandler.armor("ingotBoron", NCArmor.helm_boron, NCArmor.chest_boron, NCArmor.legs_boron, NCArmor.boots_boron);
        CraftingRecipeHandler.armor("ingotTough", NCArmor.helm_tough, NCArmor.chest_tough, NCArmor.legs_tough, NCArmor.boots_tough);
        CraftingRecipeHandler.armor("ingotHardCarbon", NCArmor.helm_hard_carbon, NCArmor.chest_hard_carbon, NCArmor.legs_hard_carbon, NCArmor.boots_hard_carbon);
        CraftingRecipeHandler.armor("gemBoronNitride", NCArmor.helm_boron_nitride, NCArmor.chest_boron_nitride, NCArmor.legs_boron_nitride, NCArmor.boots_boron_nitride);
        CraftingRecipeHandler.fissionFuelRecipes("Uranium", NCItems.pellet_uranium, NCItems.fuel_uranium, 238, 233, 235);
        CraftingRecipeHandler.fissionFuelRecipes("Neptunium", NCItems.pellet_neptunium, NCItems.fuel_neptunium, 237, 236);
        CraftingRecipeHandler.fissionFuelRecipes("Plutonium", NCItems.pellet_plutonium, NCItems.fuel_plutonium, 242, 239, 241);
        CraftingRecipeHandler.fissionFuelLowEnrichedRecipeAll(NCItems.pellet_mixed, 0, "Uranium238", "Plutonium239", new int[]{0, 1}, "", "Carbide");
        CraftingRecipeHandler.fissionFuelLowEnrichedRecipeAll(NCItems.fuel_mixed, 0, "Uranium238", "Plutonium239", new int[]{1, 2, 3}, "Oxide", "Nitride", "ZA");
        CraftingRecipeHandler.fissionFuelLowEnrichedRecipeAll(NCItems.pellet_mixed, 2, "Uranium238", "Plutonium241", new int[]{0, 1}, "", "Carbide");
        CraftingRecipeHandler.fissionFuelLowEnrichedRecipeAll(NCItems.fuel_mixed, 4, "Uranium238", "Plutonium241", new int[]{1, 2, 3}, "Oxide", "Nitride", "ZA");
        CraftingRecipeHandler.fissionFuelRecipes("Americium", NCItems.pellet_americium, NCItems.fuel_americium, 243, 242);
        CraftingRecipeHandler.fissionFuelRecipes("Curium", NCItems.pellet_curium, NCItems.fuel_curium, 246, 243, 245, 247);
        CraftingRecipeHandler.fissionFuelRecipes("Berkelium", NCItems.pellet_berkelium, NCItems.fuel_berkelium, 247, 248);
        CraftingRecipeHandler.fissionFuelRecipes("Californium", NCItems.pellet_californium, NCItems.fuel_californium, 252, 249, 251);
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.compound, 2, 1), "dustRhodochrosite", "dustCalciumSulfate", "dustObsidian", "dustMagnesium");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.compound, 2, 2), "dustRedstone", "dustGlowstone");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.compound, 2, 9), "dustObsidian", "dustObsidian", "dustObsidian", "dustObsidian", "dustEndstone");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.compound, 2, 10), "dustGraphite", "dustManganese");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.portable_ender_chest, " S ", "WCW", "LWL", Character.valueOf('C'), "chestEnder", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, 10), Character.valueOf('S'), "string", Character.valueOf('L'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.portable_ender_chest, " S ", "WCW", "LWL", Character.valueOf('C'), "chestEnder", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, 15), Character.valueOf('S'), "string", Character.valueOf('L'), "ingotTough");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.dominos, 4), Items.field_151025_P, Items.field_151025_P, Items.field_151025_P, Items.field_151157_am, Items.field_151083_be, Items.field_151077_bg, Items.field_179557_bn, Blocks.field_150338_P, Blocks.field_150338_P);
        CraftingRecipeHandler.addShapelessOreRecipe(Blocks.field_150338_P, NCBlocks.glowing_mushroom);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.glowing_mushroom, Blocks.field_150338_P, "dustGlowstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(Items.field_151106_aX, 8), "FCF", Character.valueOf('F'), "dustWheat", Character.valueOf('C'), "dustCocoa");
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.smore, NCItems.graham_cracker, "ingotChocolate", "ingotMarshmallow", NCItems.graham_cracker);
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.moresmore, NCItems.smore, "ingotChocolate", "ingotMarshmallow", NCItems.smore);
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.foursmore, NCItems.moresmore, "ingotChocolate", "ingotMarshmallow", NCItems.moresmore);
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.geiger_counter, "SFF", "CRR", "BFF", Character.valueOf('S'), "ingotSteel", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('C'), "ingotCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('B'), "bioplastic");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.radiation_badge, " C ", "SRS", " L ", Character.valueOf('C'), "ingotCopper", Character.valueOf('S'), "string", Character.valueOf('R'), "dustRedstone", Character.valueOf('L'), "ingotLead");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.rad_x, "EPE", "PRP", "PBP", Character.valueOf('E'), "dustEnergetic", Character.valueOf('P'), "bioplastic", Character.valueOf('R'), NCItems.radaway, Character.valueOf('B'), Items.field_151065_br);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.radiation_scrubber, "PCP", "CEC", "PCP", Character.valueOf('P'), "plateElite", Character.valueOf('E'), "ingotExtreme", Character.valueOf('C'), "dustBorax");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.geiger_block, " P ", "PGP", " P ", Character.valueOf('P'), "plateBasic", Character.valueOf('G'), NCItems.geiger_counter);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.rad_shielding, 1, 0), "III", "CCC", "LLL", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "coal", Character.valueOf('L'), "ingotLead");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.rad_shielding, 1, 1), "BBB", "RFR", "PPP", Character.valueOf('B'), "bioplastic", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('P'), "plateBasic", Character.valueOf('R'), new ItemStack(NCItems.rad_shielding, 1, 0));
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.rad_shielding, 1, 2), "BBB", "RHR", "PPP", Character.valueOf('B'), "ingotBeryllium", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('P'), "plateDU", Character.valueOf('R'), new ItemStack(NCItems.rad_shielding, 1, 1));
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.multitool), " F ", "HSF", "SB ", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('S'), "ingotSteel", Character.valueOf('B'), "ingotBronze");
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.record_wanderer, "record", "ingotTough");
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.record_end_of_the_world, "record", "ingotUranium235");
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.record_money_for_nothing, "record", "ingotSilver");
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.record_hyperspace, "record", "dustDimensional");
        CraftingRecipeHandler.addShapedOreRecipe(NCArmor.helm_hazmat, "YWY", "SLS", "BIB", Character.valueOf('Y'), "dyeYellow", Character.valueOf('W'), "wool", Character.valueOf('L'), Items.field_151024_Q, Character.valueOf('B'), "bioplastic", Character.valueOf('I'), "ingotSteel", Character.valueOf('S'), new ItemStack(NCItems.rad_shielding, 1, 2));
        CraftingRecipeHandler.addShapedOreRecipe(NCArmor.chest_hazmat, "WSW", "YLY", "SWS", Character.valueOf('Y'), "dyeYellow", Character.valueOf('W'), "wool", Character.valueOf('L'), Items.field_151027_R, Character.valueOf('S'), new ItemStack(NCItems.rad_shielding, 1, 2));
        CraftingRecipeHandler.addShapedOreRecipe(NCArmor.legs_hazmat, "YBY", "SLS", "W W", Character.valueOf('Y'), "dyeYellow", Character.valueOf('W'), "wool", Character.valueOf('L'), Items.field_151026_S, Character.valueOf('B'), "bioplastic", Character.valueOf('S'), new ItemStack(NCItems.rad_shielding, 1, 2));
        CraftingRecipeHandler.addShapedOreRecipe(NCArmor.boots_hazmat, "SDS", "BLB", Character.valueOf('D'), "dyeBlack", Character.valueOf('L'), Items.field_151021_T, Character.valueOf('B'), "bioplastic", Character.valueOf('S'), new ItemStack(NCItems.rad_shielding, 1, 2));
        if (NCConfig.register_quantum) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.quantum_computer_controller, "EPE", "PFP", "EPE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('P'), Items.field_151079_bi, Character.valueOf('F'), "steelFrame");
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.quantum_computer_qubit, "ESE", "PRP", "ESE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi, Character.valueOf('R'), "blockRedstone");
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 0), "SES", "EPE", "SES", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi);
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 1), "SES", "EPE", "ESE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi);
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 2), "SSS", "EPE", "SSS", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi);
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 3), "SES", "SPS", "SES", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi);
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 4), "ESS", "EPE", "SSE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi);
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 6), "SSS", "EPE", "ESE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi);
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 8), "SSS", "SPS", "SEE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 5), new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 4));
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 4), new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 5));
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 7), new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 6));
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 6), new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 7));
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 9), new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 0), Blocks.field_150429_aA);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 10), new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 1), Blocks.field_150429_aA);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 11), new ItemStack(NCBlocks.quantum_computer_gate_single, 1, 2), Blocks.field_150429_aA);
            for (i = 0; i < QuantumGateEnums.SingleType.values().length; ++i) {
                CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_control, 1, i), new ItemStack(NCBlocks.quantum_computer_gate_single, 1, i), "dustEnergetic");
            }
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 4), new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 5));
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 6), new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 7));
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 9), new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 0), Blocks.field_150429_aA);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 10), new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 1), Blocks.field_150429_aA);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 11), new ItemStack(NCBlocks.quantum_computer_gate_control, 1, 2), Blocks.field_150429_aA);
            for (int i2 : new int[]{0, 1, 2, 3, 4, 6, 8, 9, 10, 11}) {
                CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_single, 1, i2), new ItemStack(NCBlocks.quantum_computer_gate_control, 1, i2));
            }
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_swap, 1, 0), "EES", "EPE", "SEE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_swap, 1, 1), new ItemStack(NCBlocks.quantum_computer_gate_swap, 1, 0), "dustEnergetic");
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_gate_swap, 1, 0), new ItemStack(NCBlocks.quantum_computer_gate_swap, 1, 1));
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_connector, 8), "ESE", "S S", "ESE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel");
            CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.quantum_computer_code_generator, 1, 0), "ESE", "PBP", "ESE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Items.field_151079_bi, Character.valueOf('B'), Items.field_151099_bA);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_code_generator, 1, 0), new ItemStack(NCBlocks.quantum_computer_code_generator, 1, 1));
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.quantum_computer_code_generator, 1, 1), new ItemStack(NCBlocks.quantum_computer_code_generator, 1, 0));
        }
    }

    public static void registerRadShieldingCraftingRecipes() {
        if (NCConfig.radiation_shielding_default_recipes) {
            for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
                if (!ArmorHelper.isArmor(item, NCConfig.radiation_horse_armor_public)) continue;
                NonNullList stacks = NonNullList.func_191196_a();
                item.func_150895_a(CreativeTabs.field_78027_g, stacks);
                for (ItemStack stack : stacks) {
                    int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
                    if (RadArmor.ARMOR_STACK_SHIELDING_BLACKLIST.contains(packed)) continue;
                    RadArmor.addArmorShieldingRecipes(stack);
                }
            }
        }
        IntIterator intIterator = RadArmor.ARMOR_STACK_SHIELDING_LIST.iterator();
        while (intIterator.hasNext()) {
            int packed = (Integer)intIterator.next();
            RadArmor.addArmorShieldingRecipes(RecipeItemHelper.func_194115_b((int)packed));
        }
    }

    public static void fissionFuelRecipes(String element, Item pellet, Item fuel, int fertileNo, int ... fissileNo) {
        for (int i = 0; i < fissileNo.length; ++i) {
            CraftingRecipeHandler.fissionFuelLowEnrichedRecipeAll(pellet, 4 * i, element + fertileNo, element + fissileNo[i], new int[]{0, 1}, "", "Carbide");
            CraftingRecipeHandler.fissionFuelLowEnrichedRecipeAll(fuel, 8 * i, element + fertileNo, element + fissileNo[i], new int[]{1, 2, 3}, "Oxide", "Nitride", "ZA");
            CraftingRecipeHandler.fissionFuelHighlyEnrichedRecipeAll(pellet, 4 * i + 2, element + fertileNo, element + fissileNo[i], new int[]{0, 1}, "", "Carbide");
            CraftingRecipeHandler.fissionFuelHighlyEnrichedRecipeAll(fuel, 8 * i + 4, element + fertileNo, element + fissileNo[i], new int[]{1, 2, 3}, "Oxide", "Nitride", "ZA");
        }
    }

    public static void fissionFuelLowEnrichedRecipeAll(Item fuel, int startMeta, String fertile, String fissile, int[] offsets, String ... types) {
        for (int i = 0; i < offsets.length; ++i) {
            CraftingRecipeHandler.fissionFuelLowEnrichedRecipe(fuel, startMeta + offsets[i], fertile + types[i], fissile + types[i]);
        }
    }

    public static void fissionFuelHighlyEnrichedRecipeAll(Item fuel, int startMeta, String fertile, String fissile, int[] offsets, String ... types) {
        for (int i = 0; i < offsets.length; ++i) {
            CraftingRecipeHandler.fissionFuelHighlyEnrichedRecipe(fuel, startMeta + offsets[i], fertile + types[i], fissile + types[i]);
        }
    }

    public static void fissionFuelLowEnrichedRecipe(Item fuel, int meta, String fertile, String fissile) {
        fertile = "ingot" + fertile;
        fissile = "ingot" + fissile;
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(fuel, 9, meta), fissile, fertile, fertile, fertile, fertile, fertile, fertile, fertile, fertile);
    }

    public static void fissionFuelHighlyEnrichedRecipe(Item fuel, int meta, String fertile, String fissile) {
        fertile = "ingot" + fertile;
        fissile = "ingot" + fissile;
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(fuel, 9, meta), fissile, fissile, fissile, fertile, fertile, fertile, fertile, fertile, fertile);
    }

    public static void blockCompress(Block blockOut, int metaOut, String itemOutOreName, Object itemIn) {
        CraftingRecipeHandler.addShapedOreRecipe(OreDictHelper.getPrioritisedCraftingStack(new ItemStack(blockOut, 1, metaOut), itemOutOreName), "III", "III", "III", Character.valueOf('I'), itemIn);
    }

    public static void blockOpen(Item itemOut, int metaOut, String itemOutOreName, Object itemIn) {
        CraftingRecipeHandler.addShapelessOreRecipe(OreDictHelper.getPrioritisedCraftingStack(new ItemStack(itemOut, 9, metaOut), itemOutOreName), itemIn);
    }

    public static void tools(Object material, Item sword, Item pick, Item shovel, Item axe, Item hoe, Item spaxelhoe) {
        CraftingRecipeHandler.addShapedOreRecipe(sword, "M", "M", "S", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(pick, "MMM", " S ", " S ", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(shovel, "M", "S", "S", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(axe, "MM", "MS", " S", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(axe, "MM", "SM", "S ", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(hoe, "MM", " S", " S", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(hoe, "MM", "S ", "S ", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(spaxelhoe, "ASP", "HIW", " I ", Character.valueOf('A'), axe, Character.valueOf('S'), shovel, Character.valueOf('P'), pick, Character.valueOf('H'), hoe, Character.valueOf('W'), sword, Character.valueOf('I'), "ingotIron");
    }

    public static void armor(Object material, Item helm, Item chest, Item legs, Item boots) {
        CraftingRecipeHandler.addShapedOreRecipe(helm, "MMM", "M M", Character.valueOf('M'), material);
        CraftingRecipeHandler.addShapedOreRecipe(chest, "M M", "MMM", "MMM", Character.valueOf('M'), material);
        CraftingRecipeHandler.addShapedOreRecipe(legs, "MMM", "M M", "M M", Character.valueOf('M'), material);
        CraftingRecipeHandler.addShapedOreRecipe(boots, "M M", "M M", Character.valueOf('M'), material);
    }

    public static void addShapedOreRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapedOreRecipe.class, out, inputs);
    }

    public static void addShapedEnergyRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapedEnergyRecipe.class, out, inputs);
    }

    public static void addShapedFluidRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapedFluidRecipe.class, out, inputs);
    }

    public static void addShapelessOreRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapelessOreRecipe.class, out, inputs);
    }

    public static void addShapelessFluidRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapelessFluidRecipe.class, out, inputs);
    }

    public static void addShapelessArmorUpgradeRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapelessArmorRadShieldingRecipe.class, out, inputs);
    }

    public static void registerRecipe(Class<? extends IRecipe> clazz, Object out, Object ... inputs) {
        if (out == null || Lists.newArrayList((Object[])inputs).contains(null)) {
            return;
        }
        ItemStack outStack = StackHelper.fixItemStack(out);
        if (!outStack.func_190926_b() && inputs != null) {
            String outName = StackHelper.stackPath(outStack);
            if (RECIPE_COUNT_MAP.containsKey((Object)outName)) {
                int count = RECIPE_COUNT_MAP.getInt((Object)outName);
                RECIPE_COUNT_MAP.put((Object)outName, count + 1);
                outName = outName + "_" + count;
            } else {
                RECIPE_COUNT_MAP.put((Object)outName, 1);
            }
            ResourceLocation location = new ResourceLocation("nuclearcraft", outName);
            try {
                IRecipe recipe = NCUtil.newInstance(clazz, location, outStack, inputs);
                recipe.setRegistryName(location);
                ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

