/*
 * Decompiled with CFR 0.152.
 */
package nc.tile;

import javax.annotation.Nullable;
import nc.block.tile.IDynamicState;
import nc.capability.radiation.source.IRadiationSource;
import nc.capability.radiation.source.RadiationSource;
import nc.tile.ITile;
import nc.util.NCMath;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class NCTile
extends TileEntity
implements ITile {
    private boolean isRedstonePowered = false;
    private boolean alternateComparator = false;
    private boolean redstoneControl = false;
    private final IRadiationSource radiation = new RadiationSource(0.0);

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.refreshIsRedstonePowered(this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
            this.updateComparatorOutputLevel();
        }
    }

    public TileEntity thisTile() {
        return this;
    }

    @Override
    public World getTileWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getTilePos() {
        return this.field_174879_c;
    }

    @Override
    public Block getTileBlockType() {
        return this.func_145838_q();
    }

    @Override
    public int getTileBlockMeta() {
        return this.func_145832_p();
    }

    @Override
    public IRadiationSource getRadiationSource() {
        return this.radiation;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145838_q() == null ? null : new TextComponentTranslation(this.func_145838_q().func_149732_F(), new Object[0]);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public final void markTileDirty() {
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.func_145832_p();
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    @Override
    public boolean getIsRedstonePowered() {
        return this.isRedstonePowered;
    }

    @Override
    public void setIsRedstonePowered(boolean isRedstonePowered) {
        this.isRedstonePowered = isRedstonePowered;
    }

    @Override
    public boolean getAlternateComparator() {
        return this.alternateComparator;
    }

    @Override
    public void setAlternateComparator(boolean alternate) {
        this.alternateComparator = alternate;
    }

    @Override
    public boolean getRedstoneControl() {
        return this.redstoneControl;
    }

    @Override
    public void setRedstoneControl(boolean redstoneControl) {
        this.redstoneControl = redstoneControl;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeAll(nbt);
        return nbt;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        nbt.func_74757_a("isRedstonePowered", this.isRedstonePowered);
        nbt.func_74757_a("alternateComparator", this.alternateComparator);
        nbt.func_74757_a("redstoneControl", this.redstoneControl);
        if (this.shouldSaveRadiation()) {
            this.writeRadiation(nbt);
        }
        return nbt;
    }

    public NBTTagCompound writeRadiation(NBTTagCompound nbt) {
        nbt.func_74780_a("radiationLevel", this.getRadiationSource().getRadiationLevel());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readAll(nbt);
    }

    public void readAll(NBTTagCompound nbt) {
        this.isRedstonePowered = nbt.func_74767_n("isRedstonePowered");
        this.alternateComparator = nbt.func_74767_n("alternateComparator");
        this.redstoneControl = nbt.func_74767_n("redstoneControl");
        if (this.shouldSaveRadiation()) {
            this.readRadiation(nbt);
        }
    }

    public void readRadiation(NBTTagCompound nbt) {
        if (nbt.func_74764_b("radiationLevel")) {
            this.getRadiationSource().setRadiationLevel(nbt.func_74769_h("radiationLevel"));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        if (this.func_145838_q() instanceof IDynamicState) {
            this.notifyBlockUpdate();
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return this.radiation != null;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)this.radiation;
        }
        return (T)super.getCapability(capability, side);
    }

    protected boolean hasCapabilityDefault(Capability<?> capability, @Nullable EnumFacing side) {
        return super.hasCapability(capability, side);
    }

    protected <T> T getCapabilityDefault(Capability<T> capability, @Nullable EnumFacing side) {
        return (T)super.getCapability(capability, side);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return NCMath.sq(16.0 * (double)FMLClientHandler.instance().getClient().field_71474_y.field_151451_c);
    }
}

