/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energy;

import gregtech.api.capability.GregtechCapabilities;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.tile.NCTile;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.energy.EnergyTileWrapper;
import nc.tile.internal.energy.EnergyTileWrapperGT;
import nc.util.NCMath;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public abstract class TileEnergy
extends NCTile
implements ITileEnergy,
IEnergySink,
IEnergySource {
    @Nonnull
    private final EnergyStorage storage;
    @Nonnull
    private EnergyConnection[] energyConnections;
    @Nonnull
    private final EnergyTileWrapper[] energySides;
    @Nonnull
    private final EnergyTileWrapperGT[] energySidesGT;
    private boolean ic2reg = false;

    public TileEnergy(long capacity, @Nonnull EnergyConnection[] energyConnections) {
        this(capacity, NCMath.toInt(capacity), energyConnections);
    }

    public TileEnergy(long capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections) {
        this.storage = new EnergyStorage(capacity, maxTransfer);
        this.energyConnections = energyConnections;
        this.energySides = ITileEnergy.getDefaultEnergySides(this);
        this.energySidesGT = ITileEnergy.getDefaultEnergySidesGT(this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public EnergyConnection[] getEnergyConnections() {
        return this.energyConnections;
    }

    @Override
    @Nonnull
    public EnergyTileWrapper[] getEnergySides() {
        return this.energySides;
    }

    @Override
    @Nonnull
    public EnergyTileWrapperGT[] getEnergySidesGT() {
        return this.energySidesGT;
    }

    @Override
    public boolean getIC2Reg() {
        return this.ic2reg;
    }

    @Override
    public void setIC2Reg(boolean ic2reg) {
        this.ic2reg = ic2reg;
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return ITileEnergy.super.acceptsEnergyFrom(emitter, side);
    }

    @Override
    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return ITileEnergy.super.getDemandedEnergy();
    }

    @Override
    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return ITileEnergy.super.injectEnergy(directionFrom, amount, voltage);
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return ITileEnergy.super.emitsEnergyTo(receiver, side);
    }

    @Override
    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return ITileEnergy.super.getOfferedEnergy();
    }

    @Override
    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        ITileEnergy.super.drawEnergy(amount);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeEnergy(nbt);
        this.writeEnergyConnections(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readEnergy(nbt);
        this.readEnergyConnections(nbt);
    }

    public void setEnergyConnectionAll(EnergyConnection energyConnection) {
        this.energyConnections = ITileEnergy.energyConnectionAll(energyConnection);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY || ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return this.hasEnergySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.hasEnergySideCapability(side)) {
                return (T)this.getEnergySide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            if (NCConfig.enable_gtce_eu && this.hasEnergySideCapability(side)) {
                return (T)this.getEnergySideGT(this.nonNullSide(side));
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

