/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.fluid;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import nc.multiblock.tile.port.ITilePort;
import nc.tile.ITile;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.tile.processor.IProcessor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public interface ITileFluid
extends ITile {
    @Nonnull
    public List<Tank> getTanks();

    default public boolean isNextToFill(@Nonnull EnumFacing side, int tankNumber, FluidStack resource) {
        if (!this.getInputTanksSeparated()) {
            return true;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (i == tankNumber || !this.getTankSorption(side, i).canFill() || this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    default public void clearTank(int tankNumber) {
        this.getTanks().get(tankNumber).setFluidStored(null);
    }

    default public void clearAllTanks() {
        for (Tank tank : this.getTanks()) {
            tank.setFluidStored(null);
        }
    }

    @Nonnull
    public FluidConnection[] getFluidConnections();

    public void setFluidConnections(@Nonnull FluidConnection[] var1);

    @Nonnull
    default public FluidConnection getFluidConnection(@Nonnull EnumFacing side) {
        return this.getFluidConnections()[side.func_176745_a()];
    }

    @Nonnull
    default public TankSorption getTankSorption(@Nonnull EnumFacing side, int tankNumber) {
        return this.getFluidConnections()[side.func_176745_a()].getTankSorption(tankNumber);
    }

    default public void setTankSorption(@Nonnull EnumFacing side, int tankNumber, @Nonnull TankSorption sorption) {
        this.getFluidConnections()[side.func_176745_a()].setTankSorption(tankNumber, sorption);
    }

    default public void toggleTankSorption(@Nonnull EnumFacing side, int tankNumber, TankSorption.Type type, boolean reverse) {
        if (!this.hasConfigurableFluidConnections()) {
            return;
        }
        this.getFluidConnection(side).toggleTankSorption(tankNumber, type, reverse);
        this.markDirtyAndNotify(true);
    }

    default public boolean canConnectFluid(@Nonnull EnumFacing side) {
        return this.getFluidConnection(side).canConnect();
    }

    public static FluidConnection[] fluidConnectionAll(@Nonnull List<TankSorption> sorptionList) {
        FluidConnection[] array = new FluidConnection[6];
        for (int i = 0; i < 6; ++i) {
            array[i] = new FluidConnection(sorptionList);
        }
        return array;
    }

    public static FluidConnection[] fluidConnectionAll(TankSorption sorption) {
        return ITileFluid.fluidConnectionAll(Lists.newArrayList((Object[])new TankSorption[]{sorption}));
    }

    default public boolean hasConfigurableFluidConnections() {
        return false;
    }

    @Nonnull
    default public IFluidTankProperties[] getTankProperties(@Nonnull EnumFacing side) {
        if (this.getTanks().isEmpty()) {
            return EmptyFluidHandler.EMPTY_TANK_PROPERTIES_ARRAY;
        }
        IFluidTankProperties[] properties = new IFluidTankProperties[this.getTanks().size()];
        for (int i = 0; i < this.getTanks().size(); ++i) {
            properties[i] = this.getTanks().get(i).getFluidTankProperties();
        }
        return properties;
    }

    default public int fill(@Nonnull EnumFacing side, FluidStack resource, boolean doFill) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTankSorption(side, i).canFill() || !this.getTanks().get(i).canFillFluidType(resource) || !this.isNextToFill(side, i, resource) || this.getTanks().get(i).getFluidAmount() >= this.getTanks().get(i).getCapacity() || this.getTanks().get(i).getFluid() != null && !this.getTanks().get(i).getFluid().isFluidEqual(resource)) continue;
            return this.getTanks().get(i).fill(resource, doFill);
        }
        return 0;
    }

    default public FluidStack drain(@Nonnull EnumFacing side, FluidStack resource, boolean doDrain) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTankSorption(side, i).canDrain() || this.getTanks().get(i).getFluidAmount() <= 0 || !resource.isFluidEqual(this.getTanks().get(i).getFluid()) || this.getTanks().get(i).drain(resource, false) == null || this.getTanks().get(i).drain(resource, false) == null) continue;
            return this.getTanks().get(i).drain(resource, doDrain);
        }
        return null;
    }

    default public FluidStack drain(@Nonnull EnumFacing side, int maxDrain, boolean doDrain) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTankSorption(side, i).canDrain() || this.getTanks().get(i).getFluidAmount() <= 0 || this.getTanks().get(i).drain(maxDrain, false) == null || this.getTanks().get(i).drain(maxDrain, false) == null) continue;
            return this.getTanks().get(i).drain(maxDrain, doDrain);
        }
        return null;
    }

    @Nonnull
    public FluidTileWrapper[] getFluidSides();

    @Nonnull
    default public FluidTileWrapper getFluidSide(@Nonnull EnumFacing side) {
        return this.getFluidSides()[side.func_176745_a()];
    }

    @Nonnull
    public static FluidTileWrapper[] getDefaultFluidSides(@Nonnull ITileFluid tile) {
        return new FluidTileWrapper[]{new FluidTileWrapper(tile, EnumFacing.DOWN), new FluidTileWrapper(tile, EnumFacing.UP), new FluidTileWrapper(tile, EnumFacing.NORTH), new FluidTileWrapper(tile, EnumFacing.SOUTH), new FluidTileWrapper(tile, EnumFacing.WEST), new FluidTileWrapper(tile, EnumFacing.EAST)};
    }

    default public void onWrapperFill(int fillAmount, boolean doFill) {
        if (doFill && fillAmount != 0) {
            if (this instanceof IProcessor) {
                ((IProcessor)((Object)this)).refreshRecipe();
                ((IProcessor)((Object)this)).refreshActivity();
            }
            if (this instanceof ITilePort) {
                ((ITilePort)((Object)this)).setRefreshTargetsFlag(true);
            }
        }
    }

    default public void onWrapperDrain(FluidStack drainStack, boolean doDrain) {
        if (doDrain && drainStack != null && drainStack.amount != 0) {
            if (this instanceof IProcessor) {
                ((IProcessor)((Object)this)).refreshActivity();
            }
            if (this instanceof ITilePort) {
                ((ITilePort)((Object)this)).setRefreshTargetsFlag(true);
            }
        }
    }

    default public void onWrapperReceiveGas(int receiveAmount, boolean doTransfer) {
        if (doTransfer && receiveAmount != 0) {
            if (this instanceof IProcessor) {
                ((IProcessor)((Object)this)).refreshRecipe();
                ((IProcessor)((Object)this)).refreshActivity();
            }
            if (this instanceof ITilePort) {
                ((ITilePort)((Object)this)).setRefreshTargetsFlag(true);
            }
        }
    }

    default public void onWrapperDrawGas(GasStack drawStack, boolean doTransfer) {
        if (doTransfer && drawStack != null && drawStack.amount != 0) {
            if (this instanceof IProcessor) {
                ((IProcessor)((Object)this)).refreshActivity();
            }
            if (this instanceof ITilePort) {
                ((ITilePort)((Object)this)).setRefreshTargetsFlag(true);
            }
        }
    }

    @Nonnull
    public GasTileWrapper getGasWrapper();

    default public void pushFluid() {
        if (this.getTanks().isEmpty()) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.pushFluidToSide(side);
        }
    }

    default public void pushFluidToSide(@Nonnull EnumFacing side) {
        if (!this.getFluidConnection(side).canConnect()) {
            return;
        }
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null || tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
            return;
        }
        IFluidHandler adjStorage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjStorage == null) {
            return;
        }
        boolean drained = false;
        for (int i = 0; i < this.getTanks().size(); ++i) {
            FluidStack drain;
            if (!this.getTankSorption(side, i).canDrain() || this.getTanks().get(i).getFluid() == null || (drain = this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true)) == null || drain.amount == 0) continue;
            drained = true;
        }
        if (drained) {
            if (this instanceof IProcessor) {
                ((IProcessor)((Object)this)).refreshActivity();
            }
            if (this instanceof ITilePort) {
                ((ITilePort)((Object)this)).setRefreshTargetsFlag(true);
            }
        }
    }

    default public NBTTagCompound writeTanks(NBTTagCompound nbt) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).writeToNBT(nbt, "tanks" + i);
        }
        return nbt;
    }

    default public void readTanks(NBTTagCompound nbt) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).readFromNBT(nbt, "tanks" + i);
        }
    }

    default public NBTTagCompound writeFluidConnections(NBTTagCompound nbt) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.getFluidConnection(side).writeToNBT(nbt, side);
        }
        return nbt;
    }

    default public void readFluidConnections(NBTTagCompound nbt) {
        if (!this.hasConfigurableFluidConnections()) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.getFluidConnection(side).readFromNBT(nbt, side);
        }
    }

    default public NBTTagCompound writeTankSettings(NBTTagCompound nbt) {
        nbt.func_74757_a("inputTanksSeparated", this.getInputTanksSeparated());
        for (int i = 0; i < this.getTanks().size(); ++i) {
            nbt.func_74757_a("voidUnusableFluidInput" + i, this.getVoidUnusableFluidInput(i));
            nbt.func_74768_a("tankOutputSetting" + i, this.getTankOutputSetting(i).ordinal());
        }
        return nbt;
    }

    default public void readTankSettings(NBTTagCompound nbt) {
        this.setInputTanksSeparated(nbt.func_74767_n("inputTanksSeparated"));
        for (int i = 0; i < this.getTanks().size(); ++i) {
            this.setVoidUnusableFluidInput(i, nbt.func_74767_n("voidUnusableFluidInput" + i));
            int ordinal = nbt.func_74764_b("voidExcessFluidOutput" + i) ? (nbt.func_74767_n("voidExcessFluidOutput" + i) ? 1 : 0) : nbt.func_74762_e("tankOutputSetting" + i);
            this.setTankOutputSetting(i, TankOutputSetting.values()[ordinal]);
        }
    }

    public boolean getInputTanksSeparated();

    public void setInputTanksSeparated(boolean var1);

    public boolean getVoidUnusableFluidInput(int var1);

    public void setVoidUnusableFluidInput(int var1, boolean var2);

    public TankOutputSetting getTankOutputSetting(int var1);

    public void setTankOutputSetting(int var1, TankOutputSetting var2);

    default public boolean hasFluidSideCapability(@Nullable EnumFacing side) {
        return side == null || this.getFluidConnection(side).canConnect();
    }
}

