/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.fluid;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.tile.fluid.TileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.inventory.ITileInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileFluidInventory
extends TileFluid
implements ITileInventory {
    @Nonnull
    private final String inventoryName;
    @Nonnull
    private final NonNullList<ItemStack> inventoryStacks;
    @Nonnull
    private InventoryConnection[] inventoryConnections;
    @Nonnull
    private final List<ItemOutputSetting> itemOutputSettings;

    public TileFluidInventory(String name, int size, @Nonnull InventoryConnection[] inventoryConnections, int capacity, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(name, size, inventoryConnections, (IntList)new IntArrayList(new int[]{capacity}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileFluidInventory(String name, int size, @Nonnull InventoryConnection[] inventoryConnections, @Nonnull IntList capacity, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        super(capacity, allowedFluidsLists, fluidConnections);
        this.inventoryName = "nuclearcraft.container." + name;
        this.inventoryStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.inventoryConnections = inventoryConnections;
        this.itemOutputSettings = new ArrayList<ItemOutputSetting>();
        for (int i = 0; i < size; ++i) {
            this.itemOutputSettings.add(ItemOutputSetting.DEFAULT);
        }
    }

    @Override
    public String func_70005_c_() {
        return this.inventoryName;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks() {
        return this.inventoryStacks;
    }

    @Override
    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    @Override
    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    @Override
    public ItemOutputSetting getItemOutputSetting(int slot) {
        return this.itemOutputSettings.get(slot);
    }

    @Override
    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
        this.itemOutputSettings.set(slot, setting);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        this.writeSlotSettings(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
        this.readSlotSettings(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandler(null);
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

