/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.Random;
import nc.config.NCConfig;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeHelper;
import nc.recipe.RecipeStats;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energy.ITileEnergy;
import nc.tile.energy.TileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.util.EnergyHelper;
import nc.util.StackHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileDecayGenerator
extends TileEnergy
implements ITickable,
IInterfaceable {
    Random rand = new Random();
    public int tickCount;
    protected BasicRecipe[] recipes = new BasicRecipe[6];
    protected int generatorCount;

    public TileDecayGenerator() {
        super(2 * RecipeStats.getDecayGeneratorMaxPower(), ITileEnergy.energyConnectionAll(EnergyConnection.OUT));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.refreshRecipe(side);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tickGenerator();
            if (this.generatorCount == 0) {
                this.getEnergyStorage().changeEnergyStored(this.getGenerated());
                this.getRadiationSource().setRadiationLevel(this.getRadiation());
            }
            this.pushEnergy();
        }
    }

    public void tickGenerator() {
        ++this.generatorCount;
        this.generatorCount %= NCConfig.machine_update_rate;
    }

    public int getGenerated() {
        double power = 0.0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            power += this.decayGen(side);
        }
        return (int)((double)NCConfig.machine_update_rate * power);
    }

    public double getRadiation() {
        double radiation = 0.0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.getDecayRecipe(side) == null) continue;
            radiation += this.getDecayRecipe(side).getDecayGeneratorRadiation();
        }
        return (double)NCConfig.machine_update_rate * radiation;
    }

    public double decayGen(EnumFacing side) {
        if (this.getDecayRecipe(side) == null) {
            return 0.0;
        }
        ItemStack stack = this.getOutput(side);
        if (stack == null || stack.func_190926_b()) {
            return 0.0;
        }
        if (this.rand.nextDouble() * this.getRecipeLifetime(side) / (double)NCConfig.machine_update_rate < 1.0) {
            IBlockState block = StackHelper.getBlockStateFromStack(stack);
            if (block == null) {
                return 0.0;
            }
            this.func_145831_w().func_175656_a(this.field_174879_c.func_177972_a(side), block);
            this.refreshRecipe(side);
        }
        return this.getRecipePower(side);
    }

    @Override
    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        super.onBlockNeighborChanged(state, world, pos, fromPos);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.refreshRecipe(side);
        }
    }

    public void refreshRecipe(EnumFacing side) {
        this.recipes[side.func_176745_a()] = RecipeHelper.blockRecipe(NCRecipes.decay_generator, this.field_145850_b, this.field_174879_c.func_177972_a(side));
    }

    @Override
    public int getSinkTier() {
        return 10;
    }

    @Override
    public int getSourceTier() {
        return EnergyHelper.getEUTier(RecipeStats.getDecayGeneratorMaxPower());
    }

    public BasicRecipe getDecayRecipe(EnumFacing side) {
        return this.recipes[side.func_176745_a()];
    }

    public double getRecipeLifetime(EnumFacing side) {
        if (this.getDecayRecipe(side) == null) {
            return 1200.0;
        }
        return this.getDecayRecipe(side).getDecayGeneratorLifetime();
    }

    public double getRecipePower(EnumFacing side) {
        if (this.getDecayRecipe(side) == null) {
            return 0.0;
        }
        return this.getDecayRecipe(side).getDecayGeneratorPower();
    }

    public ItemStack getOutput(EnumFacing side) {
        if (this.getDecayRecipe(side) == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = RecipeHelper.getItemStackFromIngredientList(this.getDecayRecipe(side).getItemProducts(), 0);
        return output != null ? output : ItemStack.field_190927_a;
    }
}

