/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.generator.IFluidGenerator;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileFluidGenerator
extends TileEnergyFluidSidedInventory
implements IFluidGenerator {
    protected final int defaultProcessTime;
    protected final int defaultProcessPower;
    public double baseProcessTime = 1.0;
    public double baseProcessPower = 0.0;
    public double baseProcessRadiation = 0.0;
    public double processPower = 0.0;
    protected double speedMultiplier = 1.0;
    protected final int fluidInputSize;
    protected final int fluidOutputSize;
    protected final int otherSlotsSize;
    @Nonnull
    protected final List<Tank> consumedTanks = new ArrayList<Tank>();
    public double time;
    protected boolean isProcessing;
    protected boolean hasConsumed;
    protected boolean canProcessInputs;
    protected final BasicRecipeHandler recipeHandler;
    protected RecipeInfo<BasicRecipe> recipeInfo;
    protected Set<EntityPlayer> playersToUpdate;

    public TileFluidGenerator(String name, int fluidInSize, int fluidOutSize, int otherSize, @Nonnull List<ItemSorption> itemSorptions, @Nonnull IntList fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int capacity, @Nonnull BasicRecipeHandler recipeHandler) {
        super(name, otherSize, ITileInventory.inventoryConnectionAll(itemSorptions), (long)capacity, ITileEnergy.energyConnectionAll(EnergyConnection.OUT), fluidCapacity, allowedFluids, ITileFluid.fluidConnectionAll(tankSorptions));
        this.fluidInputSize = fluidInSize;
        this.fluidOutputSize = fluidOutSize;
        this.otherSlotsSize = otherSize;
        this.setInputTanksSeparated(fluidInSize > 1);
        for (int i = 0; i < fluidInSize; ++i) {
            this.consumedTanks.add(new Tank(fluidCapacity.getInt(i), new ArrayList<String>()));
        }
        this.defaultProcessTime = 1;
        this.defaultProcessPower = 0;
        this.recipeHandler = recipeHandler;
        this.playersToUpdate = new ObjectOpenHashSet();
    }

    public static List<ItemSorption> defaultItemSorptions(ItemSorption ... others) {
        ArrayList<ItemSorption> itemSorptions = new ArrayList<ItemSorption>();
        for (ItemSorption other : others) {
            itemSorptions.add(other);
        }
        return itemSorptions;
    }

    public static IntList defaultTankCapacities(int capacity, int inSize, int outSize) {
        IntArrayList tankCapacities = new IntArrayList();
        for (int i = 0; i < inSize + outSize; ++i) {
            tankCapacities.add(capacity);
        }
        return tankCapacities;
    }

    public static List<TankSorption> defaultTankSorptions(int inSize, int outSize) {
        int i;
        ArrayList<TankSorption> tankSorptions = new ArrayList<TankSorption>();
        for (i = 0; i < inSize; ++i) {
            tankSorptions.add(TankSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            tankSorptions.add(TankSorption.OUT);
        }
        return tankSorptions;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
            this.hasConsumed = this.hasConsumed();
        }
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = this.recipeHandler.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs(this.hasConsumed));
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs();
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public abstract boolean setRecipeStats();

    public boolean isProcessing() {
        return this.readyToProcess() && this.getIsRedstonePowered();
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed;
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            if (this.consumedTanks.get(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs() {
        boolean canProcess;
        boolean validRecipe = this.setRecipeStats();
        boolean bl = canProcess = validRecipe && this.canProduceProducts();
        if (this.hasConsumed && !validRecipe) {
            for (Tank tank : this.getFluidInputs(true)) {
                tank.setFluidStored(null);
            }
            this.hasConsumed = false;
        }
        if (!canProcess) {
            this.time = MathHelper.func_151237_a((double)this.time, (double)0.0, (double)(this.baseProcessTime - 1.0));
        }
        return canProcess;
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            if (this.getTankOutputSetting(j + this.fluidInputSize) == TankOutputSetting.VOID) {
                this.clearTank(j + this.fluidInputSize);
                continue;
            }
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) continue;
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.getTankOutputSetting(j + this.fluidInputSize) != TankOutputSetting.DEFAULT || this.getTanks().get(j + this.fluidInputSize).getFluidAmount() + fluidProduct.getMaxStackSize(0) <= this.getTanks().get(j + this.fluidInputSize).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        IntList fluidInputOrder = this.recipeInfo.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            if (this.consumedTanks.get(i).isEmpty()) continue;
            this.consumedTanks.get(i).setFluid(null);
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            int maxStackSize = this.getFluidIngredients().get((Integer)fluidInputOrder.get(i)).getMaxStackSize((Integer)this.recipeInfo.getFluidIngredientNumbers().get(i));
            if (maxStackSize > 0) {
                this.consumedTanks.get(i).setFluidStored(new FluidStack(this.getTanks().get(i).getFluid(), maxStackSize));
                this.getTanks().get(i).changeFluidAmount(-maxStackSize);
            }
            if (!this.getTanks().get(i).isEmpty()) continue;
            this.getTanks().get(i).setFluid(null);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += this.speedMultiplier;
        this.getEnergyStorage().changeEnergyStored((int)this.processPower);
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.speedMultiplier);
        while (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        this.time = Math.max(0.0, this.time - oldProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
            for (int i = 0; i < this.fluidInputSize; ++i) {
                if (!this.getVoidUnusableFluidInput(i)) continue;
                this.getTanks().get(i).setFluid(null);
            }
        }
    }

    public void produceProducts() {
        for (int i = 0; i < this.fluidInputSize; ++i) {
            this.consumedTanks.get(i).setFluid(null);
        }
        if (!this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            if (this.getTankOutputSetting(j + this.fluidInputSize) == TankOutputSetting.VOID) {
                this.clearTank(j + this.fluidInputSize);
                continue;
            }
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getNextStackSize(0) <= 0) continue;
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) {
                this.getTanks().get(j + this.fluidInputSize).setFluidStored(fluidProduct.getNextStack(0));
                continue;
            }
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) continue;
            this.getTanks().get(j + this.fluidInputSize).changeFluidAmount(fluidProduct.getNextStackSize(0));
        }
        this.hasConsumed = false;
    }

    @Override
    public int getFluidInputSize() {
        return this.fluidInputSize;
    }

    @Override
    public int getFluidOutputputSize() {
        return this.fluidOutputSize;
    }

    @Override
    public int getOtherSlotsSize() {
        return this.otherSlotsSize;
    }

    @Override
    public List<Tank> getFluidInputs(boolean consumed) {
        return consumed ? this.consumedTanks : this.getTanks().subList(0, this.fluidInputSize);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipeInfo.getRecipe().getFluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipeInfo.getRecipe().getFluidProducts();
    }

    @Override
    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshActivity();
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return super.func_180462_a(slot, stack, side);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return super.func_180461_b(slot, stack, side);
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
    }

    @Override
    public NBTTagCompound writeTanks(NBTTagCompound nbt) {
        super.writeTanks(nbt);
        for (int i = 0; i < this.consumedTanks.size(); ++i) {
            this.consumedTanks.get(i).writeToNBT(nbt, "consumedTanks" + i);
        }
        return nbt;
    }

    @Override
    public void readTanks(NBTTagCompound nbt) {
        super.readTanks(nbt);
        for (int i = 0; i < this.consumedTanks.size(); ++i) {
            this.consumedTanks.get(i).readFromNBT(nbt, "consumedTanks" + i);
        }
    }
}

