/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import nc.config.NCConfig;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.energy.ITileEnergy;
import nc.tile.energy.TileEnergySidedInventory;
import nc.tile.generator.IItemGenerator;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.util.NBTHelper;
import nc.util.StackHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;

public abstract class TileItemGenerator
extends TileEnergySidedInventory
implements IItemGenerator {
    protected final int defaultProcessTime;
    protected final int defaultProcessPower;
    public double baseProcessTime = 1.0;
    public double baseProcessPower = 0.0;
    public double baseProcessRadiation = 0.0;
    public double processPower = 0.0;
    protected double speedMultiplier = 1.0;
    protected final int itemInputSize;
    protected final int itemOutputSize;
    protected final int otherSlotsSize;
    @Nonnull
    protected final NonNullList<ItemStack> consumedStacks;
    public double time;
    protected boolean isProcessing;
    protected boolean hasConsumed;
    protected boolean canProcessInputs;
    protected final BasicRecipeHandler recipeHandler;
    protected RecipeInfo<BasicRecipe> recipeInfo;
    protected Set<EntityPlayer> playersToUpdate;

    public TileItemGenerator(String name, int itemInSize, int itemOutSize, int otherSize, @Nonnull List<ItemSorption> itemSorptions, int capacity, @Nonnull BasicRecipeHandler recipeHandler) {
        super(name, itemInSize + itemOutSize + otherSize, ITileInventory.inventoryConnectionAll(itemSorptions), capacity, ITileEnergy.energyConnectionAll(EnergyConnection.OUT));
        this.itemInputSize = itemInSize;
        this.itemOutputSize = itemOutSize;
        this.otherSlotsSize = otherSize;
        this.consumedStacks = NonNullList.func_191197_a((int)itemInSize, (Object)ItemStack.field_190927_a);
        this.defaultProcessTime = 1;
        this.defaultProcessPower = 0;
        this.recipeHandler = recipeHandler;
        this.playersToUpdate = new ObjectOpenHashSet();
    }

    public static List<ItemSorption> defaultItemSorptions(int inSize, int outSize, ItemSorption ... others) {
        int i;
        ArrayList<ItemSorption> itemSorptions = new ArrayList<ItemSorption>();
        for (i = 0; i < inSize; ++i) {
            itemSorptions.add(ItemSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            itemSorptions.add(ItemSorption.OUT);
        }
        for (ItemSorption other : others) {
            itemSorptions.add(other);
        }
        return itemSorptions;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K && !this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
            this.hasConsumed = this.hasConsumed();
        }
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = this.recipeHandler.getRecipeInfoFromInputs(this.getItemInputs(this.hasConsumed), new ArrayList<Tank>());
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs();
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public abstract boolean setRecipeStats();

    public boolean isProcessing() {
        return this.readyToProcess() && this.getIsRedstonePowered();
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed;
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < this.itemInputSize; ++i) {
            if (((ItemStack)this.consumedStacks.get(i)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs() {
        boolean canProcess;
        boolean validRecipe = this.setRecipeStats();
        boolean bl = canProcess = validRecipe && this.canProduceProducts();
        if (this.hasConsumed && !validRecipe) {
            for (int i = 0; i < this.itemInputSize; ++i) {
                this.getItemInputs(true).set(i, ItemStack.field_190927_a);
            }
            this.hasConsumed = false;
        }
        if (!canProcess) {
            this.time = MathHelper.func_151237_a((double)this.time, (double)0.0, (double)(this.baseProcessTime - 1.0));
        }
        return canProcess;
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < this.itemOutputSize; ++j) {
            if (this.getItemOutputSetting(j + this.itemInputSize) == ItemOutputSetting.VOID) {
                this.getInventoryStacks().set(j + this.itemInputSize, (Object)ItemStack.field_190927_a);
                continue;
            }
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getMaxStackSize(0) <= 0) continue;
            if (itemProduct.getStack() == null || ((ItemStack)itemProduct.getStack()).func_190926_b()) {
                return false;
            }
            if (((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190926_b()) continue;
            if (!((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_77969_a((ItemStack)itemProduct.getStack())) {
                return false;
            }
            if (this.getItemOutputSetting(j + this.itemInputSize) != ItemOutputSetting.DEFAULT || ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190916_E() + itemProduct.getMaxStackSize(0) <= ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        IntList itemInputOrder = this.recipeInfo.getItemInputOrder();
        if (itemInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < this.itemInputSize; ++i) {
            if (((ItemStack)this.consumedStacks.get(i)).func_190926_b()) continue;
            this.consumedStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < this.itemInputSize; ++i) {
            int maxStackSize = this.getItemIngredients().get((Integer)itemInputOrder.get(i)).getMaxStackSize((Integer)this.recipeInfo.getItemIngredientNumbers().get(i));
            if (maxStackSize > 0) {
                this.consumedStacks.set(i, (Object)new ItemStack(((ItemStack)this.getInventoryStacks().get(i)).func_77973_b(), maxStackSize, StackHelper.getMetadata((ItemStack)this.getInventoryStacks().get(i))));
                ((ItemStack)this.getInventoryStacks().get(i)).func_190918_g(maxStackSize);
            }
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190916_E() > 0) continue;
            this.getInventoryStacks().set(i, (Object)ItemStack.field_190927_a);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += this.speedMultiplier;
        this.getEnergyStorage().changeEnergyStored((int)this.processPower);
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.speedMultiplier);
        while (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        this.time = Math.max(0.0, this.time - oldProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        for (int i = 0; i < this.itemInputSize; ++i) {
            this.consumedStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        if (!this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        for (int j = 0; j < this.itemOutputSize; ++j) {
            if (this.getItemOutputSetting(j + this.itemInputSize) == ItemOutputSetting.VOID) {
                this.getInventoryStacks().set(j + this.itemInputSize, (Object)ItemStack.field_190927_a);
                continue;
            }
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getNextStackSize(0) <= 0) continue;
            if (((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190926_b()) {
                this.getInventoryStacks().set(j + this.itemInputSize, (Object)itemProduct.getNextStack(0));
                continue;
            }
            if (!((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_77969_a((ItemStack)itemProduct.getStack())) continue;
            int count = Math.min(this.func_70297_j_(), ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190916_E() + itemProduct.getNextStackSize(0));
            ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190920_e(count);
        }
        this.hasConsumed = false;
    }

    @Override
    public int getItemInputSize() {
        return this.itemInputSize;
    }

    @Override
    public int getItemOutputSize() {
        return this.itemOutputSize;
    }

    @Override
    public int getOtherSlotsSize() {
        return this.otherSlotsSize;
    }

    @Override
    public List<ItemStack> getItemInputs(boolean consumed) {
        return consumed ? this.consumedStacks : this.getInventoryStacks().subList(0, this.itemInputSize);
    }

    @Override
    public List<IItemIngredient> getItemIngredients() {
        return this.recipeInfo.getRecipe().getItemIngredients();
    }

    @Override
    public List<IItemIngredient> getItemProducts() {
        return this.recipeInfo.getRecipe().getItemProducts();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.itemInputSize) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < this.itemInputSize + this.itemOutputSize) {
                this.refreshActivity();
            }
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.itemInputSize) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < this.itemInputSize + this.itemOutputSize) {
                this.refreshActivity();
            }
        }
    }

    @Override
    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshActivity();
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot >= this.itemInputSize && slot < this.itemInputSize + this.itemOutputSize) {
            return false;
        }
        return NCConfig.smart_processor_input ? this.recipeHandler.isValidItemInput(stack, (ItemStack)this.getInventoryStacks().get(slot), this.inputItemStacksExcludingSlot(slot)) : this.recipeHandler.isValidItemInput(stack);
    }

    public List<ItemStack> inputItemStacksExcludingSlot(int slot) {
        ArrayList<ItemStack> inputItemsExcludingSlot = new ArrayList<ItemStack>(this.getItemInputs(false));
        inputItemsExcludingSlot.remove(slot);
        return inputItemsExcludingSlot;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return super.func_180462_a(slot, stack, side) && this.func_94041_b(slot, stack);
    }

    @Override
    public boolean hasConfigurableInventoryConnections() {
        return true;
    }

    @Override
    public void clearAllSlots() {
        IItemGenerator.super.clearAllSlots();
        for (int i = 0; i < this.consumedStacks.size(); ++i) {
            this.consumedStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.refreshRecipe();
        this.refreshActivity();
        this.isProcessing = this.isProcessing();
        this.hasConsumed = this.hasConsumed();
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
    }

    @Override
    public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        NBTHelper.writeAllItems(nbt, new List[]{this.getInventoryStacks(), this.consumedStacks});
        return nbt;
    }

    @Override
    public void readInventory(NBTTagCompound nbt) {
        NBTHelper.readAllItems(nbt, new List[]{this.getInventoryStacks(), this.consumedStacks});
    }
}

