/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import nc.ModCheck;
import nc.init.NCItems;
import nc.network.tile.ProcessorUpdatePacket;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.ITileGui;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.tile.processor.IFluidProcessor;
import nc.tile.processor.IProcessor;
import nc.tile.processor.IUpgradable;
import nc.util.StackHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class TileFluidProcessor
extends TileEnergyFluidSidedInventory
implements IFluidProcessor,
ITileGui<ProcessorUpdatePacket>,
IUpgradable {
    public final int defaultProcessTime;
    public final int defaultProcessPower;
    public double baseProcessTime;
    public double baseProcessPower;
    public double baseProcessRadiation;
    protected final int fluidInputSize;
    protected final int fluidOutputSize;
    public double time;
    public double resetTime;
    public boolean isProcessing;
    public boolean canProcessInputs;
    public final boolean shouldLoseProgress;
    public final boolean hasUpgrades;
    public final int processorID;
    public final int sideConfigYOffset;
    public final BasicRecipeHandler recipeHandler;
    protected RecipeInfo<BasicRecipe> recipeInfo;
    protected Set<EntityPlayer> playersToUpdate;

    public TileFluidProcessor(String name, int fluidInSize, int fluidOutSize, @Nonnull List<ItemSorption> itemSorptions, @Nonnull IntList fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int time, int power, boolean shouldLoseProgress, @Nonnull BasicRecipeHandler recipeHandler, int processorID, int sideConfigYOffset) {
        this(name, fluidInSize, fluidOutSize, itemSorptions, fluidCapacity, tankSorptions, allowedFluids, time, power, shouldLoseProgress, true, recipeHandler, processorID, sideConfigYOffset);
    }

    public TileFluidProcessor(String name, int fluidInSize, int fluidOutSize, @Nonnull List<ItemSorption> itemSorptions, @Nonnull IntList fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int time, int power, boolean shouldLoseProgress, boolean upgrades, @Nonnull BasicRecipeHandler recipeHandler, int processorID, int sideConfigYOffset) {
        super(name, upgrades ? 2 : 0, ITileInventory.inventoryConnectionAll(itemSorptions), (long)IProcessor.getCapacity(processorID, 1.0, 1.0), power != 0 ? ITileEnergy.energyConnectionAll(EnergyConnection.IN) : ITileEnergy.energyConnectionAll(EnergyConnection.NON), fluidCapacity, allowedFluids, ITileFluid.fluidConnectionAll(tankSorptions));
        this.fluidInputSize = fluidInSize;
        this.fluidOutputSize = fluidOutSize;
        this.defaultProcessTime = time;
        this.defaultProcessPower = power;
        this.baseProcessTime = time;
        this.baseProcessPower = power;
        this.shouldLoseProgress = shouldLoseProgress;
        this.hasUpgrades = upgrades;
        this.processorID = processorID;
        this.sideConfigYOffset = sideConfigYOffset;
        this.setInputTanksSeparated(fluidInSize > 1);
        this.recipeHandler = recipeHandler;
        this.playersToUpdate = new ObjectOpenHashSet();
    }

    public static List<ItemSorption> defaultItemSorptions(boolean upgrades) {
        ArrayList<ItemSorption> itemSorptions = new ArrayList<ItemSorption>();
        if (upgrades) {
            itemSorptions.add(ItemSorption.IN);
            itemSorptions.add(ItemSorption.IN);
        }
        return itemSorptions;
    }

    public static IntList defaultTankCapacities(int capacity, int inSize, int outSize) {
        IntArrayList tankCapacities = new IntArrayList();
        for (int i = 0; i < inSize + outSize; ++i) {
            tankCapacities.add(capacity);
        }
        return tankCapacities;
    }

    public static List<TankSorption> defaultTankSorptions(int inSize, int outSize) {
        int i;
        ArrayList<TankSorption> tankSorptions = new ArrayList<TankSorption>();
        for (i = 0; i < inSize; ++i) {
            tankSorptions.add(TankSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            tankSorptions.add(TankSorption.OUT);
        }
        return tankSorptions;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.refreshUpgrades();
            this.isProcessing = this.isProcessing();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
                if (this.time > 0.0 && !this.isHaltedByRedstone() && (this.shouldLoseProgress || !this.canProcessInputs)) {
                    this.loseProgress();
                }
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
                this.setActivity(this.isProcessing);
                this.sendUpdateToAllPlayers();
            }
            this.sendUpdateToListeningPlayers();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = this.recipeHandler.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs());
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs();
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public int getProcessTime() {
        return Math.max(1, (int)Math.round(Math.ceil(this.baseProcessTime / this.getSpeedMultiplier())));
    }

    public int getProcessPower() {
        return Math.min(Integer.MAX_VALUE, (int)(this.baseProcessPower * this.getPowerMultiplier()));
    }

    public int getProcessEnergy() {
        return this.getProcessTime() * this.getProcessPower();
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = this.defaultProcessTime;
            this.baseProcessPower = this.defaultProcessPower;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = this.recipeInfo.getRecipe().getBaseProcessTime(this.defaultProcessTime);
        this.baseProcessPower = this.recipeInfo.getRecipe().getBaseProcessPower(this.defaultProcessPower);
        this.baseProcessRadiation = this.recipeInfo.getRecipe().getBaseProcessRadiation();
        return true;
    }

    public void setCapacityFromSpeed() {
        int capacity = IProcessor.getCapacity(this.processorID, this.getSpeedMultiplier(), this.getPowerMultiplier());
        this.getEnergyStorage().setStorageCapacity(capacity);
        this.getEnergyStorage().setMaxTransfer(capacity);
    }

    private int getMaxEnergyModified() {
        return ModCheck.galacticraftLoaded() ? Math.max(0, this.getMaxEnergyStored() - 16) : this.getMaxEnergyStored();
    }

    public boolean isProcessing() {
        return this.readyToProcess() && !this.isHaltedByRedstone();
    }

    public boolean isHaltedByRedstone() {
        return this.getRedstoneControl() && this.getIsRedstonePowered();
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasSufficientEnergy();
    }

    public boolean canProcessInputs() {
        boolean canProcess;
        boolean validRecipe = this.setRecipeStats();
        boolean bl = canProcess = validRecipe && this.canProduceProducts();
        if (!canProcess) {
            this.time = MathHelper.func_151237_a((double)this.time, (double)0.0, (double)(this.baseProcessTime - 1.0));
        }
        return canProcess;
    }

    public boolean hasSufficientEnergy() {
        return this.time <= this.resetTime && (this.getProcessEnergy() >= this.getMaxEnergyModified() && this.getEnergyStored() >= this.getMaxEnergyModified() || this.getProcessEnergy() <= this.getEnergyStored()) || this.time > this.resetTime && this.getEnergyStored() >= this.getProcessPower();
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            if (this.getTankOutputSetting(j + this.fluidInputSize) == TankOutputSetting.VOID) {
                this.clearTank(j + this.fluidInputSize);
                continue;
            }
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) continue;
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.getTankOutputSetting(j + this.fluidInputSize) != TankOutputSetting.DEFAULT || this.getTanks().get(j + this.fluidInputSize).getFluidAmount() + fluidProduct.getMaxStackSize(0) <= this.getTanks().get(j + this.fluidInputSize).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void process() {
        this.time += this.getSpeedMultiplier();
        this.getEnergyStorage().changeEnergyStored(-this.getProcessPower());
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.getSpeedMultiplier());
        while (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        this.time = this.resetTime = Math.max(0.0, this.time - oldProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.resetTime = 0.0;
            this.time = 0.0;
            for (int i = 0; i < this.fluidInputSize; ++i) {
                if (!this.getVoidUnusableFluidInput(i)) continue;
                this.getTanks().get(i).setFluid(null);
            }
        }
    }

    public void produceProducts() {
        if (this.recipeInfo == null) {
            return;
        }
        IntList fluidInputOrder = this.recipeInfo.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (int i = 0; i < this.fluidInputSize; ++i) {
            int fluidIngredientStackSize = this.getFluidIngredients().get((Integer)fluidInputOrder.get(i)).getMaxStackSize((Integer)this.recipeInfo.getFluidIngredientNumbers().get(i));
            if (fluidIngredientStackSize > 0) {
                this.getTanks().get(i).changeFluidAmount(-fluidIngredientStackSize);
            }
            if (this.getTanks().get(i).getFluidAmount() > 0) continue;
            this.getTanks().get(i).setFluidStored(null);
        }
        for (int j = 0; j < this.fluidOutputSize; ++j) {
            if (this.getTankOutputSetting(j + this.fluidInputSize) == TankOutputSetting.VOID) {
                this.clearTank(j + this.fluidInputSize);
                continue;
            }
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) {
                this.getTanks().get(j + this.fluidInputSize).setFluidStored(fluidProduct.getNextStack(0));
                continue;
            }
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) continue;
            this.getTanks().get(j + this.fluidInputSize).changeFluidAmount(fluidProduct.getNextStackSize(0));
        }
    }

    public void loseProgress() {
        this.time = MathHelper.func_151237_a((double)(this.time - 1.5 * this.getSpeedMultiplier()), (double)0.0, (double)this.baseProcessTime);
        if (this.time < this.resetTime) {
            this.resetTime = this.time;
        }
    }

    @Override
    public int getFluidInputSize() {
        return this.fluidInputSize;
    }

    @Override
    public int getFluidOutputputSize() {
        return this.fluidOutputSize;
    }

    @Override
    public List<Tank> getFluidInputs() {
        return this.getTanks().subList(0, this.fluidInputSize);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipeInfo.getRecipe().getFluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipeInfo.getRecipe().getFluidProducts();
    }

    @Override
    public boolean hasUpgrades() {
        return this.hasUpgrades;
    }

    @Override
    public int getSpeedUpgradeSlot() {
        return 0;
    }

    @Override
    public int getEnergyUpgradeSlot() {
        return 1;
    }

    @Override
    public int getSpeedCount() {
        return this.hasUpgrades ? ((ItemStack)this.getInventoryStacks().get(this.getSpeedUpgradeSlot())).func_190916_E() + 1 : 1;
    }

    @Override
    public int getEnergyCount() {
        return this.hasUpgrades ? Math.min(this.getSpeedCount(), ((ItemStack)this.getInventoryStacks().get(this.getEnergyUpgradeSlot())).func_190916_E() + 1) : 1;
    }

    @Override
    public void refreshUpgrades() {
        this.setCapacityFromSpeed();
    }

    @Override
    public int getSinkTier() {
        return 10;
    }

    @Override
    public int getSourceTier() {
        return 1;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (!(this.field_145850_b.field_72995_K || slot != this.getSpeedUpgradeSlot() && slot != this.getEnergyUpgradeSlot())) {
            this.refreshUpgrades();
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!(this.field_145850_b.field_72995_K || slot != this.getSpeedUpgradeSlot() && slot != this.getEnergyUpgradeSlot())) {
            this.refreshUpgrades();
        }
    }

    @Override
    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshUpgrades();
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.hasUpgrades && stack.func_77973_b() == NCItems.upgrade) {
            if (slot == this.getSpeedUpgradeSlot()) {
                return StackHelper.getMetadata(stack) == 0;
            }
            if (slot == this.getEnergyUpgradeSlot()) {
                return StackHelper.getMetadata(stack) == 1;
            }
        }
        return false;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return super.func_180462_a(slot, stack, side) && this.func_94041_b(slot, stack);
    }

    @Override
    public boolean hasConfigurableInventoryConnections() {
        return true;
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("time", this.time);
        nbt.func_74780_a("resetTime", this.resetTime);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74769_h("time");
        this.resetTime = nbt.func_74769_h("resetTime");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        if (nbt.func_74764_b("redstoneControl")) {
            this.setRedstoneControl(nbt.func_74767_n("redstoneControl"));
        } else {
            this.setRedstoneControl(true);
        }
    }

    @Override
    public int getGuiID() {
        return this.processorID;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return this.playersToUpdate;
    }

    @Override
    public ProcessorUpdatePacket getGuiUpdatePacket() {
        return new ProcessorUpdatePacket(this.field_174879_c, this.isProcessing, this.time, this.getEnergyStored(), this.baseProcessTime, this.baseProcessPower, this.getTanks());
    }

    @Override
    public void onGuiPacket(ProcessorUpdatePacket message) {
        this.isProcessing = message.isProcessing;
        this.time = message.time;
        this.getEnergyStorage().setEnergyStored(message.energyStored);
        this.baseProcessTime = message.baseProcessTime;
        this.baseProcessPower = message.baseProcessPower;
        for (int i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).readInfo(message.tanksInfo.get(i));
        }
    }

    @Override
    public int getSideConfigYOffset() {
        return this.sideConfigYOffset;
    }
}

