/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.capability.radiation.source.IRadiationSource;
import nc.capability.radiation.source.RadiationSource;
import nc.network.tile.TileUpdatePacket;
import nc.radiation.RadSources;
import nc.tile.ITileGui;
import nc.tile.dummy.IInterfaceable;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.util.OreDictHelper;
import nc.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileNuclearFurnace
extends TileEntity
implements ITickable,
ITileInventory,
ITileGui,
IInterfaceable {
    private final NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private final InventoryConnection outputConnection = new InventoryConnection(Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.NON, ItemSorption.IN, ItemSorption.OUT}));
    private final InventoryConnection inputConnection = new InventoryConnection(Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.IN, ItemSorption.NON, ItemSorption.NON}));
    private InventoryConnection[] inventoryConnections = new InventoryConnection[]{this.outputConnection, this.inputConnection, this.outputConnection, this.outputConnection, this.outputConnection, this.outputConnection};
    private final List<ItemOutputSetting> itemOutputSettings = Lists.newArrayList((Object[])new ItemOutputSetting[]{ItemOutputSetting.DEFAULT, ItemOutputSetting.DEFAULT, ItemOutputSetting.DEFAULT});
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private final IRadiationSource radiation = new RadiationSource(0.0);

    public TileEntity thisTile() {
        return this;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(index);
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && StackHelper.areItemStackTagsEqual(stack, itemstack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.furnaceItemStacks.set(index, (Object)stack);
        if (!flag) {
            this.totalCookTime = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks() {
        return this.furnaceItemStacks;
    }

    @Override
    public IRadiationSource getRadiationSource() {
        return this.radiation;
    }

    @Override
    public String func_70005_c_() {
        return "nuclearcraft.container.nuclear_furnace";
    }

    @Override
    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    @Override
    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    public static void registerFixesFurnace(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileNuclearFurnace.class, new String[]{"Items"}));
    }

    public void readRadiation(NBTTagCompound nbt) {
        if (nbt.func_74764_b("radiationLevel")) {
            this.getRadiationSource().setRadiationLevel(nbt.func_74769_h("radiationLevel"));
        }
    }

    public NBTTagCompound writeRadiation(NBTTagCompound nbt) {
        nbt.func_74780_a("radiationLevel", this.getRadiationSource().getRadiationLevel());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.furnaceBurnTime = nbt.func_74762_e("furnaceBurnTime");
        this.cookTime = nbt.func_74762_e("cookTime");
        this.totalCookTime = nbt.func_74762_e("totalCookTime");
        this.currentItemBurnTime = nbt.func_74762_e("currentItemBurnTime");
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
        this.readSlotSettings(nbt);
        this.readRadiation(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("furnaceBurnTime", this.furnaceBurnTime);
        nbt.func_74768_a("cookTime", this.cookTime);
        nbt.func_74768_a("totalCookTime", this.totalCookTime);
        nbt.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        this.writeSlotSettings(nbt);
        this.writeRadiation(nbt);
        return nbt;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.refreshIsRedstonePowered(this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
            this.updateComparatorOutputLevel();
        }
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
            this.getRadiationSource().setRadiationLevel(RadSources.LEU_235_FISSION);
        } else {
            this.getRadiationSource().setRadiationLevel(0.0);
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileNuclearFurnace.getItemBurnTime(itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.furnaceItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.setActivity(this.isBurning());
            }
            if (flag1) {
                this.func_70296_d();
            }
        }
    }

    public int getCookTime() {
        return 10;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.furnaceItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        int result = itemstack1.func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(0);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = (ItemStack)this.furnaceItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && StackHelper.getMetadata(itemstack) == 1 && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (OreDictHelper.isOreMember(stack, "blockUranium")) {
            return 3200;
        }
        if (OreDictHelper.isOreMember(stack, "ingotUranium")) {
            return 320;
        }
        if (OreDictHelper.isOreMember(stack, "dustUranium")) {
            return 320;
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileNuclearFurnace.getItemBurnTime(stack) > 0;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        return TileNuclearFurnace.isItemFuel(stack);
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return ITileInventory.super.func_180462_a(slot, stack, side) && this.func_94041_b(slot, stack);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        Item item;
        if (side == EnumFacing.DOWN && slot == 1 && (item = stack.func_77973_b()) != Items.field_151131_as && item != Items.field_151133_ar) {
            return false;
        }
        return ITileInventory.super.func_180461_b(slot, stack, side);
    }

    @Override
    public int func_174890_g() {
        return 4;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_145838_q() == null ? null : new TextComponentTranslation(this.func_145838_q().func_149732_F(), new Object[0]);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return this.radiation != null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)this.radiation;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getItemHandler(side);
        }
        return (T)super.getCapability(capability, side);
    }

    @Override
    public World getTileWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getTilePos() {
        return this.field_174879_c;
    }

    @Override
    public Block getTileBlockType() {
        return this.func_145838_q();
    }

    @Override
    public int getTileBlockMeta() {
        return this.func_145832_p();
    }

    @Override
    public void markTileDirty() {
        this.func_70296_d();
    }

    @Override
    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
    }

    @Override
    public boolean getIsRedstonePowered() {
        return false;
    }

    @Override
    public void setIsRedstonePowered(boolean isRedstonePowered) {
    }

    @Override
    public boolean getAlternateComparator() {
        return false;
    }

    @Override
    public void setAlternateComparator(boolean alternate) {
    }

    @Override
    public boolean getRedstoneControl() {
        return false;
    }

    @Override
    public void setRedstoneControl(boolean redstoneControl) {
    }

    @Override
    public ItemOutputSetting getItemOutputSetting(int slot) {
        return this.itemOutputSettings.get(slot);
    }

    @Override
    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
        this.itemOutputSettings.set(slot, setting);
    }

    @Override
    public int getGuiID() {
        return 0;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return null;
    }

    public TileUpdatePacket getGuiUpdatePacket() {
        return null;
    }

    public void onGuiPacket(TileUpdatePacket message) {
    }

    @Override
    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
    }

    @Override
    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
    }

    @Override
    public void sendUpdateToListeningPlayers() {
    }

    @Override
    public void sendIndividualUpdate(EntityPlayer player) {
    }

    @Override
    public void sendUpdateToAllPlayers() {
    }
}

