/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.radiation;

import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.radiation.RadiationHelper;
import nc.tile.NCTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileGeigerCounter
extends NCTile
implements ITickable,
SimpleComponent {
    public int comparatorStrength = 0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldUpdate = false;
            int compStrength = this.getComparatorStrength();
            if (this.comparatorStrength != compStrength) {
                shouldUpdate = true;
            }
            this.comparatorStrength = compStrength;
            if (shouldUpdate) {
                this.func_70296_d();
                this.updateComparatorOutputLevel();
            }
        }
    }

    public double getChunkRadiationLevel() {
        IRadiationSource chunkRadiation = RadiationHelper.getRadiationSource((ICapabilityProvider)this.field_145850_b.func_175726_f(this.field_174879_c));
        return chunkRadiation == null ? 0.0 : chunkRadiation.getRadiationLevel();
    }

    public int getComparatorStrength() {
        double radiation = this.getChunkRadiationLevel();
        return radiation <= 0.0 ? 0 : Math.max(0, (int)(15.0 + Math.log10(radiation) - NCConfig.radiation_geiger_block_redstone));
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("comparatorStrength", this.comparatorStrength);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.comparatorStrength = nbt.func_74762_e("comparatorStrength");
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_geiger_counter";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getChunkRadiationLevel(Context context, Arguments args) {
        return new Object[]{this.getChunkRadiationLevel()};
    }
}

