/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.util.Random;
import nc.block.property.BlockProperties;
import nc.config.NCConfig;
import nc.tile.fluid.ITileFluid;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockHelper {
    public static final AxisAlignedBB REDUCED_BLOCK_AABB = new AxisAlignedBB(0.002, 0.002, 0.002, 0.998, 0.998, 0.998);
    private static final byte[] BOTTOM = new byte[]{2, 3, 0, 0, 0, 0};
    private static final byte[] TOP = new byte[]{3, 2, 1, 1, 1, 1};
    private static final byte[] LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    private static final byte[] RIGHT = new byte[]{5, 4, 4, 5, 3, 2};
    private static final byte[] FRONT = new byte[]{0, 1, 2, 3, 4, 5};
    private static final byte[] BACK = new byte[]{1, 0, 3, 2, 5, 4};

    public static void setDefaultFacing(World world, BlockPos pos, IBlockState state, PropertyEnum<EnumFacing> property) {
        if (!world.field_72995_K) {
            world.func_180501_a(pos, state.func_177226_a(property, (Comparable)BlockHelper.getDefaultFacing(world, pos, state, property)), 2);
        }
    }

    public static EnumFacing getDefaultFacing(World world, BlockPos pos, IBlockState state, PropertyEnum<EnumFacing> property) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(property);
        if (!world.field_72995_K) {
            boolean n = world.func_180495_p(pos.func_177978_c()).func_185913_b();
            boolean s = world.func_180495_p(pos.func_177968_d()).func_185913_b();
            if (facing == EnumFacing.NORTH && n && !s) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH && s && !n) {
                facing = EnumFacing.NORTH;
            } else {
                boolean w = world.func_180495_p(pos.func_177976_e()).func_185913_b();
                boolean e = world.func_180495_p(pos.func_177974_f()).func_185913_b();
                if (facing == EnumFacing.WEST && w && !e) {
                    facing = EnumFacing.EAST;
                } else if (facing == EnumFacing.EAST && e && !w) {
                    facing = EnumFacing.WEST;
                } else if (property == BlockProperties.FACING_ALL) {
                    boolean u = world.func_180495_p(pos.func_177984_a()).func_185913_b();
                    boolean d = world.func_180495_p(pos.func_177977_b()).func_185913_b();
                    if (facing == EnumFacing.UP && u && !d) {
                        facing = EnumFacing.DOWN;
                    } else if (facing == EnumFacing.DOWN && d && !u) {
                        facing = EnumFacing.UP;
                    }
                }
            }
        }
        return facing;
    }

    public static void spawnParticleOnProcessor(IBlockState state, World world, BlockPos pos, Random rand, EnumFacing side, String particleName) {
        if (particleName.equals("") || !NCConfig.processor_particles) {
            return;
        }
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.125 + rand.nextDouble() * 0.75;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.52;
        double d4 = rand.nextDouble() * 0.6 - 0.3;
        switch (side) {
            case WEST: {
                world.func_175688_a(EnumParticleTypes.func_186831_a((String)particleName), d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                world.func_175688_a(EnumParticleTypes.func_186831_a((String)particleName), d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                world.func_175688_a(EnumParticleTypes.func_186831_a((String)particleName), d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case SOUTH: {
                world.func_175688_a(EnumParticleTypes.func_186831_a((String)particleName), d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public static boolean accessTanks(EntityPlayer player, EnumHand hand, EnumFacing facing, ITileFluid tile) {
        IItemHandler playerInventory;
        if (player == null || tile == null) {
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && (playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            IFluidHandlerItem container = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1));
            if (container == null) {
                return false;
            }
            for (int i = 0; i < tile.getTanks().size(); ++i) {
                FluidActionResult fluidActionResult;
                FluidActionResult fluidActionResult2 = fluidActionResult = !tile.getTankSorption(facing, i).canDrain() ? FluidActionResult.FAILURE : FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)((IFluidHandler)tile.getTanks().get(i)), (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                if (!fluidActionResult.isSuccess() && tile.getTankSorption(facing, i).canFill() && tile.isNextToFill(facing, i, container.drain(Integer.MAX_VALUE, false))) {
                    fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)((IFluidHandler)tile.getTanks().get(i)), (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                }
                if (!fluidActionResult.isSuccess()) continue;
                player.func_184611_a(hand, fluidActionResult.getResult());
                return true;
            }
        }
        return false;
    }

    public static EnumFacing bottom(EnumFacing facing) {
        return EnumFacing.func_82600_a((int)BOTTOM[facing.func_176745_a()]);
    }

    public static EnumFacing top(EnumFacing facing) {
        return EnumFacing.func_82600_a((int)TOP[facing.func_176745_a()]);
    }

    public static EnumFacing left(EnumFacing facing) {
        return EnumFacing.func_82600_a((int)LEFT[facing.func_176745_a()]);
    }

    public static EnumFacing right(EnumFacing facing) {
        return EnumFacing.func_82600_a((int)RIGHT[facing.func_176745_a()]);
    }

    public static EnumFacing front(EnumFacing facing) {
        return EnumFacing.func_82600_a((int)FRONT[facing.func_176745_a()]);
    }

    public static EnumFacing back(EnumFacing facing) {
        return EnumFacing.func_82600_a((int)BACK[facing.func_176745_a()]);
    }
}

