/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import nc.util.Complex;
import nc.util.ComplexVector;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ComplexMatrix {
    public final int dim;
    public final double[][] re;
    public final double[][] im;

    public ComplexMatrix(int dim) {
        this.dim = dim;
        this.re = new double[dim][dim];
        this.im = new double[dim][dim];
    }

    public ComplexMatrix(double[][] c) {
        this(c.length);
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                this.re[i][j] = c[i][2 * j];
                this.im[i][j] = c[i][2 * j + 1];
            }
        }
    }

    public ComplexMatrix copy() {
        ComplexMatrix m = new ComplexMatrix(this.dim);
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                m.re[i][j] = this.re[i][j];
                m.im[i][j] = this.im[i][j];
            }
        }
        return m;
    }

    public ComplexMatrix id() {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                this.re[i][j] = j == i ? 1.0 : 0.0;
                this.im[i][j] = 0.0;
            }
        }
        return this;
    }

    public ComplexMatrix zero() {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                this.im[i][j] = 0.0;
                this.re[i][j] = 0.0;
            }
        }
        return this;
    }

    public ComplexMatrix add(ComplexMatrix m) {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                double[] dArray = this.re[i];
                int n = j;
                dArray[n] = dArray[n] + m.re[i][j];
                double[] dArray2 = this.im[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + m.im[i][j];
            }
        }
        return this;
    }

    public ComplexMatrix subtract(ComplexMatrix m) {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                double[] dArray = this.re[i];
                int n = j;
                dArray[n] = dArray[n] - m.re[i][j];
                double[] dArray2 = this.im[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] - m.im[i][j];
            }
        }
        return this;
    }

    public ComplexMatrix hadamardProduct(ComplexMatrix m) {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                double[] c = Complex.multiply(this.re[i][j], this.im[i][j], m.re[i][j], m.im[i][j]);
                this.re[i][j] = c[0];
                this.im[i][j] = c[1];
            }
        }
        return this;
    }

    public ComplexMatrix multiply(double re, double im) {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                double[] c = Complex.multiply(this.re[i][j], this.im[i][j], re, im);
                this.re[i][j] = c[0];
                this.im[i][j] = c[1];
            }
        }
        return this;
    }

    public ComplexMatrix multiply(double a) {
        for (int i = 0; i < this.dim; ++i) {
            int j = 0;
            while (j < this.dim) {
                double[] dArray = this.re[i];
                int n = j;
                dArray[n] = dArray[n] * a;
                double[] dArray2 = this.im[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] * a;
            }
        }
        return this;
    }

    public ComplexMatrix multiply(ComplexMatrix m) {
        ComplexMatrix copy = this.copy();
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                this.im[i][j] = 0.0;
                this.re[i][j] = 0.0;
                for (int k = 0; k < this.dim; ++k) {
                    double[] c = Complex.multiply(copy.re[i][k], copy.im[i][k], m.re[k][j], m.im[k][j]);
                    double[] dArray = this.re[i];
                    int n = j;
                    dArray[n] = dArray[n] + c[0];
                    double[] dArray2 = this.im[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + c[1];
                }
            }
        }
        return this;
    }

    public double[] expectation(ComplexVector v) {
        return v.copy().dot(v.map(this));
    }

    public double[] trace() {
        double re = 0.0;
        double im = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            re += this.re[i][i];
            im += this.im[i][i];
        }
        return new double[]{re, im};
    }

    public void swap(int i1, int j1, int i2, int j2) {
        double re = this.re[i1][j1];
        double im = this.im[i1][j1];
        this.re[i1][j1] = this.re[i2][j2];
        this.im[i1][j1] = this.im[i2][j2];
        this.re[i2][j2] = re;
        this.im[i2][j2] = im;
    }

    public double[] det() {
        int i;
        if (this.dim == 0) {
            return new double[]{1.0, 0.0};
        }
        if (this.dim == 1) {
            return new double[]{this.re[0][0], this.im[0][0]};
        }
        if (this.dim == 2) {
            double[] ad = Complex.multiply(this.re[0][0], this.im[0][0], this.re[1][1], this.im[1][1]);
            double[] bc = Complex.multiply(this.re[0][1], this.im[0][1], this.re[1][0], this.im[1][0]);
            return new double[]{ad[0] - bc[0], ad[1] - bc[1]};
        }
        double[] det = new double[]{1.0, 0.0};
        double[] total = new double[]{1.0, 0.0};
        double[] tempRe = new double[this.dim + 1];
        double[] tempIm = new double[this.dim + 1];
        ComplexMatrix m = this.copy();
        for (i = 0; i < this.dim; ++i) {
            int j;
            int index;
            for (index = i; index < this.dim && m.re[index][i] == 0.0 && m.im[index][i] == 0.0; ++index) {
            }
            if (index == this.dim) continue;
            if (index != i) {
                for (j = 0; j < this.dim; ++j) {
                    m.swap(index, j, i, j);
                }
                det = Complex.multiply(det[0], det[1], -1.0, 0.0);
            }
            for (j = 0; j < this.dim; ++j) {
                tempRe[j] = m.re[i][j];
                tempIm[j] = m.im[i][j];
            }
            for (j = i + 1; j < this.dim; ++j) {
                double re1 = tempRe[i];
                double im1 = tempIm[i];
                double re2 = m.re[j][i];
                double im2 = m.im[j][i];
                for (int k = 0; k < this.dim; ++k) {
                    double[] ad = Complex.multiply(re1, im1, m.re[j][k], m.im[j][k]);
                    double[] bc = Complex.multiply(re2, im2, tempRe[k], tempIm[k]);
                    m.re[j][k] = ad[0] - bc[0];
                    m.im[j][k] = ad[1] - bc[1];
                }
                total = Complex.multiply(total[0], total[1], re1, im1);
            }
        }
        for (i = 0; i < this.dim; ++i) {
            det = Complex.multiply(det[0], det[1], m.re[i][i], m.im[i][i]);
        }
        return Complex.divide(det[0], det[1], total[0], total[1]);
    }

    public ComplexMatrix transpose() {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < i; ++j) {
                if (i == j) continue;
                this.swap(i, j, j, i);
            }
        }
        return this;
    }

    public static ComplexMatrix tensorProduct(ComplexMatrix ... a) {
        boolean end;
        if (a.length == 0) {
            return new ComplexMatrix(0);
        }
        if (a.length == 1) {
            return a[0];
        }
        int dim = a[0].dim;
        int mul = 1;
        for (int j = 1; j < a.length; ++j) {
            dim *= a[j].dim;
        }
        ComplexMatrix m = new ComplexMatrix(dim);
        int[] length = new int[a.length];
        int[] count = new int[2 * a.length];
        int[] mult = new int[a.length];
        for (int j = 0; j < a.length; ++j) {
            length[j] = a[j].dim;
            if (j > 0) {
                mul *= a[a.length - j].dim;
            }
            mult[a.length - j - 1] = mul;
        }
        Arrays.fill(count, 0);
        block2: do {
            int j;
            int u = 0;
            int v = 0;
            for (j = 0; j < a.length; ++j) {
                u += mult[j] * count[2 * j];
                v += mult[j] * count[2 * j + 1];
            }
            double[] c = Complex.multiply(a[0].re[count[0]][count[1]], a[0].im[count[0]][count[1]], a[1].re[count[2]][count[3]], a[1].im[count[2]][count[3]]);
            for (j = 2; j < a.length; ++j) {
                c = Complex.multiply(c[0], c[1], a[j].re[count[2 * j]][count[2 * j + 1]], a[j].im[count[2 * j]][count[2 * j + 1]]);
            }
            m.re[u][v] = c[0];
            m.im[u][v] = c[1];
            end = true;
            for (j = 0; j < count.length; ++j) {
                int _j = count.length - j - 1;
                if (count[_j] < length[_j / 2] - 1) {
                    int n = _j;
                    count[n] = count[n] + 1;
                    end = false;
                    continue block2;
                }
                count[_j] = 0;
            }
        } while (!end);
        return m;
    }

    public ComplexMatrix commute(ComplexMatrix a) {
        ComplexMatrix c = this.copy();
        return this.multiply(a).subtract(a.copy().multiply(c));
    }

    public ComplexMatrix square() {
        return this.multiply(this.copy());
    }

    public ComplexMatrix conjugate() {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                this.re[i][j] = this.re[i][j];
                this.im[i][j] = -this.im[i][j];
            }
        }
        return this;
    }

    public ComplexMatrix hermitian() {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < i; ++j) {
                if (i == j) continue;
                this.swap(i, j, j, i);
            }
        }
        return this;
    }

    public int hashCode() {
        int h = 1;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                h = 31 * h + HashCommon.double2int((double)this.re[i][j]);
                h = 31 * h + HashCommon.double2int((double)this.im[i][j]);
            }
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComplexMatrix)) {
            return false;
        }
        ComplexMatrix other = (ComplexMatrix)obj;
        if (this.dim != other.dim) {
            return false;
        }
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                if (this.re[i][j] != other.re[i][j]) {
                    return false;
                }
                if (this.im[i][j] == other.im[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.dim; ++i) {
            String v = "";
            for (int j = 0; j < this.dim; ++j) {
                v = v + ", " + Complex.toString(this.re[i][j], this.im[i][j]);
            }
            s = s + ", [" + v.substring(2) + "]";
        }
        return "[" + s.substring(2) + "]";
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound matrixTag = new NBTTagCompound();
        matrixTag.func_74768_a("dim", this.dim);
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                matrixTag.func_74780_a("re" + i + "_" + j, this.re[i][j]);
                matrixTag.func_74780_a("im" + i + "_" + j, this.im[i][j]);
            }
        }
        nbt.func_74782_a(name, (NBTBase)matrixTag);
        return nbt;
    }

    public static ComplexMatrix readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound matrixTag = nbt.func_74775_l(name);
            ComplexMatrix m = new ComplexMatrix(matrixTag.func_74762_e("dim"));
            for (int i = 0; i < m.dim; ++i) {
                for (int j = 0; j < m.dim; ++j) {
                    m.re[i][j] = matrixTag.func_74769_h("re" + i + "_" + j);
                    m.im[i][j] = matrixTag.func_74769_h("im" + i + "_" + j);
                }
            }
            return m;
        }
        return null;
    }
}

