/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import nc.util.Complex;
import nc.util.ComplexMatrix;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ComplexVector {
    public final int dim;
    public final double[] re;
    public final double[] im;

    public ComplexVector(int dim) {
        this.dim = dim;
        this.re = new double[dim];
        this.im = new double[dim];
    }

    public ComplexVector copy() {
        ComplexVector v = new ComplexVector(this.dim);
        for (int i = 0; i < this.dim; ++i) {
            v.re[i] = this.re[i];
            v.im[i] = this.im[i];
        }
        return v;
    }

    public void zero() {
        for (int i = 0; i < this.dim; ++i) {
            this.re[i] = 0.0;
            this.im[i] = 0.0;
        }
    }

    public ComplexVector map(ComplexMatrix m) {
        ComplexVector v = this.copy();
        for (int i = 0; i < this.dim; ++i) {
            this.re[i] = 0.0;
            this.im[i] = 0.0;
            for (int j = 0; j < this.dim; ++j) {
                double[] c = Complex.multiply(m.re[i][j], m.im[i][j], v.re[j], v.im[j]);
                int n = i;
                this.re[n] = this.re[n] + c[0];
                int n2 = i;
                this.im[n2] = this.im[n2] + c[1];
            }
        }
        return this;
    }

    public double absSq() {
        double n = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            n += Complex.absSq(this.re[i], this.im[i]);
        }
        return n;
    }

    public ComplexVector normalize() {
        double scale = Math.sqrt(this.absSq());
        int i = 0;
        while (i < this.dim) {
            int n = i;
            this.re[n] = this.re[n] / scale;
            int n2 = i++;
            this.im[n2] = this.im[n2] / scale;
        }
        return this;
    }

    public double[] dot(ComplexVector v) {
        double re = 0.0;
        double im = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            double[] c = Complex.multiply(this.re[i], -this.im[i], v.re[i], v.im[i]);
            re += c[0];
            im += c[1];
        }
        return new double[]{re, im};
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.dim; ++i) {
            s = s + ", " + Complex.toString(this.re[i], this.im[i]);
        }
        return "[" + s.substring(2) + "]";
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound vectorTag = new NBTTagCompound();
        vectorTag.func_74768_a("dim", this.dim);
        for (int i = 0; i < this.dim; ++i) {
            vectorTag.func_74780_a("re" + i, this.re[i]);
            vectorTag.func_74780_a("im" + i, this.im[i]);
        }
        nbt.func_74782_a(name, (NBTBase)vectorTag);
        return nbt;
    }

    public static ComplexVector readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound vectorTag = nbt.func_74775_l(name);
            ComplexVector v = new ComplexVector(vectorTag.func_74762_e("dim"));
            for (int i = 0; i < v.dim; ++i) {
                v.re[i] = vectorTag.func_74769_h("re" + i);
                v.im[i] = vectorTag.func_74769_h("im" + i);
            }
            return v;
        }
        return new ComplexVector(0);
    }
}

