/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import nc.util.StringHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GasHelper {
    public static final Object2ObjectMap<String, String> TRANSLATION_MAP = new Object2ObjectOpenHashMap();
    public static final Object2ObjectMap<String, String> GAS_MAP = new Object2ObjectOpenHashMap();

    public static void preInit() {
        TRANSLATION_MAP.put((Object)"sulfur_dioxide", (Object)"liquidsulfurdioxide");
        TRANSLATION_MAP.put((Object)"sulfur_trioxide", (Object)"liquidsulfurtrioxide");
        TRANSLATION_MAP.put((Object)"hydrogen_chloride", (Object)"liquidhydrogenchloride");
        TRANSLATION_MAP.put((Object)"sulfuric_acid", (Object)"sulfuricacid");
    }

    public static void init() {
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            if (gas.getFluid() == null) continue;
            GAS_MAP.put((Object)gas.getFluid().getName(), (Object)gas.getName());
        }
    }

    public static FluidStack getFluidFromGas(GasStack gasStack) {
        if (gasStack == null || gasStack.getGas().getFluid() == null) {
            return null;
        }
        Fluid gasFluid = gasStack.getGas().getFluid();
        if (gasFluid == null) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)gasFluid.getName());
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, gasStack.amount);
    }

    public static GasStack getGasFromFluid(FluidStack fluidStack) {
        String gasName;
        if (fluidStack == null) {
            return null;
        }
        String fluidName = fluidStack.getFluid().getName();
        if (!StringHelper.beginsWith("liquid", fluidName)) {
            fluidName = TRANSLATION_MAP.containsKey((Object)fluidName) ? (String)TRANSLATION_MAP.get((Object)fluidName) : "liquid" + fluidName;
        }
        if ((gasName = (String)GAS_MAP.get((Object)fluidName)) == null) {
            return null;
        }
        Gas gas = GasRegistry.getGas((String)gasName);
        if (gas == null) {
            return null;
        }
        return new GasStack(gas, fluidStack.amount);
    }
}

