/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nc.util.NCUtil;

public class IOHelper {
    public static final String NEW_LINE = System.lineSeparator();
    public static final int MAX_ZIP_SIZE = 50000000;
    public static final int ZIP_READ_SIZE = 8192;

    public static void appendFile(File target, File source, String separator) throws IOException {
        FileWriter writer = new FileWriter(target, true);
        FileReader reader = new FileReader(source);
        writer.write(separator);
        int c = reader.read();
        while (c != -1) {
            writer.write(c);
            c = reader.read();
        }
        writer.close();
        reader.close();
    }

    public static boolean isZip(File file) {
        int signature = 0;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            signature = raf.readInt();
        }
        catch (IOException e) {
            NCUtil.getLogger().catching((Throwable)e);
        }
        return signature == 1347093252 || signature == 1347093766 || signature == 1347094280;
    }

    public static void unzip(File zipFile, String dest) throws IOException {
        File destDir = new File(dest);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        int bytes = 0;
        ZipInputStream zipStream = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry entry = zipStream.getNextEntry();
        while (entry != null) {
            String fileDest = dest + "/" + entry.getName();
            String canonicalDestDir = new File(dest).getCanonicalPath();
            String canonicalFileDest = new File(fileDest).getCanonicalPath();
            if (!canonicalFileDest.startsWith(canonicalDestDir + File.separator)) {
                zipStream.close();
                throw new IOException("Entry is outside of the target directory \"" + entry.getName() + "\"");
            }
            if (!entry.isDirectory()) {
                bytes = IOHelper.extract(zipStream, fileDest, bytes);
            } else {
                new File(fileDest).mkdirs();
            }
            zipStream.closeEntry();
            entry = zipStream.getNextEntry();
        }
        zipStream.close();
    }

    private static int extract(ZipInputStream zipStream, String fileDest, int currentBytes) throws IOException {
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(fileDest));){
            byte[] bytesIn = new byte[8192];
            int read = 0;
            while ((read = zipStream.read(bytesIn)) != -1) {
                if ((currentBytes += read) > 50000000) {
                    throw new IOException("Zip file being extracted to \"" + fileDest + "\" is too big!");
                }
                outStream.write(bytesIn, 0, read);
            }
            outStream.close();
        }
        return currentBytes;
    }
}

