/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3f;
import nc.util.PosHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class NBTHelper {
    public static NBTTagCompound writeAllItems(NBTTagCompound tag, List<ItemStack> ... lists) {
        if (lists.length == 0) {
            return tag;
        }
        NBTTagList nbttaglist = new NBTTagList();
        int i = 0;
        for (List<ItemStack> list : lists) {
            for (ItemStack stack : list) {
                if (!stack.func_190926_b()) {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    nbttagcompound.func_74774_a("Slot", (byte)i);
                    stack.func_77955_b(nbttagcompound);
                    nbttaglist.func_74742_a((NBTBase)nbttagcompound);
                }
                ++i;
            }
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        return tag;
    }

    public static void readAllItems(NBTTagCompound tag, List<ItemStack> ... lists) {
        if (lists.length == 0) {
            return;
        }
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        int n = 0;
        int offset = 0;
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            while (j - offset >= lists[n].size()) {
                offset += lists[n].size();
                ++n;
            }
            if (j - offset < 0 || j - offset >= lists[n].size()) continue;
            lists[n].set(j - offset, new ItemStack(nbttagcompound));
        }
    }

    public static NBTTagCompound writeBlockPos(NBTTagCompound nbt, BlockPos pos, String name) {
        if (pos != null) {
            nbt.func_74783_a(name, new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        }
        return nbt;
    }

    public static BlockPos readBlockPos(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 11)) {
            int[] array = nbt.func_74759_k(name);
            return new BlockPos(array[0], array[1], array[2]);
        }
        return PosHelper.DEFAULT_NON;
    }

    public static NBTTagCompound writeVector3f(NBTTagCompound nbt, Vector3f vector, String name) {
        if (vector != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("floatx", vector.x);
            tag.func_74776_a("floaty", vector.y);
            tag.func_74776_a("floatz", vector.z);
            nbt.func_74782_a(name, (NBTBase)tag);
        }
        return nbt;
    }

    public static Vector3f readVector3f(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            return new Vector3f(tag.func_74760_g("floatx"), tag.func_74760_g("floaty"), tag.func_74760_g("floatz"));
        }
        return new Vector3f(0.0f, -1.0f, 0.0f);
    }

    public static NBTTagCompound writeLongArray(NBTTagCompound nbt, long[] array, String name) {
        if (array != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("length", array.length);
            for (int i = 0; i < array.length; ++i) {
                tag.func_74772_a("long" + i, array[i]);
            }
            nbt.func_74782_a(name, (NBTBase)tag);
        }
        return nbt;
    }

    public static long[] readLongArray(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            long[] array = new long[tag.func_74762_e("length")];
            for (int i = 0; i < array.length; ++i) {
                array[i] = tag.func_74763_f("long" + i);
            }
            return array;
        }
        return new long[0];
    }

    public static NBTTagCompound writeFloatArray(NBTTagCompound nbt, float[] array, String name) {
        if (array != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("length", array.length);
            for (int i = 0; i < array.length; ++i) {
                tag.func_74776_a("float" + i, array[i]);
            }
            nbt.func_74782_a(name, (NBTBase)tag);
        }
        return nbt;
    }

    public static float[] readFloatArray(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            float[] array = new float[tag.func_74762_e("length")];
            for (int i = 0; i < array.length; ++i) {
                array[i] = tag.func_74760_g("float" + i);
            }
            return array;
        }
        return new float[0];
    }

    public static NBTTagCompound writeDoubleArray(NBTTagCompound nbt, double[] array, String name) {
        if (array != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("length", array.length);
            for (int i = 0; i < array.length; ++i) {
                tag.func_74780_a("double" + i, array[i]);
            }
            nbt.func_74782_a(name, (NBTBase)tag);
        }
        return nbt;
    }

    public static double[] readDoubleArray(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            double[] array = new double[tag.func_74762_e("length")];
            for (int i = 0; i < array.length; ++i) {
                array[i] = tag.func_74769_h("double" + i);
            }
            return array;
        }
        return new double[0];
    }

    public static NBTTagCompound writeBlockPosArray(NBTTagCompound nbt, BlockPos[] array, String name) {
        if (array != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("length", array.length);
            for (int i = 0; i < array.length; ++i) {
                NBTHelper.writeBlockPos(tag, array[i], "pos" + i);
            }
            nbt.func_74782_a(name, (NBTBase)tag);
        }
        return nbt;
    }

    public static BlockPos[] readBlockPosArray(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            BlockPos[] array = new BlockPos[tag.func_74762_e("length")];
            for (int i = 0; i < array.length; ++i) {
                array[i] = NBTHelper.readBlockPos(tag, "pos" + i);
            }
            return array;
        }
        return null;
    }

    public static NBTTagCompound writeVector3fArray(NBTTagCompound nbt, Vector3f[] array, String name) {
        if (array != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("length", array.length);
            for (int i = 0; i < array.length; ++i) {
                NBTHelper.writeVector3f(tag, array[i], "vector" + i);
            }
            nbt.func_74782_a(name, (NBTBase)tag);
        }
        return nbt;
    }

    public static Vector3f[] readVector3fArray(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            Vector3f[] array = new Vector3f[tag.func_74762_e("length")];
            for (int i = 0; i < array.length; ++i) {
                array[i] = NBTHelper.readVector3f(tag, "vector" + i);
            }
            return array;
        }
        return null;
    }

    public static NBTTagCompound writeIntCollection(NBTTagCompound nbt, IntCollection collection, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("ints", collection.toIntArray());
        nbt.func_74782_a(name, (NBTBase)tag);
        return nbt;
    }

    public static void readIntCollection(NBTTagCompound nbt, IntCollection collection, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            collection.clear();
            collection.addAll((IntCollection)new IntArrayList(tag.func_74759_k("ints")));
        }
    }

    public static NBTTagCompound writeLongCollection(NBTTagCompound nbt, LongCollection collection, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        int i = 0;
        LongIterator longIterator = collection.iterator();
        while (longIterator.hasNext()) {
            long l = (Long)longIterator.next();
            tag.func_74772_a("long" + i, l);
            ++i;
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return nbt;
    }

    public static void readLongCollection(NBTTagCompound nbt, LongCollection collection, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            collection.clear();
            int i = 0;
            while (tag.func_74764_b("long" + i)) {
                collection.add(tag.func_74763_f("long" + i));
                ++i;
            }
        }
    }

    public static NBTTagCompound writeFloatCollection(NBTTagCompound nbt, FloatCollection collection, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        int i = 0;
        FloatIterator floatIterator = collection.iterator();
        while (floatIterator.hasNext()) {
            float f = ((Float)floatIterator.next()).floatValue();
            tag.func_74776_a("float" + i, f);
            ++i;
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return nbt;
    }

    public static void readFloatCollection(NBTTagCompound nbt, FloatCollection collection, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            collection.clear();
            int i = 0;
            while (tag.func_74764_b("float" + i)) {
                collection.add(tag.func_74760_g("float" + i));
                ++i;
            }
        }
    }

    public static NBTTagCompound writeDoubleCollection(NBTTagCompound nbt, DoubleCollection collection, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        int i = 0;
        DoubleIterator doubleIterator = collection.iterator();
        while (doubleIterator.hasNext()) {
            double d = (Double)doubleIterator.next();
            tag.func_74780_a("double" + i, d);
            ++i;
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return nbt;
    }

    public static void readDoubleCollection(NBTTagCompound nbt, DoubleCollection collection, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            collection.clear();
            int i = 0;
            while (tag.func_74764_b("double" + i)) {
                collection.add(tag.func_74769_h("double" + i));
                ++i;
            }
        }
    }

    public static NBTTagCompound writeBlockPosToIntegerMap(NBTTagCompound nbt, Map<BlockPos, Integer> map, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        int i = 0;
        for (Map.Entry<BlockPos, Integer> entry : map.entrySet()) {
            NBTHelper.writeBlockPos(tag, entry.getKey(), "pos" + i);
            tag.func_74768_a("int" + i, entry.getValue().intValue());
            ++i;
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return nbt;
    }

    public static void readBlockPosToIntegerMap(NBTTagCompound nbt, Map<BlockPos, Integer> map, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            map.clear();
            int i = 0;
            while (tag.func_74764_b("pos" + i)) {
                map.put(NBTHelper.readBlockPos(tag, "pos" + i), tag.func_74762_e("int" + i));
                ++i;
            }
        }
    }
}

