/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class PosHelper {
    public static final BlockPos DEFAULT_NON = new BlockPos(0, -1, 0);
    private static final EnumFacing[] HORIZONTALS_X = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};
    private static final EnumFacing[] HORIZONTALS_Y = EnumFacing.field_176754_o;
    private static final EnumFacing[] HORIZONTALS_Z = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST};
    private static final EnumFacing[] AXIALS_X = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
    private static final EnumFacing[] AXIALS_Y = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
    private static final EnumFacing[] AXIALS_Z = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH};
    public static final EnumFacing[][] VERTEX_DIRS = new EnumFacing[][]{{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST}, {EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.WEST}, {EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.EAST}};
    public static final EnumFacing[][] EDGE_DIRS = new EnumFacing[][]{{EnumFacing.DOWN, EnumFacing.NORTH}, {EnumFacing.DOWN, EnumFacing.SOUTH}, {EnumFacing.DOWN, EnumFacing.WEST}, {EnumFacing.DOWN, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.SOUTH}, {EnumFacing.UP, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.EAST}, {EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.EAST}};
    public static final EnumFacing[][] PLANE_DIRS = new EnumFacing[][]{{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP}};
    public static final EnumFacing.Axis[] AXES = new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Y, EnumFacing.Axis.Z};
    public static final EnumFacing.AxisDirection[] AXIS_DIRS = new EnumFacing.AxisDirection[]{EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE};

    public static EnumFacing[] getHorizontals(EnumFacing dir) {
        switch (dir) {
            case DOWN: {
                return HORIZONTALS_Y;
            }
            case UP: {
                return HORIZONTALS_Y;
            }
            case NORTH: {
                return HORIZONTALS_Z;
            }
            case SOUTH: {
                return HORIZONTALS_Z;
            }
            case WEST: {
                return HORIZONTALS_X;
            }
            case EAST: {
                return HORIZONTALS_X;
            }
        }
        return HORIZONTALS_Y;
    }

    public static List<EnumFacing[]> axialDirsList() {
        return Lists.newArrayList((Object[])new EnumFacing[][]{AXIALS_X, AXIALS_Y, AXIALS_Z});
    }

    public static EnumFacing[] getAxialDirs(EnumFacing dir) {
        switch (dir) {
            case DOWN: {
                return AXIALS_Y;
            }
            case UP: {
                return AXIALS_Y;
            }
            case NORTH: {
                return AXIALS_Z;
            }
            case SOUTH: {
                return AXIALS_Z;
            }
            case WEST: {
                return AXIALS_X;
            }
            case EAST: {
                return AXIALS_X;
            }
        }
        return AXIALS_Y;
    }

    public static int getAxisIndex(@Nonnull EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? 0 : (axis == EnumFacing.Axis.Y ? 1 : 2);
    }

    public static int getAxisDirIndex(@Nonnull EnumFacing.AxisDirection dir) {
        return dir == EnumFacing.AxisDirection.POSITIVE ? 0 : 1;
    }
}

