/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import nc.util.NCMath;
import net.minecraft.util.math.MathHelper;

public class UnitHelper {
    public static final String[] SI_PREFIX = new String[]{" y", " z", " a", " f", " p", " n", " u", " m", " ", " k", " M", " G", " T", " P", " E", " Z", " Y"};
    public static final String[] SI_PREFIX_2 = new String[]{" y", " z", " a", " f", " p", " n", " u", " m", "", " k", " M", " G", " T", " P", " E", " Z", " Y"};
    public static final String[] TIME_UNIT = new String[]{" ticks", " seconds", " minutes", " hours", " days", " weeks", " years"};
    public static final String[] TIME_UNIT_SHORT = new String[]{" t", " s", " min", " hr", " d", " wk", " y"};
    public static final double[] TIME_MULT = new double[]{1.0, 20.0, 1200.0, 72000.0, 1728000.0, 1.2096E7, 6.3072E8};

    public static String prefix(long value, long max, int maxLength, String unit, int startingPrefix) {
        String sign;
        int minPrefixNumber;
        int prefixNumber = minPrefixNumber = MathHelper.func_76125_a((int)(startingPrefix + 8), (int)0, (int)16);
        boolean hasMax = max != Long.MIN_VALUE;
        String slashMaxVal = !hasMax ? "" : SI_PREFIX_2[prefixNumber] + " / " + max;
        String string = sign = (double)value < 0.0 ? "-" : "";
        if ((double)value == 0.0) {
            return value + slashMaxVal + SI_PREFIX[prefixNumber] + unit;
        }
        value = Math.abs(value);
        max = !hasMax ? value : max;
        long testValue = value;
        long testMax = max;
        while (minPrefixNumber > 0) {
            testValue = NCMath.magnitudeMult(testValue, 3);
            testMax = NCMath.magnitudeMult(testMax, 3);
            --minPrefixNumber;
            if (!NCMath.atLongLimit(testValue, 1000L) && !NCMath.atLongLimit(testMax, 1000L)) continue;
        }
        boolean descending = true;
        int maxLengthFixed = Math.max(maxLength, 3);
        while (prefixNumber < SI_PREFIX.length - 1) {
            int length = NCMath.numberLength(value);
            if (descending) {
                if (length > maxLengthFixed) {
                    descending = false;
                    continue;
                }
                if (value != 0L) {
                    slashMaxVal = !hasMax ? "" : SI_PREFIX_2[prefixNumber] + " / " + max;
                    return sign + value + slashMaxVal + SI_PREFIX[prefixNumber] + unit;
                }
                value = NCMath.magnitudeMult(value, 3);
                max = NCMath.magnitudeMult(max, 3);
                --prefixNumber;
            } else {
                if (length <= maxLengthFixed) {
                    slashMaxVal = !hasMax ? "" : SI_PREFIX_2[prefixNumber] + " / " + max;
                    return sign + value + slashMaxVal + SI_PREFIX[prefixNumber] + unit;
                }
                value = NCMath.magnitudeMult(value, -3);
                max = NCMath.magnitudeMult(max, -3);
                ++prefixNumber;
            }
            if (prefixNumber != minPrefixNumber) continue;
            descending = false;
        }
        slashMaxVal = !hasMax ? "" : SI_PREFIX_2[SI_PREFIX.length - 1] + " / " + NCMath.magnitudeMult(max, -3);
        return sign + NCMath.magnitudeMult(value, -3) + slashMaxVal + SI_PREFIX[SI_PREFIX.length - 1] + unit;
    }

    public static String prefix(long value, int maxLength, String unit, int startingPrefix) {
        return UnitHelper.prefix(value, Long.MIN_VALUE, maxLength, unit, startingPrefix);
    }

    public static String prefix(long value, long max, int maxLength, String unit) {
        return UnitHelper.prefix(value, max, maxLength, unit, 0);
    }

    public static String prefix(long value, int maxLength, String unit) {
        return UnitHelper.prefix(value, maxLength, unit, 0);
    }

    public static String prefix(double value, double max, int maxLength, String unit, int startingPrefix) {
        String sign;
        int minPrefixNumber;
        int prefixNumber = minPrefixNumber = MathHelper.func_76125_a((int)(startingPrefix + 8), (int)0, (int)16);
        boolean hasMax = max != Double.MIN_VALUE;
        String slashMaxVal = !hasMax ? "" : SI_PREFIX_2[prefixNumber] + " / " + (long)max;
        String string = sign = value < 0.0 ? "-" : "";
        if (value == 0.0) {
            return (long)value + slashMaxVal + SI_PREFIX[prefixNumber] + unit;
        }
        value = Math.abs(value);
        max = !hasMax ? value : max;
        double testValue = value;
        double testMax = max;
        while (minPrefixNumber > 0) {
            testValue = NCMath.magnitudeMult(testValue, 3);
            testMax = NCMath.magnitudeMult(testMax, 3);
            --minPrefixNumber;
            if (!NCMath.atDoubleLimit(testValue, 1000.0) && !NCMath.atDoubleLimit(testMax, 1000.0)) continue;
        }
        boolean descending = true;
        int maxLengthFixed = Math.max(maxLength, 3);
        while (prefixNumber < SI_PREFIX.length - 1) {
            int length = NCMath.numberLength((long)value);
            if (descending) {
                if (length > maxLengthFixed) {
                    descending = false;
                    continue;
                }
                if ((long)value != 0L) {
                    slashMaxVal = !hasMax ? "" : SI_PREFIX_2[prefixNumber] + " / " + (long)max;
                    return sign + (long)value + slashMaxVal + SI_PREFIX[prefixNumber] + unit;
                }
                value = NCMath.magnitudeMult(value, 3);
                max = NCMath.magnitudeMult(max, 3);
                --prefixNumber;
            } else {
                if (length <= maxLengthFixed) {
                    slashMaxVal = !hasMax ? "" : SI_PREFIX_2[prefixNumber] + " / " + (long)max;
                    return sign + (long)value + slashMaxVal + SI_PREFIX[prefixNumber] + unit;
                }
                value = NCMath.magnitudeMult(value, -3);
                max = NCMath.magnitudeMult(max, -3);
                ++prefixNumber;
            }
            if (prefixNumber != minPrefixNumber) continue;
            descending = false;
        }
        slashMaxVal = !hasMax ? "" : SI_PREFIX_2[SI_PREFIX.length - 1] + " / " + (long)NCMath.magnitudeMult(max, -3);
        return sign + (long)NCMath.magnitudeMult(value, -3) + slashMaxVal + SI_PREFIX[SI_PREFIX.length - 1] + unit;
    }

    public static String prefix(double value, int maxLength, String unit, int startingPrefix) {
        return UnitHelper.prefix(value, Double.MIN_VALUE, maxLength, unit, startingPrefix);
    }

    public static String prefix(double value, double max, int maxLength, String unit) {
        return UnitHelper.prefix(value, max, maxLength, unit, 0);
    }

    public static String prefix(double value, int maxLength, String unit) {
        return UnitHelper.prefix(value, maxLength, unit, 0);
    }

    public static String applyTimeUnit(long ticks, int maxLength) {
        return UnitHelper.applyTimeUnit(ticks, maxLength, 0);
    }

    public static String applyTimeUnit(double ticks, int maxLength) {
        return UnitHelper.applyTimeUnit(ticks, maxLength, 0);
    }

    public static String applyTimeUnit(long ticks, int maxLength, int startUnit) {
        int i = startUnit;
        while (Long.toString(Math.round((double)ticks / TIME_MULT[i])).length() > maxLength) {
            ++i;
        }
        return Math.round((double)ticks / TIME_MULT[i]) + TIME_UNIT[i];
    }

    public static String applyTimeUnit(double ticks, int maxLength, int startUnit) {
        if (ticks < 1.0) {
            return NCMath.decimalPlaces(ticks, 3) + " ticks";
        }
        int i = startUnit;
        while (Long.toString(Math.round(ticks / TIME_MULT[i])).length() > maxLength) {
            ++i;
        }
        return Math.round(ticks / TIME_MULT[i]) + TIME_UNIT[i];
    }

    public static String applyTimeUnitShort(long ticks, int maxLength) {
        return UnitHelper.applyTimeUnitShort(ticks, maxLength, 0);
    }

    public static String applyTimeUnitShort(double ticks, int maxLength) {
        return UnitHelper.applyTimeUnitShort(ticks, maxLength, 0);
    }

    public static String applyTimeUnitShort(long ticks, int maxLength, int startUnit) {
        int i = startUnit;
        while (Long.toString(Math.round((double)ticks / TIME_MULT[i])).length() > maxLength) {
            ++i;
        }
        return Math.round((double)ticks / TIME_MULT[i]) + TIME_UNIT_SHORT[i];
    }

    public static String applyTimeUnitShort(double ticks, int maxLength, int startUnit) {
        if (ticks < 1.0) {
            return NCMath.decimalPlaces(ticks, 3) + " t";
        }
        int i = startUnit;
        while (Long.toString(Math.round(ticks / TIME_MULT[i])).length() > maxLength) {
            ++i;
        }
        return Math.round(ticks / TIME_MULT[i]) + TIME_UNIT_SHORT[i];
    }
}

