/*
 * Decompiled with CFR 0.152.
 */
package nc.worldgen.biome;

import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class NCBiome
extends Biome {
    public IBlockState airBlock = field_185366_b;
    public IBlockState bedrockBlock = field_185367_c;
    public IBlockState stoneBlock = field_185365_a;
    public IBlockState gravelBlock = field_185368_d;
    public IBlockState waterBlock = field_185372_h;
    public IBlockState frozenBlock = field_185371_g;

    public NCBiome(Biome.BiomeProperties properties) {
        super(properties);
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public void generateTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int seaLevel = worldIn.func_181545_F();
        IBlockState topBlockState = this.field_76752_A;
        IBlockState fillerBlockState = this.field_76753_B;
        int heightCount = -1;
        int noise = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int chunkPosX = x & 0xF;
        int chunkPosZ = z & 0xF;
        BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
        for (int posY = 255; posY >= 0; --posY) {
            if (posY <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, this.bedrockBlock);
                continue;
            }
            IBlockState currentBlockState = chunkPrimerIn.func_177856_a(chunkPosX, posY, chunkPosZ);
            if (currentBlockState.func_185904_a() == Material.field_151579_a) {
                heightCount = -1;
                continue;
            }
            if (currentBlockState.func_177230_c() != this.stoneBlock.func_177230_c()) continue;
            if (heightCount == -1) {
                if (noise <= 0) {
                    topBlockState = this.airBlock;
                    fillerBlockState = this.stoneBlock;
                } else if (posY >= seaLevel - 4 && posY <= seaLevel + 1) {
                    topBlockState = this.field_76752_A;
                    fillerBlockState = this.field_76753_B;
                }
                if (posY < seaLevel && (topBlockState == null || topBlockState.func_185904_a() == Material.field_151579_a)) {
                    topBlockState = this.func_180626_a((BlockPos)mutableblockpos.func_181079_c(x, posY, z)) < 0.15f ? this.frozenBlock : this.waterBlock;
                }
                heightCount = noise;
                if (posY >= seaLevel - 1) {
                    chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, topBlockState);
                    continue;
                }
                if (posY < seaLevel - 7 - noise) {
                    topBlockState = this.airBlock;
                    fillerBlockState = this.stoneBlock;
                    chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, this.gravelBlock);
                    continue;
                }
                chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, fillerBlockState);
                continue;
            }
            if (heightCount <= 0) continue;
            chunkPrimerIn.func_177855_a(chunkPosX, posY, chunkPosZ, fillerBlockState);
            if (--heightCount != 0 || fillerBlockState != Blocks.field_150354_m || noise <= 1) continue;
            heightCount = rand.nextInt(4) + Math.max(0, posY - 63);
            fillerBlockState = this.getSandstoneTerrainBlock(chunkPosX, posY, chunkPosZ, fillerBlockState);
        }
    }

    public IBlockState getSandstoneTerrainBlock(int chunkPosX, int posY, int chunkPosZ, IBlockState sandState) {
        return sandState.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? field_185369_e : field_185370_f;
    }
}

