/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.api;

import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.UpdateHudColorPacket;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IDeconstructable;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.misc.NNLUtil;
import flaxbeard.cyberware.common.network.CyberwareSyncPacket;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class CyberwareAPI {
    public static final String DATA_TAG = "cyberwareFunctionData";
    public static final String QUALITY_TAG = "cyberwareQuality";
    public static final ICyberware.Quality QUALITY_SCAVENGED = new ICyberware.Quality("cyberware.quality.scavenged", "cyberware.quality.scavenged.name_modifier", "scavenged");
    public static final ICyberware.Quality QUALITY_MANUFACTURED = new ICyberware.Quality("cyberware.quality.manufactured");
    @CapabilityInject(value=ICyberwareUserData.class)
    public static final Capability<ICyberwareUserData> CYBERWARE_CAPABILITY = null;
    public static final IAttribute TOLERANCE_ATTR = new RangedAttribute(null, "cyberware.tolerance", (double)CyberwareConfig.ESSENCE, 0.0, Double.MAX_VALUE).func_111117_a("Tolerance").func_111112_a(true);
    public static Map<ItemStack, ICyberware> linkedWare = new HashMap<ItemStack, ICyberware>();
    public static SimpleNetworkWrapper PACKET_HANDLER;

    @SideOnly(value=Side.CLIENT)
    public static void setHUDColor(float[] color) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData != null) {
            cyberwareUserData.setHudColor(color);
        }
    }

    public static void syncHUDColor() {
        PACKET_HANDLER.sendToServer((IMessage)new UpdateHudColorPacket(CyberwareAPI.getHUDColorHex()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void setHUDColor(int hexVal) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData != null) {
            cyberwareUserData.setHudColor(hexVal);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setHUDColor(float r, float g, float b) {
        CyberwareAPI.setHUDColor(new float[]{r, g, b});
    }

    @SideOnly(value=Side.CLIENT)
    public static int getHUDColorHex() {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData != null) {
            return cyberwareUserData.getHudColorHex();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static float[] getHUDColor() {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData != null) {
            return cyberwareUserData.getHudColor();
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public static ItemStack writeQualityTag(@Nonnull ItemStack stack, @Nonnull ICyberware.Quality quality) {
        if (stack.func_190926_b()) {
            return stack;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        tagCompound.func_74778_a(QUALITY_TAG, quality.getUnlocalizedName());
        return stack;
    }

    @Nullable
    public static ICyberware.Quality getQualityTag(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_150297_b(QUALITY_TAG, 8)) {
            return null;
        }
        return ICyberware.Quality.getQualityFromString(stack.func_77978_p().func_74779_i(QUALITY_TAG));
    }

    public static ItemStack sanitize(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null && tagCompound.func_74764_b(DATA_TAG)) {
                tagCompound.func_82580_o(DATA_TAG);
            }
            if (tagCompound != null && tagCompound.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
        return stack;
    }

    @Nonnull
    public static NBTTagCompound getCyberwareNBT(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        if (!tagCompound.func_74764_b(DATA_TAG)) {
            tagCompound.func_74782_a(DATA_TAG, (NBTBase)new NBTTagCompound());
        }
        return tagCompound.func_74775_l(DATA_TAG);
    }

    public static boolean areCyberwareStacksEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        ItemStack sanitized1 = CyberwareAPI.sanitize(stack1.func_77946_l());
        ItemStack sanitized2 = CyberwareAPI.sanitize(stack2.func_77946_l());
        return sanitized1.func_77973_b() == sanitized2.func_77973_b() && sanitized1.func_77952_i() == sanitized2.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void linkCyberware(@Nonnull ItemStack stack, ICyberware link) {
        if (stack.func_190926_b()) {
            return;
        }
        ItemStack key = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
        linkedWare.put(key, link);
    }

    public static void linkCyberware(Item item, ICyberware link) {
        if (item == null) {
            return;
        }
        ItemStack key = new ItemStack(item, 1, Short.MAX_VALUE);
        linkedWare.put(key, link);
    }

    public static boolean isCyberware(@Nullable ItemStack stack) {
        if (stack != null) {
            return !stack.func_190926_b() && (stack.func_77973_b() instanceof ICyberware || CyberwareAPI.getLinkedWare(stack) != null);
        }
        return false;
    }

    public static ICyberware getCyberware(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ICyberware) {
                return (ICyberware)stack.func_77973_b();
            }
            if (CyberwareAPI.getLinkedWare(stack) != null) {
                return CyberwareAPI.getLinkedWare(stack);
            }
        }
        throw new RuntimeException("Cannot call getCyberware on a non-cyberware item!");
    }

    public static boolean canDeconstruct(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IDeconstructable && ((IDeconstructable)stack.func_77973_b()).canDestroy(stack);
    }

    public static NonNullList<ItemStack> getComponents(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IDeconstructable) {
            return NNLUtil.copyList(((IDeconstructable)stack.func_77973_b()).getComponents(stack));
        }
        throw new RuntimeException("Cannot call getComponents on a non-cyberware or non deconstructable item!");
    }

    @Nullable
    private static ICyberware getLinkedWare(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return CyberwareAPI.getWareFromKey(stack);
    }

    @Nullable
    private static ICyberware getWareFromKey(@Nonnull ItemStack key) {
        for (Map.Entry<ItemStack, ICyberware> entry : linkedWare.entrySet()) {
            ItemStack entryKey = entry.getKey();
            if (key.func_77973_b() != entryKey.func_77973_b() || entryKey.func_77952_i() != Short.MAX_VALUE && entryKey.func_77952_i() != key.func_77952_i()) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static ICyberwareUserData getCapabilityOrNull(@Nullable Entity targetEntity) {
        if (targetEntity == null) {
            return null;
        }
        return (ICyberwareUserData)targetEntity.getCapability(CYBERWARE_CAPABILITY, EnumFacing.EAST);
    }

    @Deprecated
    public static boolean hasCapability(@Nullable Entity targetEntity) {
        return CyberwareAPI.getCapabilityOrNull(targetEntity) != null;
    }

    @Deprecated
    public static ICyberwareUserData getCapability(@Nonnull Entity targetEntity) {
        return CyberwareAPI.getCapabilityOrNull(targetEntity);
    }

    @Deprecated
    public static boolean isCyberwareInstalled(@Nullable Entity targetEntity, ItemStack stack) {
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull(targetEntity);
        return cyberwareUserData != null && cyberwareUserData.isCyberwareInstalled(stack);
    }

    @Deprecated
    public static int getCyberwareRank(@Nullable Entity targetEntity, ItemStack stack) {
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull(targetEntity);
        return cyberwareUserData == null ? 0 : cyberwareUserData.getCyberwareRank(stack);
    }

    @Deprecated
    public static ItemStack getCyberware(@Nullable Entity targetEntity, ItemStack stack) {
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull(targetEntity);
        return cyberwareUserData == null ? ItemStack.field_190927_a : cyberwareUserData.getCyberware(stack);
    }

    public static void updateData(Entity targetEntity) {
        if (!targetEntity.field_70170_p.field_72995_K) {
            WorldServer world = (WorldServer)targetEntity.field_70170_p;
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull(targetEntity);
            if (cyberwareUserData == null) {
                return;
            }
            NBTTagCompound tagCompound = cyberwareUserData.serializeNBT();
            if (targetEntity instanceof EntityPlayer) {
                PACKET_HANDLER.sendTo((IMessage)new CyberwareSyncPacket(tagCompound, targetEntity.func_145782_y()), (EntityPlayerMP)targetEntity);
            }
            for (EntityPlayer trackingPlayer : world.func_73039_n().getTrackingPlayers(targetEntity)) {
                PACKET_HANDLER.sendTo((IMessage)new CyberwareSyncPacket(tagCompound, targetEntity.func_145782_y()), (EntityPlayerMP)trackingPlayer);
            }
        }
    }

    public static void useActiveItem(Entity entity, ItemStack stack) {
        ((IMenuItem)stack.func_77973_b()).use(entity, stack);
    }
}

