/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client;

import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.client.KeyBinds;
import flaxbeard.cyberware.client.ShaderUtil;
import flaxbeard.cyberware.client.gui.InventoryTabFineManipulators;
import flaxbeard.cyberware.client.render.CyberwareMeshDefinition;
import flaxbeard.cyberware.client.render.RenderCyberZombie;
import flaxbeard.cyberware.client.render.TileEntityBeaconLargeRenderer;
import flaxbeard.cyberware.client.render.TileEntityEngineeringRenderer;
import flaxbeard.cyberware.client.render.TileEntityScannerRenderer;
import flaxbeard.cyberware.client.render.TileEntitySurgeryChamberRenderer;
import flaxbeard.cyberware.common.CommonProxy;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.tile.TileEntityBeaconPost;
import flaxbeard.cyberware.common.block.tile.TileEntityEngineeringTable;
import flaxbeard.cyberware.common.block.tile.TileEntityScanner;
import flaxbeard.cyberware.common.block.tile.TileEntitySurgery;
import flaxbeard.cyberware.common.block.tile.TileEntitySurgeryChamber;
import flaxbeard.cyberware.common.entity.EntityCyberZombie;
import flaxbeard.cyberware.common.handler.CreativeMenuHandler;
import flaxbeard.cyberware.common.handler.CyberwareMenuHandler;
import flaxbeard.cyberware.common.handler.EssentialsMissingHandlerClient;
import flaxbeard.cyberware.common.handler.HudHandler;
import flaxbeard.cyberware.common.item.ItemArmorCyberware;
import flaxbeard.cyberware.common.item.ItemBlueprint;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.item.ItemCyberwareBase;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabVanilla;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        for (Block block : CyberwareContent.blocks) {
            this.registerRenders(block);
        }
        for (Item item : CyberwareContent.items) {
            this.registerRenders(item);
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySurgeryChamber.class, (TileEntitySpecialRenderer)new TileEntitySurgeryChamberRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityCyberZombie.class, RenderCyberZombie::new);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityScanner.class, (TileEntitySpecialRenderer)new TileEntityScannerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEngineeringTable.class, (TileEntitySpecialRenderer)new TileEntityEngineeringRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBeaconPost.TileEntityBeaconPostMaster.class, (TileEntitySpecialRenderer)new TileEntityBeaconLargeRenderer());
    }

    @Override
    public void init() {
        super.init();
        KeyBinds.init();
        MinecraftForge.EVENT_BUS.register((Object)EssentialsMissingHandlerClient.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)CreativeMenuHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)CyberwareMenuHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)HudHandler.INSTANCE);
        ShaderUtil.init();
        if (CyberwareConfig.ENABLE_CLOTHES) {
            Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

                public int func_186726_a(ItemStack stack, int tintIndex) {
                    return tintIndex > 0 ? -1 : ((ItemArmorCyberware)stack.func_77973_b()).func_82814_b(stack);
                }
            }, new Item[]{CyberwareContent.trenchCoat});
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
        if (TabRegistry.getTabList().size() == 0) {
            TabRegistry.registerTab(new InventoryTabVanilla());
        }
        TabRegistry.registerTab(new InventoryTabFineManipulators());
    }

    private void registerRenders(Block block) {
        Item item = Item.func_150898_a((Block)block);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }

    private void registerRenders(Item item) {
        if (item instanceof ItemCyberware) {
            ItemCyberware ware = (ItemCyberware)item;
            ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
            if (ware.subnames.length > 0) {
                for (int indexSubname = 0; indexSubname < ware.subnames.length; ++indexSubname) {
                    String name = ware.getRegistryName() + "_" + ware.subnames[indexSubname];
                    for (ICyberware.Quality quality : ICyberware.Quality.qualities) {
                        if (quality.getSpriteSuffix() == null || !ware.canHoldQuality(new ItemStack((Item)ware, 1, indexSubname), quality)) continue;
                        models.add(new ModelResourceLocation(name + "_" + quality.getSpriteSuffix(), "inventory"));
                    }
                    models.add(new ModelResourceLocation(name, "inventory"));
                }
            } else {
                String name = ware.getRegistryName() + "";
                for (ICyberware.Quality quality : ICyberware.Quality.qualities) {
                    if (quality.getSpriteSuffix() == null || !ware.canHoldQuality(new ItemStack((Item)ware), quality)) continue;
                    models.add(new ModelResourceLocation(name + "_" + quality.getSpriteSuffix(), "inventory"));
                }
                models.add(new ModelResourceLocation(name, "inventory"));
            }
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])((ResourceLocation[])models.toArray(new ModelResourceLocation[0])));
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new CyberwareMeshDefinition());
        } else if (item instanceof ItemBlueprint) {
            for (int i = 0; i < 2; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + (i == 1 ? "_blank" : ""), "inventory"));
            }
        } else if (item instanceof ItemCyberwareBase) {
            ItemCyberwareBase base = (ItemCyberwareBase)item;
            if (base.subnames.length > 0) {
                for (int indexSubname = 0; indexSubname < base.subnames.length; ++indexSubname) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)indexSubname, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + base.subnames[indexSubname], "inventory"));
                }
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @Override
    public void wrong(TileEntitySurgery tileEntitySurgery) {
        tileEntitySurgery.ticksWrong = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
    }

    @Override
    public boolean workingOnPlayer(EntityLivingBase entityLivingBase) {
        return entityLivingBase == Minecraft.func_71410_x().field_71439_g;
    }
}

