/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui;

import flaxbeard.cyberware.common.block.tile.TileEntityComponentBox;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerComponentBox
extends Container {
    private ItemStackHandler slots;
    private int numRows;
    private final TileEntityComponentBox box;
    private final ItemStack item;

    public ContainerComponentBox(IInventory playerInventory, @Nonnull TileEntityComponentBox box) {
        this.box = box;
        this.item = ItemStack.field_190927_a;
        this.slots = box.slots;
        this.numRows = this.slots.getSlots() / 9;
        this.addSlots(playerInventory);
    }

    public ContainerComponentBox(IInventory playerInventory, @Nonnull ItemStack itemStack) {
        this.box = null;
        this.item = itemStack;
        this.slots = new TileEntityComponentBox.ItemStackHandlerComponent(18);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && itemStack.func_77978_p().func_74764_b("contents")) {
            this.slots.deserializeNBT(tagCompound.func_74775_l("contents"));
        }
        this.numRows = this.slots.getSlots() / 9;
        this.addSlots(playerInventory);
    }

    private void addSlots(IInventory playerInventory) {
        int indexColumn;
        int indexRow;
        int yOffset = (this.numRows - 4) * 18;
        for (indexRow = 0; indexRow < this.numRows; ++indexRow) {
            for (indexColumn = 0; indexColumn < 9; ++indexColumn) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.slots, indexColumn + indexRow * 9, 8 + indexColumn * 18, 18 + indexRow * 18));
            }
        }
        for (indexRow = 0; indexRow < 3; ++indexRow) {
            for (indexColumn = 0; indexColumn < 9; ++indexColumn) {
                this.func_75146_a(new Slot(playerInventory, indexColumn + indexRow * 9 + 9, 8 + indexColumn * 18, 103 + indexRow * 18 + yOffset));
            }
        }
        for (int indexColumn2 = 0; indexColumn2 < 9; ++indexColumn2) {
            this.func_75146_a(new Slot(playerInventory, indexColumn2, 8 + indexColumn2 * 18, 161 + yOffset));
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer entityPlayer) {
        return this.box == null ? entityPlayer.field_71071_by.field_70462_a.get(entityPlayer.field_71071_by.field_70461_c) == this.item : this.box.isUsableByPlayer(entityPlayer);
    }

    public void func_75134_a(@Nonnull EntityPlayer entityPlayer) {
        super.func_75134_a(entityPlayer);
        if (!this.item.func_190926_b()) {
            NBTTagCompound tagCompoundSlots = this.slots.serializeNBT();
            NBTTagCompound tagCompoundItem = this.item.func_77978_p();
            if (tagCompoundItem == null) {
                tagCompoundItem = new NBTTagCompound();
                this.item.func_77982_d(tagCompoundItem);
            }
            tagCompoundItem.func_74782_a("contents", (NBTBase)tagCompoundSlots);
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer entityPlayer, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.numRows * 9 ? !this.func_75135_a(itemstack1, this.numRows * 9, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.numRows * 9, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }
}

