/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.handler;

import com.google.common.base.Preconditions;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.client.render.RenderCyberlimbHand;
import flaxbeard.cyberware.client.render.RenderPlayerCyberware;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberlimb;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EssentialsMissingHandlerClient {
    public static final EssentialsMissingHandlerClient INSTANCE = new EssentialsMissingHandlerClient();
    @SideOnly(value=Side.CLIENT)
    private static final RenderPlayerCyberware renderSmallArms = new RenderPlayerCyberware(Minecraft.func_71410_x().func_175598_ae(), true);
    @SideOnly(value=Side.CLIENT)
    public static final RenderPlayerCyberware renderLargeArms = new RenderPlayerCyberware(Minecraft.func_71410_x().func_175598_ae(), false);
    private static Map<Integer, ItemStack> mainHand = new HashMap<Integer, ItemStack>();
    private static Map<Integer, ItemStack> offHand = new HashMap<Integer, ItemStack>();
    private static Map<Integer, ItemStack> pants = new HashMap<Integer, ItemStack>();
    private static Map<Integer, ItemStack> shoes = new HashMap<Integer, ItemStack>();
    private static boolean missingArm = false;
    private static boolean missingSecondArm = false;
    private static boolean hasRoboLeft = false;
    private static boolean hasRoboRight = false;
    private static EnumHandSide oldHand;
    private static final Minecraft mc;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleMissingSkin(RenderPlayerEvent.Pre event) {
        if (!CyberwareConfig.ENABLE_CUSTOM_PLAYER_MODEL) {
            return;
        }
        EntityPlayer entityPlayer = event.getEntityPlayer();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData == null) {
            return;
        }
        boolean hasLeftLeg = cyberwareUserData.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.LEFT);
        boolean hasRightLeg = cyberwareUserData.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.RIGHT);
        boolean hasLeftArm = cyberwareUserData.hasEssential(ICyberware.EnumSlot.ARM, ICyberware.ISidedLimb.EnumSide.LEFT);
        boolean hasRightArm = cyberwareUserData.hasEssential(ICyberware.EnumSlot.ARM, ICyberware.ISidedLimb.EnumSide.RIGHT);
        boolean robotLeftArm = cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(0));
        boolean robotRightArm = cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(1));
        boolean robotLeftLeg = cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(2));
        boolean robotRightLeg = cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(3));
        RenderPlayer renderPlayer = event.getRenderer();
        if (!(renderPlayer instanceof RenderPlayerCyberware)) {
            boolean hasNoLegs;
            boolean hasNoSkin;
            boolean useSmallArms = renderPlayer.field_177140_a;
            RenderPlayerCyberware renderToUse = useSmallArms ? renderSmallArms : renderLargeArms;
            boolean bl = hasNoSkin = !cyberwareUserData.hasEssential(ICyberware.EnumSlot.SKIN);
            if (hasNoSkin) {
                event.setCanceled(true);
                renderToUse.doMuscles = true;
            }
            boolean bl2 = hasNoLegs = !hasRightLeg && !hasLeftLeg;
            if (hasNoLegs) {
                if (!pants.containsKey(entityPlayer.func_145782_y())) {
                    pants.put(entityPlayer.func_145782_y(), (ItemStack)entityPlayer.field_71071_by.field_70460_b.set(EntityEquipmentSlot.LEGS.func_188454_b(), (Object)ItemStack.field_190927_a));
                }
                if (!shoes.containsKey(entityPlayer.func_145782_y())) {
                    shoes.put(entityPlayer.func_145782_y(), (ItemStack)entityPlayer.field_71071_by.field_70460_b.set(EntityEquipmentSlot.FEET.func_188454_b(), (Object)ItemStack.field_190927_a));
                }
            }
            if (!hasRightLeg || !hasLeftLeg || !hasRightArm || !hasLeftArm || robotRightLeg || robotLeftLeg || robotRightArm || robotLeftArm) {
                event.setCanceled(true);
                boolean leftArmRusty = robotLeftArm && CyberwareContent.cyberlimbs.getQuality(cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(0))) == CyberwareAPI.QUALITY_SCAVENGED;
                boolean rightArmRusty = robotRightArm && CyberwareContent.cyberlimbs.getQuality(cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(1))) == CyberwareAPI.QUALITY_SCAVENGED;
                boolean leftLegRusty = robotLeftLeg && CyberwareContent.cyberlimbs.getQuality(cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(2))) == CyberwareAPI.QUALITY_SCAVENGED;
                boolean rightLegRusty = robotRightLeg && CyberwareContent.cyberlimbs.getQuality(cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(3))) == CyberwareAPI.QUALITY_SCAVENGED;
                renderToUse.doRobo = false;
                renderToUse.doRusty = false;
                renderToUse.func_76986_a((AbstractClientPlayer)entityPlayer, event.getX(), event.getY() - (double)(hasNoLegs ? 0.6875f : 0.0f), event.getZ(), entityPlayer.field_70177_z, event.getPartialRenderTick());
                if (!cyberwareUserData.isCyberwareInstalled(CyberwareContent.skinUpgrades.getCachedStack(2))) {
                    ModelPlayer mainModel = renderToUse.func_177087_b();
                    mainModel.field_78115_e.field_78807_k = true;
                    mainModel.field_78116_c.field_78807_k = true;
                    mainModel.field_178724_i.field_78807_k = !robotLeftArm || leftArmRusty;
                    mainModel.field_178723_h.field_78807_k = !robotRightArm || rightArmRusty;
                    mainModel.field_178722_k.field_78807_k = !robotLeftLeg || leftLegRusty;
                    boolean bl3 = mainModel.field_178721_j.field_78807_k = !robotRightLeg || rightLegRusty;
                    if (!(mainModel.field_178724_i.field_78807_k && mainModel.field_178723_h.field_78807_k && mainModel.field_178722_k.field_78807_k && mainModel.field_178721_j.field_78807_k)) {
                        renderToUse.doRobo = true;
                        renderToUse.doRusty = false;
                        renderToUse.func_76986_a((AbstractClientPlayer)entityPlayer, event.getX(), event.getY() - (double)(hasNoLegs ? 0.6875f : 0.0f), event.getZ(), entityPlayer.field_70177_z, event.getPartialRenderTick());
                    }
                    mainModel.field_178724_i.field_78807_k = !leftArmRusty;
                    mainModel.field_178723_h.field_78807_k = !rightArmRusty;
                    mainModel.field_178722_k.field_78807_k = !leftLegRusty;
                    boolean bl4 = mainModel.field_178721_j.field_78807_k = !rightLegRusty;
                    if (!(mainModel.field_178724_i.field_78807_k && mainModel.field_178723_h.field_78807_k && mainModel.field_178722_k.field_78807_k && mainModel.field_178721_j.field_78807_k)) {
                        renderToUse.doRobo = true;
                        renderToUse.doRusty = true;
                        renderToUse.func_76986_a((AbstractClientPlayer)entityPlayer, event.getX(), event.getY() - (double)(hasNoLegs ? 0.6875f : 0.0f), event.getZ(), entityPlayer.field_70177_z, event.getPartialRenderTick());
                    }
                    mainModel.field_78115_e.field_78807_k = false;
                    mainModel.field_78116_c.field_78807_k = false;
                    mainModel.field_178724_i.field_78807_k = false;
                    mainModel.field_178723_h.field_78807_k = false;
                    mainModel.field_178722_k.field_78807_k = false;
                    mainModel.field_178721_j.field_78807_k = false;
                }
            } else if (hasNoSkin) {
                renderToUse.func_76986_a((AbstractClientPlayer)entityPlayer, event.getX(), event.getY(), event.getZ(), entityPlayer.field_70177_z, event.getPartialRenderTick());
            }
            if (hasNoSkin) {
                renderToUse.doMuscles = false;
            }
        }
        if (!hasLeftLeg) {
            renderPlayer.func_177087_b().field_178722_k.field_78807_k = true;
        }
        if (!hasRightLeg) {
            renderPlayer.func_177087_b().field_178721_j.field_78807_k = true;
        }
        if (!hasLeftArm) {
            renderPlayer.func_177087_b().field_178724_i.field_78807_k = true;
            if (EssentialsMissingHandlerClient.mc.field_71474_y.field_186715_A == EnumHandSide.LEFT) {
                if (!mainHand.containsKey(entityPlayer.func_145782_y()) && InventoryPlayer.func_184435_e((int)entityPlayer.field_71071_by.field_70461_c)) {
                    mainHand.put(entityPlayer.func_145782_y(), (ItemStack)entityPlayer.field_71071_by.field_70462_a.set(entityPlayer.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a));
                }
            } else if (!offHand.containsKey(entityPlayer.func_145782_y())) {
                offHand.put(entityPlayer.func_145782_y(), (ItemStack)entityPlayer.field_71071_by.field_184439_c.set(0, (Object)ItemStack.field_190927_a));
            }
        }
        if (!hasRightArm) {
            renderPlayer.func_177087_b().field_178723_h.field_78807_k = true;
            if (EssentialsMissingHandlerClient.mc.field_71474_y.field_186715_A == EnumHandSide.RIGHT) {
                if (!mainHand.containsKey(entityPlayer.func_145782_y()) && InventoryPlayer.func_184435_e((int)entityPlayer.field_71071_by.field_70461_c)) {
                    mainHand.put(entityPlayer.func_145782_y(), (ItemStack)entityPlayer.field_71071_by.field_70462_a.set(entityPlayer.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a));
                }
            } else if (!offHand.containsKey(entityPlayer.func_145782_y())) {
                offHand.put(entityPlayer.func_145782_y(), (ItemStack)entityPlayer.field_71071_by.field_184439_c.set(0, (Object)ItemStack.field_190927_a));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleMissingSkin(RenderPlayerEvent.Post event) {
        if (!CyberwareConfig.ENABLE_CUSTOM_PLAYER_MODEL) {
            return;
        }
        event.getRenderer().func_177087_b().field_178724_i.field_78807_k = false;
        event.getRenderer().func_177087_b().field_178723_h.field_78807_k = false;
        event.getRenderer().func_177087_b().field_178722_k.field_78807_k = false;
        event.getRenderer().func_177087_b().field_178721_j.field_78807_k = false;
        EntityPlayer entityPlayer = event.getEntityPlayer();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData != null) {
            if (pants.containsKey(entityPlayer.func_145782_y())) {
                entityPlayer.field_71071_by.field_70460_b.set(EntityEquipmentSlot.LEGS.func_188454_b(), (Object)pants.remove(entityPlayer.func_145782_y()));
            }
            if (shoes.containsKey(entityPlayer.func_145782_y())) {
                entityPlayer.field_71071_by.field_70460_b.set(EntityEquipmentSlot.FEET.func_188454_b(), (Object)shoes.remove(entityPlayer.func_145782_y()));
            }
            if (mainHand.containsKey(entityPlayer.func_145782_y())) {
                entityPlayer.field_71071_by.field_70462_a.set(entityPlayer.field_71071_by.field_70461_c, (Object)mainHand.remove(entityPlayer.func_145782_y()));
            }
            if (offHand.containsKey(entityPlayer.func_145782_y())) {
                entityPlayer.field_71071_by.field_184439_c.set(0, (Object)offHand.remove(entityPlayer.func_145782_y()));
            }
            if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.ARM, ICyberware.ISidedLimb.EnumSide.LEFT)) {
                event.getRenderer().func_177087_b().field_178724_i.field_78807_k = false;
            }
            if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.ARM, ICyberware.ISidedLimb.EnumSide.RIGHT)) {
                event.getRenderer().func_177087_b().field_178723_h.field_78807_k = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleMissingEssentials(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData != null) {
            boolean hasLeftArm;
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            boolean stillMissingArm = false;
            boolean stillMissingSecondArm = false;
            boolean leftUnpowered = false;
            ItemStack armLeft = cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(0));
            if (!armLeft.func_190926_b() && !ItemCyberlimb.isPowered(armLeft)) {
                leftUnpowered = true;
            }
            boolean rightUnpowered = false;
            ItemStack armRight = cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(1));
            if (!armRight.func_190926_b() && !ItemCyberlimb.isPowered(armRight)) {
                rightUnpowered = true;
            }
            boolean hasSkin = cyberwareUserData.isCyberwareInstalled(CyberwareContent.skinUpgrades.getCachedStack(2));
            hasRoboLeft = !armLeft.func_190926_b() && !hasSkin;
            hasRoboRight = !armRight.func_190926_b() && !hasSkin;
            boolean hasRightArm = cyberwareUserData.hasEssential(ICyberware.EnumSlot.ARM, ICyberware.ISidedLimb.EnumSide.RIGHT) && !rightUnpowered;
            boolean bl = hasLeftArm = cyberwareUserData.hasEssential(ICyberware.EnumSlot.ARM, ICyberware.ISidedLimb.EnumSide.LEFT) && !leftUnpowered;
            if (!hasRightArm) {
                if (settings.field_186715_A != EnumHandSide.LEFT) {
                    oldHand = settings.field_186715_A;
                    settings.field_186715_A = EnumHandSide.LEFT;
                    settings.func_82879_c();
                }
                missingArm = true;
                stillMissingArm = true;
                if (!hasLeftArm) {
                    missingSecondArm = true;
                    stillMissingSecondArm = true;
                }
            } else if (!hasLeftArm) {
                if (settings.field_186715_A != EnumHandSide.RIGHT) {
                    oldHand = settings.field_186715_A;
                    settings.field_186715_A = EnumHandSide.RIGHT;
                    settings.func_82879_c();
                }
                missingArm = true;
                stillMissingArm = true;
            }
            if (!stillMissingArm) {
                missingArm = false;
                if (oldHand != null) {
                    settings.field_186715_A = oldHand;
                    settings.func_82879_c();
                    oldHand = null;
                }
            }
            if (!stillMissingSecondArm) {
                missingSecondArm = false;
            }
        }
    }

    @SubscribeEvent
    public void handleRenderHand(RenderHandEvent event) {
        if (!CyberwareConfig.ENABLE_CUSTOM_PLAYER_MODEL || FMLClientHandler.instance().hasOptifine()) {
            return;
        }
        if (missingArm || missingSecondArm || hasRoboLeft || hasRoboRight) {
            boolean isSleeping;
            float partialTicks = event.getPartialTicks();
            EntityRenderer entityRenderer = EssentialsMissingHandlerClient.mc.field_71460_t;
            event.setCanceled(true);
            boolean bl = isSleeping = mc.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)mc.func_175606_aa()).func_70608_bn();
            if (!(EssentialsMissingHandlerClient.mc.field_71474_y.field_74320_O != 0 || isSleeping || EssentialsMissingHandlerClient.mc.field_71474_y.field_74319_N || EssentialsMissingHandlerClient.mc.field_71442_b.func_78747_a())) {
                entityRenderer.func_180436_i();
                this.renderItemInFirstPerson(partialTicks);
                entityRenderer.func_175072_h();
            }
        }
    }

    public static <T> T firstNonNull(@Nullable T first, @Nullable T second) {
        return (T)(first != null ? first : Preconditions.checkNotNull(second));
    }

    private void renderItemInFirstPerson(float partialTicks) {
        ItemStack itemstack;
        ItemRenderer itemRenderer = mc.func_175597_ag();
        EntityPlayerSP abstractclientplayer = EssentialsMissingHandlerClient.mc.field_71439_g;
        float swingProgress = abstractclientplayer.func_70678_g(partialTicks);
        EnumHand enumhand = EssentialsMissingHandlerClient.firstNonNull(abstractclientplayer.field_184622_au, EnumHand.MAIN_HAND);
        float rotationPitch = abstractclientplayer.field_70127_C + (abstractclientplayer.field_70125_A - abstractclientplayer.field_70127_C) * partialTicks;
        float rotationYaw = abstractclientplayer.field_70126_B + (abstractclientplayer.field_70177_z - abstractclientplayer.field_70126_B) * partialTicks;
        boolean doRenderMainHand = true;
        boolean doRenderOffHand = true;
        if (abstractclientplayer.func_184587_cr() && !(itemstack = abstractclientplayer.func_184607_cu()).func_190926_b() && itemstack.func_77973_b() == Items.field_151031_f) {
            EnumHand enumhand1 = abstractclientplayer.func_184600_cs();
            doRenderMainHand = enumhand1 == EnumHand.MAIN_HAND;
            doRenderOffHand = !doRenderMainHand;
        }
        this.rotateArroundXAndY(rotationPitch, rotationYaw);
        this.setLightmap();
        this.rotateArm(partialTicks);
        GlStateManager.func_179091_B();
        RenderCyberlimbHand.INSTANCE.itemStackMainHand = itemRenderer.field_187467_d;
        RenderCyberlimbHand.INSTANCE.itemStackOffHand = itemRenderer.field_187468_e;
        if (doRenderMainHand && !missingSecondArm) {
            float f3 = enumhand == EnumHand.MAIN_HAND ? swingProgress : 0.0f;
            float f5 = 1.0f - (itemRenderer.field_187470_g + (itemRenderer.field_187469_f - itemRenderer.field_187470_g) * partialTicks);
            RenderCyberlimbHand.INSTANCE.leftRobot = hasRoboLeft;
            RenderCyberlimbHand.INSTANCE.rightRobot = hasRoboRight;
            RenderCyberlimbHand.INSTANCE.renderItemInFirstPerson((AbstractClientPlayer)abstractclientplayer, partialTicks, rotationPitch, EnumHand.MAIN_HAND, f3, itemRenderer.field_187467_d, f5);
        }
        if (doRenderOffHand && !missingArm) {
            float f4 = enumhand == EnumHand.OFF_HAND ? swingProgress : 0.0f;
            float f6 = 1.0f - (itemRenderer.field_187472_i + (itemRenderer.field_187471_h - itemRenderer.field_187472_i) * partialTicks);
            RenderCyberlimbHand.INSTANCE.leftRobot = hasRoboLeft;
            RenderCyberlimbHand.INSTANCE.rightRobot = hasRoboRight;
            RenderCyberlimbHand.INSTANCE.renderItemInFirstPerson((AbstractClientPlayer)abstractclientplayer, partialTicks, rotationPitch, EnumHand.OFF_HAND, f4, itemRenderer.field_187468_e, f6);
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
    }

    private void rotateArroundXAndY(float angle, float angleY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void setLightmap() {
        EntityPlayerSP entityPlayer = EssentialsMissingHandlerClient.mc.field_71439_g;
        int i = EssentialsMissingHandlerClient.mc.field_71441_e.func_175626_b(new BlockPos(entityPlayer.field_70165_t, entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e(), entityPlayer.field_70161_v), 0);
        float f = i & 0xFFFF;
        float f1 = i >> 16;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)f, (float)f1);
    }

    private void rotateArm(float p_187458_1_) {
        EntityPlayerSP entityPlayerSP = EssentialsMissingHandlerClient.mc.field_71439_g;
        float f = entityPlayerSP.field_71164_i + (entityPlayerSP.field_71155_g - entityPlayerSP.field_71164_i) * p_187458_1_;
        float f1 = entityPlayerSP.field_71163_h + (entityPlayerSP.field_71154_f - entityPlayerSP.field_71163_h) * p_187458_1_;
        GlStateManager.func_179114_b((float)((entityPlayerSP.field_70125_A - f) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((entityPlayerSP.field_70177_z - f1) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    @SubscribeEvent
    public void handleWorldUnload(WorldEvent.Unload event) {
        if (missingArm) {
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            missingArm = false;
            settings.field_186715_A = oldHand;
        }
    }

    static {
        mc = Minecraft.func_71410_x();
    }
}

