/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.ArmorClass;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.DodgePacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemBrainUpgrade
extends ItemCyberware
implements IMenuItem {
    public static final int META_CORTICAL_STACK = 0;
    public static final int META_ENDER_JAMMER = 1;
    public static final int META_CONSCIOUSNESS_TRANSMITTER = 2;
    public static final int META_NEURAL_CONTEXTUALIZER = 3;
    public static final int META_THREAT_MATRIX = 4;
    public static final int META_RADIO = 5;
    private static final Map<UUID, Boolean> isContextWorking = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> isMatrixWorking = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> isRadioWorking = new HashMap<UUID, Boolean>();
    private static final ArrayList<String> lastHits = new ArrayList();
    private static final float[] f = new float[]{1.0f, 0.0f, 0.0f};

    public ItemBrainUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return other.func_77973_b() == this && stack.func_77952_i() == 0 && other.func_77952_i() == 2;
    }

    @SubscribeEvent
    public void handleTeleJam(EnderTeleportEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (!ItemBrainUpgrade.isTeleportationAllowed(entityLivingBase)) {
            event.setCanceled(true);
        }
    }

    public static boolean isTeleportationAllowed(@Nullable EntityLivingBase entityLivingBase) {
        ItemStack itemStackJammerSelf;
        if (entityLivingBase == null) {
            return true;
        }
        ItemStack itemStackJammer = CyberwareContent.brainUpgrades.getCachedStack(1);
        ICyberwareUserData cyberwareUserDataSelf = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserDataSelf != null && !(itemStackJammerSelf = cyberwareUserDataSelf.getCyberware(itemStackJammer)).func_190926_b() && EnableDisableHelper.isEnabled(itemStackJammerSelf)) {
            return false;
        }
        float range = 25.0f;
        List entitiesInRange = entityLivingBase.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(entityLivingBase.field_70165_t - (double)range, entityLivingBase.field_70163_u - (double)range, entityLivingBase.field_70161_v - (double)range, entityLivingBase.field_70165_t + (double)entityLivingBase.field_70130_N + (double)range, entityLivingBase.field_70163_u + (double)entityLivingBase.field_70131_O + (double)range, entityLivingBase.field_70161_v + (double)entityLivingBase.field_70130_N + (double)range));
        for (EntityLivingBase entityInRange : entitiesInRange) {
            ItemStack itemStackJammerInRange;
            ICyberwareUserData cyberwareUserDataInRange;
            if (!(entityLivingBase.func_70068_e((Entity)entityInRange) <= (double)(range * range)) || (cyberwareUserDataInRange = CyberwareAPI.getCapabilityOrNull((Entity)entityInRange)) == null || (itemStackJammerInRange = cyberwareUserDataInRange.getCyberware(itemStackJammer)).func_190926_b() || !EnableDisableHelper.isEnabled(itemStackJammerInRange)) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void handleClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            EntityPlayer entityPlayerOriginal = event.getOriginal();
            if (entityPlayerOriginal.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                return;
            }
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayerOriginal);
            if (cyberwareUserData == null) {
                return;
            }
            if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(0))) {
                if (!entityPlayerOriginal.field_70170_p.field_72995_K) {
                    ItemStack stack = new ItemStack(CyberwareContent.expCapsule);
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    tagCompound.func_74768_a("xp", entityPlayerOriginal.field_71067_cb);
                    stack.func_77982_d(tagCompound);
                    EntityItem item = new EntityItem(entityPlayerOriginal.field_70170_p, entityPlayerOriginal.field_70165_t, entityPlayerOriginal.field_70163_u, entityPlayerOriginal.field_70161_v, stack);
                    entityPlayerOriginal.field_70170_p.func_72838_d((Entity)item);
                }
            } else if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(2))) {
                event.getEntityPlayer().func_71023_q((int)((float)Math.min(100, entityPlayerOriginal.field_71068_ca * 7) * 0.9f));
            }
        }
    }

    @SubscribeEvent
    public void handleMining(PlayerEvent.BreakSpeed event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData == null) {
            return;
        }
        ItemStack itemStackNeuralContextualizer = cyberwareUserData.getCyberware(this.getCachedStack(3));
        if (!itemStackNeuralContextualizer.func_190926_b() && EnableDisableHelper.isEnabled(itemStackNeuralContextualizer) && this.isContextWorking((EntityLivingBase)entityPlayer) && !entityPlayer.func_70093_af()) {
            IBlockState state = event.getState();
            ItemStack tool = entityPlayer.func_184586_b(EnumHand.MAIN_HAND);
            if (!tool.func_190926_b() && (tool.func_77973_b() instanceof ItemSword || tool.func_77973_b().func_77658_a().contains("sword"))) {
                return;
            }
            if (this.isToolEffective(tool, state)) {
                return;
            }
            for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                ItemStack potentialTool;
                if (indexSlot == entityPlayer.field_71071_by.field_70461_c || !this.isToolEffective(potentialTool = (ItemStack)entityPlayer.field_71071_by.field_70462_a.get(indexSlot), state)) continue;
                entityPlayer.field_71071_by.field_70461_c = indexSlot;
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase.field_70173_aa % 20 != 0) {
            return;
        }
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        ItemStack itemStackNeuralContextualizer = cyberwareUserData.getCyberware(this.getCachedStack(3));
        if (!itemStackNeuralContextualizer.func_190926_b() && EnableDisableHelper.isEnabled(itemStackNeuralContextualizer)) {
            isContextWorking.put(entityLivingBase.func_110124_au(), cyberwareUserData.usePower(itemStackNeuralContextualizer, this.getPowerConsumption(itemStackNeuralContextualizer)));
        } else {
            isContextWorking.put(entityLivingBase.func_110124_au(), Boolean.FALSE);
        }
        ItemStack itemStackThreatMatrix = cyberwareUserData.getCyberware(this.getCachedStack(4));
        if (!itemStackThreatMatrix.func_190926_b()) {
            isMatrixWorking.put(entityLivingBase.func_110124_au(), cyberwareUserData.usePower(itemStackThreatMatrix, this.getPowerConsumption(itemStackThreatMatrix)));
        } else {
            isMatrixWorking.put(entityLivingBase.func_110124_au(), Boolean.FALSE);
        }
        ItemStack itemStackRadio = cyberwareUserData.getCyberware(this.getCachedStack(5));
        if (!itemStackRadio.func_190926_b() && EnableDisableHelper.isEnabled(itemStackRadio)) {
            isRadioWorking.put(entityLivingBase.func_110124_au(), cyberwareUserData.usePower(itemStackRadio, this.getPowerConsumption(itemStackRadio)));
        } else {
            isRadioWorking.put(entityLivingBase.func_110124_au(), Boolean.FALSE);
        }
    }

    public static boolean isRadioWorking(EntityLivingBase entityLivingBase) {
        if (!isRadioWorking.containsKey(entityLivingBase.func_110124_au())) {
            isRadioWorking.put(entityLivingBase.func_110124_au(), Boolean.FALSE);
        }
        return isRadioWorking.get(entityLivingBase.func_110124_au());
    }

    private boolean isContextWorking(EntityLivingBase entityLivingBase) {
        if (!isContextWorking.containsKey(entityLivingBase.func_110124_au())) {
            isContextWorking.put(entityLivingBase.func_110124_au(), Boolean.FALSE);
        }
        return isContextWorking.get(entityLivingBase.func_110124_au());
    }

    private boolean isMatrixWorking(EntityLivingBase entityLivingBase) {
        if (!isMatrixWorking.containsKey(entityLivingBase.func_110124_au())) {
            isMatrixWorking.put(entityLivingBase.func_110124_au(), Boolean.FALSE);
        }
        return isMatrixWorking.get(entityLivingBase.func_110124_au());
    }

    public boolean isToolEffective(ItemStack tool, IBlockState state) {
        if (!tool.func_190926_b()) {
            for (String toolType : tool.func_77973_b().getToolClasses(tool)) {
                if (!state.func_177230_c().isToolEffective(toolType, state)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void handleXPDrop(LivingExperienceDropEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData == null) {
            return;
        }
        if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(0)) || cyberwareUserData.isCyberwareInstalled(this.getCachedStack(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleHurt(LivingAttackEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (!this.isMatrixWorking(entityLivingBase)) {
            return;
        }
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData == null) {
            return;
        }
        if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(4)) && !entityLivingBase.field_70170_p.field_72995_K && event.getSource() instanceof EntityDamageSource) {
            ArmorClass armorClass;
            Entity attacker = event.getSource().func_76346_g();
            if (entityLivingBase instanceof EntityPlayer) {
                String str = entityLivingBase.func_145782_y() + " " + entityLivingBase.field_70173_aa + " " + (attacker == null ? -1 : attacker.func_145782_y());
                if (lastHits.contains(str)) {
                    return;
                }
                lastHits.add(str);
            }
            if ((armorClass = ArmorClass.get(entityLivingBase)) == ArmorClass.HEAVY) {
                return;
            }
            if ((float)entityLivingBase.field_70172_ad <= (float)entityLivingBase.field_70771_an / 2.0f) {
                Random random = entityLivingBase.func_70681_au();
                float f = random.nextFloat();
                float f2 = armorClass == ArmorClass.LIGHT ? 0.7f : 0.65f;
                if (f < f2) {
                    event.setCanceled(true);
                    entityLivingBase.field_70172_ad = entityLivingBase.field_70771_an;
                    entityLivingBase.field_70738_aO = 10;
                    entityLivingBase.field_70737_aN = 10;
                    entityLivingBase.field_110153_bc = 9999.0f;
                    CyberwarePacketHandler.INSTANCE.sendToAllAround((IMessage)new DodgePacket(entityLivingBase.func_145782_y()), new NetworkRegistry.TargetPoint(entityLivingBase.field_70170_p.field_73011_w.getDimension(), entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, 50.0));
                }
            }
        }
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 3 ? 1 : (stack.func_77952_i() == 4 ? 8 : (stack.func_77952_i() == 5 ? 2 : 0));
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 1 || stack.func_77952_i() == 3 || stack.func_77952_i() == 5;
    }

    @Override
    public void use(Entity entity, ItemStack stack) {
        EnableDisableHelper.toggle(stack);
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }
}

