/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemCyberlimb
extends ItemCyberware
implements ICyberware.ISidedLimb {
    public static final int META_LEFT_CYBER_ARM = 0;
    public static final int META_RIGHT_CYBER_ARM = 1;
    public static final int META_LEFT_CYBER_LEG = 2;
    public static final int META_RIGHT_CYBER_LEG = 3;
    private Set<Integer> didFall = new HashSet<Integer>();

    public ItemCyberlimb(String name, ICyberware.EnumSlot[] slots, String[] subnames) {
        super(name, slots, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEssential(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        ICyberware ware = CyberwareAPI.getCyberware(other);
        if (ware instanceof ICyberware.ISidedLimb) {
            return ware.isEssential(other) && ((ICyberware.ISidedLimb)((Object)ware)).getSide(other) == this.getSide(stack);
        }
        return false;
    }

    @Override
    public ICyberware.ISidedLimb.EnumSide getSide(ItemStack stack) {
        return stack.func_77952_i() % 2 == 0 ? ICyberware.ISidedLimb.EnumSide.LEFT : ICyberware.ISidedLimb.EnumSide.RIGHT;
    }

    public static boolean isPowered(ItemStack stack) {
        NBTTagCompound data = CyberwareAPI.getCyberwareNBT(stack);
        if (!data.func_74764_b("active")) {
            data.func_74757_a("active", true);
        }
        return data.func_74767_n("active");
    }

    @SubscribeEvent
    public void handleFallDamage(LivingAttackEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase.field_70170_p.field_72995_K && event.getSource() == DamageSource.field_76379_h) {
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
            if (cyberwareUserData == null) {
                return;
            }
            if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(2)) && cyberwareUserData.isCyberwareInstalled(this.getCachedStack(3))) {
                this.didFall.add(entityLivingBase.func_145782_y());
            }
        }
    }

    @SubscribeEvent
    public void handleSound(PlaySoundAtEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && event.getSound() == SoundEvents.field_187800_eb && entity.field_70170_p.field_72995_K && this.didFall.contains(entity.func_145782_y())) {
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull(entity);
            if (cyberwareUserData == null) {
                return;
            }
            int numLegs = 0;
            if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(2))) {
                ++numLegs;
            }
            if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(3))) {
                ++numLegs;
            }
            if (numLegs > 0) {
                event.setSound(SoundEvents.field_187602_cF);
                event.setPitch(event.getPitch() + 1.0f);
                this.didFall.remove(entity.func_145782_y());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase.field_70173_aa % 20 != 0) {
            return;
        }
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        for (int damage = 0; damage < 4; ++damage) {
            ItemStack itemStackInstalled = cyberwareUserData.getCyberware(this.getCachedStack(damage));
            if (itemStackInstalled.func_190926_b()) continue;
            boolean isPowered = cyberwareUserData.usePower(itemStackInstalled, this.getPowerConsumption(itemStackInstalled));
            CyberwareAPI.getCyberwareNBT(itemStackInstalled).func_74757_a("active", isPowered);
        }
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return 10;
    }
}

