/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.misc.NNLUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemLegUpgrade
extends ItemCyberware {
    private static final int META_JUMP_BOOST = 0;
    private static final int META_FALL_DAMAGE = 1;

    public ItemLegUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public NonNullList<NonNullList<ItemStack>> required(ItemStack stack) {
        return NNLUtil.fromArray(new ItemStack[][]{{CyberwareContent.cyberlimbs.getCachedStack(2), CyberwareContent.cyberlimbs.getCachedStack(3)}});
    }

    @SubscribeEvent
    public void playerJumps(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData == null) {
            return;
        }
        ItemStack itemStackJumpBoost = cyberwareUserData.getCyberware(this.getCachedStack(0));
        if (!itemStackJumpBoost.func_190926_b()) {
            int numLegs = 0;
            if (cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(2))) {
                ++numLegs;
            }
            if (cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(3))) {
                ++numLegs;
            }
            if (cyberwareUserData.usePower(itemStackJumpBoost, this.getPowerConsumption(itemStackJumpBoost))) {
                if (entityLivingBase.func_70093_af()) {
                    Vec3d vector = entityLivingBase.func_70676_i(0.5f);
                    double total = Math.abs(vector.field_72449_c + vector.field_72450_a);
                    double jump = 0.0;
                    if (jump >= 1.0) {
                        jump = (jump + 2.0) / 4.0;
                    }
                    double y = vector.field_72448_b < total ? total : vector.field_72448_b;
                    entityLivingBase.field_70181_x += (double)numLegs * ((jump + 1.0) * y) / 3.0;
                    entityLivingBase.field_70179_y += (jump + 1.0) * vector.field_72449_c * (double)numLegs;
                    entityLivingBase.field_70159_w += (jump + 1.0) * vector.field_72450_a * (double)numLegs;
                } else {
                    entityLivingBase.field_70181_x += (double)numLegs * (double)0.1375f;
                }
            }
        }
    }

    @SubscribeEvent
    public void onFallDamage(LivingAttackEvent event) {
        if (event.getSource() != DamageSource.field_76379_h) {
            return;
        }
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData == null) {
            return;
        }
        if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(1)) && cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(2)) && cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(3))) {
            event.setCanceled(true);
        }
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 0 : 0;
    }
}

