/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemLowerOrgansUpgrade
extends ItemCyberware
implements IMenuItem {
    public static final int META_LIVER_FILTER = 0;
    public static final int META_METABOLIC_GENERATOR = 1;
    public static final int META_BATTERY = 2;
    public static final int META_ADRENALINE_PUMP = 3;
    private static Map<UUID, Collection<PotionEffect>> mapPotions = new HashMap<UUID, Collection<PotionEffect>>();
    private static final float[] f = new float[]{1.0f, 0.0f, 0.0f};

    public ItemLowerOrgansUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void handleEatFoodTick(LivingEntityUseItemEvent.Tick event) {
        ICyberwareUserData cyberwareUserData;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
        ItemStack stack = event.getItem();
        if (!stack.func_190926_b() && (stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT || stack.func_77973_b().func_77661_b(stack) == EnumAction.DRINK) && (cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer)) != null && cyberwareUserData.isCyberwareInstalled(this.getCachedStack(0))) {
            mapPotions.put(entityPlayer.func_110124_au(), new ArrayList(entityPlayer.func_70651_bq()));
        }
    }

    @SubscribeEvent
    public void handleEatFoodEnd(LivingEntityUseItemEvent.Finish event) {
        ICyberwareUserData cyberwareUserData;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
        ItemStack stack = event.getItem();
        if (!stack.func_190926_b() && (stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT || stack.func_77973_b().func_77661_b(stack) == EnumAction.DRINK) && (cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer)) != null && cyberwareUserData.isCyberwareInstalled(this.getCachedStack(0))) {
            ArrayList potionEffectsRemoved = new ArrayList(entityPlayer.func_70651_bq());
            for (PotionEffect potionEffect : potionEffectsRemoved) {
                if (!potionEffect.func_188419_a().func_76398_f()) continue;
                entityPlayer.func_184589_d(potionEffect.func_188419_a());
            }
            Collection<PotionEffect> potionEffectsToAdd = mapPotions.get(entityPlayer.func_110124_au());
            if (potionEffectsToAdd != null) {
                block1: for (PotionEffect potionEffectToAdd : potionEffectsToAdd) {
                    for (PotionEffect potionEffectRemoved : potionEffectsRemoved) {
                        if (potionEffectRemoved.func_188419_a() != potionEffectToAdd.func_188419_a()) continue;
                        entityPlayer.func_70690_d(potionEffectToAdd);
                        continue block1;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        ItemStack itemStackAdrenalinePump;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase.field_70173_aa % 20 != 0) {
            return;
        }
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        ItemStack itemStackMetabolicGenerator = cyberwareUserData.getCyberware(this.getCachedStack(1));
        if (!itemStackMetabolicGenerator.func_190926_b() && EnableDisableHelper.isEnabled(itemStackMetabolicGenerator) && !cyberwareUserData.isAtCapacity(itemStackMetabolicGenerator, this.getPowerProduction(itemStackMetabolicGenerator))) {
            if (entityLivingBase instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
                if (entityPlayer.func_71024_bL().func_75116_a() > 0 || entityPlayer.func_184812_l_()) {
                    int toRemove = this.getTicksTilRemove(itemStackMetabolicGenerator);
                    if (!entityPlayer.func_184812_l_() && toRemove <= 0) {
                        entityPlayer.func_71024_bL().func_75113_a(6.0f);
                        toRemove = 54;
                    } else if (toRemove > 0) {
                        --toRemove;
                    }
                    CyberwareAPI.getCyberwareNBT(itemStackMetabolicGenerator).func_74768_a("toRemove", toRemove);
                    cyberwareUserData.addPower(this.getPowerProduction(itemStackMetabolicGenerator), itemStackMetabolicGenerator);
                }
            } else {
                cyberwareUserData.addPower(this.getPowerProduction(itemStackMetabolicGenerator) / 10, itemStackMetabolicGenerator);
            }
        }
        if (!(itemStackAdrenalinePump = cyberwareUserData.getCyberware(this.getCachedStack(3))).func_190926_b()) {
            boolean wasBelow = this.wasBelow(itemStackAdrenalinePump);
            boolean isBelow = false;
            if (entityLivingBase.func_110138_aP() > 8.0f && entityLivingBase.func_110143_aJ() < 8.0f) {
                isBelow = true;
                if (!wasBelow && cyberwareUserData.usePower(itemStackAdrenalinePump, this.getPowerConsumption(itemStackAdrenalinePump), false)) {
                    entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 600, 0, true, false));
                    entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 600, 0, true, false));
                }
            }
            CyberwareAPI.getCyberwareNBT(itemStackAdrenalinePump).func_74757_a("wasBelow", isBelow);
        }
    }

    private int getTicksTilRemove(ItemStack stack) {
        NBTTagCompound data = CyberwareAPI.getCyberwareNBT(stack);
        if (!data.func_74764_b("toRemove")) {
            data.func_74768_a("toRemove", 54);
        }
        return data.func_74762_e("toRemove");
    }

    private boolean wasBelow(ItemStack stack) {
        NBTTagCompound data = CyberwareAPI.getCyberwareNBT(stack);
        if (!data.func_74764_b("wasBelow")) {
            data.func_74757_a("wasBelow", false);
        }
        return data.func_74767_n("wasBelow");
    }

    @Override
    public int getCapacity(ItemStack wareStack) {
        return wareStack.func_77952_i() == 1 ? 25 : (wareStack.func_77952_i() == 2 ? 3000 * wareStack.func_190916_E() : 0);
    }

    @Override
    public int installedStackSize(ItemStack stack) {
        return stack.func_77952_i() == 2 ? 4 : 1;
    }

    @Override
    public int getPowerProduction(ItemStack stack) {
        return stack.func_77952_i() == 1 ? 25 : 0;
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 3 ? 150 : 0;
    }

    @Override
    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        if (stack.func_77952_i() == 2) {
            switch (stack.func_190916_E()) {
                case 1: {
                    return 5;
                }
                case 2: {
                    return 7;
                }
                case 3: {
                    return 9;
                }
                case 4: {
                    return 11;
                }
            }
        }
        return super.getUnmodifiedEssenceCost(stack);
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }

    @Override
    public void use(Entity entity, ItemStack stack) {
        EnableDisableHelper.toggle(stack);
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }
}

